/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jasypt.util.text.BasicTextEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProtectedContentUtil {
    private final Logger log = LoggerFactory.getLogger(ProtectedContentUtil.class);
    private final BasicTextEncryptor textEncryptor;
    public static final Instant MAX_INSTANT = Instant.parse("9990-12-30T23:59:59Z");
    @Autowired
    private ProtectedContentRepository protContentRepository;

    public ProtectedContentUtil(@Value(value="${protectionSecret:S3cr3t}") String protectionSecretFallback, @Value(value="${ca3s.protectionSecret}") String protectionSecret) {
        if (protectionSecretFallback != null && !protectionSecretFallback.trim().isEmpty()) {
            protectionSecret = protectionSecretFallback;
        }
        if (protectionSecret == null || protectionSecret.trim().length() == 0) {
            this.log.warn("Configuration parameter 'protectionSecret' missing or invalid!!");
            throw new UnsupportedOperationException("Configuration parameter 'protectionSecret' missing or invalid");
        }
        if (this.log.isDebugEnabled()) {
            String paddedSecret = "******" + protectionSecret;
            this.log.debug("using protection secret '{}'", (Object)("******" + paddedSecret.substring(paddedSecret.length() - 4)));
        }
        this.textEncryptor = new BasicTextEncryptor();
        this.textEncryptor.setPassword(protectionSecret);
    }

    public String protectString(String content) {
        return this.textEncryptor.encrypt(content);
    }

    public String unprotectString(String protectedContent) {
        return this.textEncryptor.decrypt(protectedContent);
    }

    public ProtectedContent createProtectedContent(String plainText, ProtectedContentType pct, ContentRelationType crt, long connectionId) {
        return this.createProtectedContent(plainText, pct, crt, connectionId, -1, MAX_INSTANT);
    }

    public ProtectedContent createProtectedContent(String plainText, ProtectedContentType pct, ContentRelationType crt, long connectionId, int leftUsages, Instant validTo) {
        ProtectedContent pc = new ProtectedContent();
        pc.setContentBase64(this.protectString(plainText));
        pc.setType(pct);
        pc.setRelationType(crt);
        pc.setRelatedId(Long.valueOf(connectionId));
        pc.setLeftUsages(Integer.valueOf(leftUsages));
        pc.setValidTo(validTo);
        pc.setDeleteAfter(validTo.plus(1L, ChronoUnit.DAYS));
        this.protContentRepository.save((Object)pc);
        return pc;
    }

    public List<ProtectedContent> retrieveProtectedContent(ProtectedContentType type, ContentRelationType crt, long id) {
        List pcList = this.protContentRepository.findByTypeRelationId(type, crt, Long.valueOf(id));
        Instant now = Instant.now();
        Predicate<ProtectedContent> usableItem = pc -> (pc.getLeftUsages() == -1 || pc.getLeftUsages() > 0) && pc.getValidTo().isAfter(now);
        return pcList.stream().filter(usableItem).collect(Collectors.toList());
    }
}

