/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.AcmeChallenge;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.service.AcmeChallengeService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class AcmeChallengeResource {
    private final Logger log = LoggerFactory.getLogger(AcmeChallengeResource.class);
    private static final String ENTITY_NAME = "acmeChallenge";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AcmeChallengeService acmeChallengeService;

    public AcmeChallengeResource(AcmeChallengeService acmeChallengeService) {
        this.acmeChallengeService = acmeChallengeService;
    }

    @PostMapping(value={"/acme-challenges"})
    public ResponseEntity<AcmeChallenge> createAcmeChallenge(@Valid @RequestBody AcmeChallenge acmeChallenge) throws URISyntaxException {
        this.log.debug("REST request to save AcmeChallenge : {}", (Object)acmeChallenge);
        if (acmeChallenge.getId() != null) {
            throw new BadRequestAlertException("A new acmeChallenge cannot already have an ID", ENTITY_NAME, "idexists");
        }
        AcmeChallenge result = this.acmeChallengeService.save(acmeChallenge);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/acme-challenges/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/acme-challenges"})
    public ResponseEntity<AcmeChallenge> updateAcmeChallenge(@Valid @RequestBody AcmeChallenge acmeChallenge) throws URISyntaxException {
        this.log.debug("REST request to update AcmeChallenge : {}", (Object)acmeChallenge);
        if (acmeChallenge.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        AcmeChallenge result = this.acmeChallengeService.save(acmeChallenge);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)acmeChallenge.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/acme-challenges"})
    public List<AcmeChallenge> getAllAcmeChallenges() {
        this.log.debug("REST request to get all AcmeChallenges");
        return this.acmeChallengeService.findAll();
    }

    @GetMapping(value={"/acme-challenges/{id}"})
    public ResponseEntity<AcmeChallenge> getAcmeChallenge(@PathVariable Long id) {
        this.log.debug("REST request to get AcmeChallenge : {}", (Object)id);
        Optional acmeChallenge = this.acmeChallengeService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)acmeChallenge);
    }

    @DeleteMapping(value={"/acme-challenges/{id}"})
    public ResponseEntity<Void> deleteAcmeChallenge(@PathVariable Long id) {
        this.log.debug("REST request to delete AcmeChallenge : {}", (Object)id);
        this.acmeChallengeService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

