/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.AcmeIdentifier;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.service.AcmeIdentifierService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class AcmeIdentifierResource {
    private final Logger log = LoggerFactory.getLogger(AcmeIdentifierResource.class);
    private static final String ENTITY_NAME = "acmeIdentifier";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AcmeIdentifierService acmeIdentifierService;

    public AcmeIdentifierResource(AcmeIdentifierService acmeIdentifierService) {
        this.acmeIdentifierService = acmeIdentifierService;
    }

    @PostMapping(value={"/acme-identifiers"})
    public ResponseEntity<AcmeIdentifier> createAcmeIdentifier(@Valid @RequestBody AcmeIdentifier acmeIdentifier) throws URISyntaxException {
        this.log.debug("REST request to save AcmeIdentifier : {}", (Object)acmeIdentifier);
        if (acmeIdentifier.getId() != null) {
            throw new BadRequestAlertException("A new acmeIdentifier cannot already have an ID", ENTITY_NAME, "idexists");
        }
        AcmeIdentifier result = this.acmeIdentifierService.save(acmeIdentifier);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/acme-identifiers/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/acme-identifiers"})
    public ResponseEntity<AcmeIdentifier> updateAcmeIdentifier(@Valid @RequestBody AcmeIdentifier acmeIdentifier) throws URISyntaxException {
        this.log.debug("REST request to update AcmeIdentifier : {}", (Object)acmeIdentifier);
        if (acmeIdentifier.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        AcmeIdentifier result = this.acmeIdentifierService.save(acmeIdentifier);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)acmeIdentifier.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/acme-identifiers"})
    public List<AcmeIdentifier> getAllAcmeIdentifiers() {
        this.log.debug("REST request to get all AcmeIdentifiers");
        return this.acmeIdentifierService.findAll();
    }

    @GetMapping(value={"/acme-identifiers/{id}"})
    public ResponseEntity<AcmeIdentifier> getAcmeIdentifier(@PathVariable Long id) {
        this.log.debug("REST request to get AcmeIdentifier : {}", (Object)id);
        Optional acmeIdentifier = this.acmeIdentifierService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)acmeIdentifier);
    }

    @DeleteMapping(value={"/acme-identifiers/{id}"})
    public ResponseEntity<Void> deleteAcmeIdentifier(@PathVariable Long id) {
        this.log.debug("REST request to delete AcmeIdentifier : {}", (Object)id);
        this.acmeIdentifierService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

