/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.ScepOrder;
import de.trustable.ca3s.core.service.ScepOrderService;
import de.trustable.ca3s.core.service.dto.ScepOrderView;
import de.trustable.ca3s.core.service.util.ScepOrderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.ResponseUtil;

@Transactional
@RestController
@RequestMapping(value={"/api"})
public class ScepOrderViewResource {
    private final Logger log = LoggerFactory.getLogger(ScepOrderViewResource.class);
    private final ScepOrderService scepOrderService;
    private final ScepOrderUtil scepOrderUtil;

    public ScepOrderViewResource(ScepOrderService scepOrderService, ScepOrderUtil scepOrderUtil) {
        this.scepOrderService = scepOrderService;
        this.scepOrderUtil = scepOrderUtil;
    }

    @GetMapping(value={"/scepOrderViews"})
    public List<ScepOrderView> getAllACMEOrderViews() {
        this.log.debug("REST request to get all ACMEOrderViews");
        ArrayList<ScepOrderView> avList = new ArrayList<ScepOrderView>();
        for (ScepOrder scepOrder : this.scepOrderService.findAll()) {
            avList.add(this.scepOrderUtil.from(scepOrder));
        }
        return avList;
    }

    @GetMapping(value={"/scepOrderViews/{id}"})
    public ResponseEntity<ScepOrderView> getscepOrder(@PathVariable Long id) {
        this.log.debug("REST request to get scepOrderView : {}", (Object)id);
        Optional scepOrderOptional = this.scepOrderService.findOne(id);
        Optional<Object> avOpt = Optional.empty();
        if (scepOrderOptional.isPresent()) {
            ScepOrder scepOrder = (ScepOrder)scepOrderOptional.get();
            ScepOrderView scepOrderView = this.scepOrderUtil.from(scepOrder);
            avOpt = Optional.of(scepOrderView);
        } else {
            this.log.info("acme order not found, order id '{}' unknown!", (Object)id);
        }
        return ResponseUtil.wrapOrNotFound(avOpt);
    }
}

