/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.domain.ACMEAccount;
import de.trustable.ca3s.core.domain.AcmeAuthorization;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.enumeration.AcmeOrderStatus;
import de.trustable.ca3s.core.repository.AcmeOrderRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.dto.NamedValues;
import de.trustable.ca3s.core.service.dto.acme.FinalizeRequest;
import de.trustable.ca3s.core.service.dto.acme.OrderResponse;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.ACMEUtil;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CertificateProcessingUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.JwtUtil;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import de.trustable.ca3s.core.web.rest.acme.ACMEController;
import de.trustable.util.CryptoUtil;
import de.trustable.util.OidNameMapper;
import de.trustable.util.Pkcs10RequestHolder;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.jetbrains.annotations.NotNull;
import org.jose4j.base64url.Base64Url;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@Transactional
@Controller
@RequestMapping(value={"/acme/{realm}/order"})
public class OrderController
extends ACMEController {
    private static final Logger LOG = LoggerFactory.getLogger(OrderController.class);
    private final AcmeOrderRepository orderRepository;
    private final JwtUtil jwtUtil;
    private final CryptoUtil cryptoUtil;
    private final CertificateUtil certUtil;
    private final CertificateProcessingUtil cpUtil;
    private final PipelineUtil pipelineUtil;
    private final AuditService auditService;
    private final boolean finalizeLocationBackwardCompat;

    public OrderController(AcmeOrderRepository orderRepository, JwtUtil jwtUtil, CryptoUtil cryptoUtil, CertificateUtil certUtil, CertificateProcessingUtil cpUtil, PipelineUtil pipelineUtil, AuditService auditService, @Value(value="${ca3s.acme.backward.finalize.location:true}") boolean finalizeLocationBackwardCompat) {
        this.orderRepository = orderRepository;
        this.jwtUtil = jwtUtil;
        this.cryptoUtil = cryptoUtil;
        this.certUtil = certUtil;
        this.cpUtil = cpUtil;
        this.pipelineUtil = pipelineUtil;
        this.auditService = auditService;
        this.finalizeLocationBackwardCompat = finalizeLocationBackwardCompat;
    }

    @RequestMapping(value={"/{orderId}"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/jose+json"})
    public ResponseEntity<?> postAsGetOrder(@RequestBody String requestBody, @PathVariable long orderId, @PathVariable String realm) {
        LOG.info("Received read order request for orderId {}", (Object)orderId);
        try {
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            ACMEAccount acctDao = this.checkJWTSignatureForAccount(context, realm);
            HttpHeaders additionalHeaders = this.buildNonceHeader();
            List orderList = this.orderRepository.findByOrderId(orderId);
            if (orderList.isEmpty()) {
                LOG.debug("reading attempt for non-existing orderId {}", (Object)orderId);
                return ResponseEntity.notFound().headers(additionalHeaders).build();
            }
            AcmeOrder orderDao = (AcmeOrder)orderList.get(0);
            if (!orderDao.getAccount().equals((Object)acctDao)) {
                LOG.error("Account identified by key (account {}) does not match account {} of requested order", (Object)acctDao, (Object)orderDao.getAccount());
                return ResponseEntity.badRequest().build();
            }
            this.updateAcmeOrderState(orderDao);
            UriComponentsBuilder baseUriBuilder = ServletUriComponentsBuilder.fromCurrentRequestUri().path("../../..");
            LOG.debug("postAsGetOrder: baseUriBuilder : " + baseUriBuilder.toUriString());
            return this.buildOrderResponse(additionalHeaders, orderDao, baseUriBuilder, true);
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
    }

    private void updateAcmeOrderState(AcmeOrder orderDao) {
        AcmeOrderStatus acmeOrderStatus;
        Instant now = Instant.now();
        if (now.isAfter(orderDao.getExpires()) && !AcmeOrderStatus.INVALID.equals((Object)(acmeOrderStatus = orderDao.getStatus()))) {
            LOG.debug("pending order {} expired on {}, setting to state 'INVALID'", (Object)orderDao.getOrderId(), (Object)orderDao.getExpires().toString());
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceACMEOrderExpired(orderDao.getAccount(), orderDao));
            orderDao.setStatus(AcmeOrderStatus.INVALID);
            this.orderRepository.save((Object)orderDao);
        }
    }

    @RequestMapping(value={"/finalize/{orderId}"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/jose+json"})
    public ResponseEntity<?> finalizeOrder(@RequestBody String requestBody, @PathVariable long orderId, @PathVariable String realm) {
        LOG.info("Received finalize order request ");
        Pipeline pipeline = this.getPipelineForRealm(realm);
        try {
            Pkcs10RequestHolder p10Holder;
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            FinalizeRequest finalizeReq = this.jwtUtil.getFinalizeReq(context.getJwtClaims());
            ACMEAccount acctDao = this.checkJWTSignatureForAccount(context, realm);
            HttpHeaders additionalHeaders = this.buildNonceHeader();
            List orderList = this.orderRepository.findByOrderId(orderId);
            if (orderList.isEmpty()) {
                return ResponseEntity.notFound().headers(additionalHeaders).build();
            }
            AcmeOrder orderDao = (AcmeOrder)orderList.get(0);
            if (!orderDao.getAccount().equals((Object)acctDao)) {
                LOG.error("Account identified by key (account {}) does not match account {} of requested order", (Object)acctDao, (Object)orderDao.getAccount());
                return ResponseEntity.badRequest().build();
            }
            this.updateAcmeOrderState(orderDao);
            if (orderDao.getStatus() == AcmeOrderStatus.READY) {
                String csrAsString = finalizeReq.getCsr();
                LOG.debug("csr received: " + csrAsString);
                byte[] csrByte = Base64Url.decode((String)csrAsString);
                p10Holder = this.cryptoUtil.parseCertificateRequest(csrByte);
                LOG.debug("csr decoded: " + p10Holder);
                List accListExisting = this.acctRepository.findByPublicKeyHashBase64(this.jwtUtil.getJWKThumbPrint(p10Holder.getPublicSigningKey()));
                if (!accListExisting.isEmpty()) {
                    LOG.debug("public key in csr already used for account #" + ((ACMEAccount)accListExisting.get(0)).getAccountId());
                    ProblemDetail problem = new ProblemDetail(ACMEUtil.BAD_CSR, "CSR rejected.", HttpStatus.BAD_REQUEST, "Public key of CSR already in use ", NO_INSTANCE);
                    throw new AcmeProblemException(problem);
                }
                Set snSet = this.collectAllSANS(p10Holder);
                for (String san : snSet) {
                    boolean bSanFound = false;
                    for (AcmeAuthorization authDao : orderDao.getAcmeAuthorizations()) {
                        if (!san.equalsIgnoreCase(authDao.getValue())) continue;
                        LOG.debug("san '{}' part of order {} in authorization {}", new Object[]{san, orderDao.getOrderId(), authDao});
                        bSanFound = true;
                        break;
                    }
                    if (bSanFound) continue;
                    String msg = "failed to find requested hostname '" + san + "' (from CSR) in authorization for order " + orderDao.getOrderId();
                    LOG.info(msg);
                    orderDao.setStatus(AcmeOrderStatus.INVALID);
                    this.orderRepository.save((Object)orderDao);
                    throw new AcmeProblemException(new ProblemDetail(ACMEUtil.BAD_CSR, msg, HttpStatus.BAD_REQUEST, NO_DETAIL, NO_INSTANCE));
                }
                ArrayList messageList = new ArrayList();
                if (!this.pipelineUtil.isPipelineRestrictionsResolved(pipeline, p10Holder, messageList)) {
                    String detail = NO_DETAIL;
                    if (!messageList.isEmpty()) {
                        detail = (String)messageList.get(0);
                    }
                    ProblemDetail problem = new ProblemDetail(ACMEUtil.BAD_CSR, "Restriction check failed.", HttpStatus.BAD_REQUEST, detail, NO_INSTANCE);
                    throw new AcmeProblemException(problem);
                }
            } else {
                String msg = "unexpected finalize call at order status " + orderDao.getStatus() + " for order " + orderDao.getOrderId();
                LOG.debug(msg);
                throw new AcmeProblemException(new ProblemDetail(ACMEUtil.ORDER_NOT_READY, msg, HttpStatus.BAD_REQUEST, NO_DETAIL, NO_INSTANCE));
            }
            LOG.debug("order status {} changes to 'processing' for order {}", (Object)orderDao.getStatus(), (Object)orderDao.getOrderId());
            orderDao.setStatus(AcmeOrderStatus.PROCESSING);
            this.orderRepository.save((Object)orderDao);
            LOG.debug("order {} status 'valid', producing certificate", (Object)orderDao.getOrderId());
            this.startCertificateCreationProcess(orderDao, pipeline, "ACME_ACCOUNT_" + acctDao.getAccountId(), CryptoUtil.pkcs10RequestToPem((PKCS10CertificationRequest)p10Holder.getP10Req()));
            LOG.debug("order status {} changes to valid for order {}", (Object)orderDao.getStatus(), (Object)orderDao.getOrderId());
            orderDao.setStatus(AcmeOrderStatus.VALID);
            this.orderRepository.save((Object)orderDao);
            boolean valid = true;
            UriComponentsBuilder baseUriBuilder = ServletUriComponentsBuilder.fromCurrentRequestUri().path("../../../..");
            LOG.debug("finalize: baseUriBuilder : " + baseUriBuilder.toUriString());
            return this.buildOrderResponse(additionalHeaders, orderDao, baseUriBuilder, valid);
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
        catch (IOException | GeneralSecurityException | JoseException e) {
            ProblemDetail problem = new ProblemDetail(ACMEUtil.SERVER_INTERNAL, e.getMessage(), HttpStatus.BAD_REQUEST, NO_DETAIL, NO_INSTANCE);
            return this.buildProblemResponseEntity(new AcmeProblemException(problem));
        }
    }

    @NotNull
    private Set<String> collectAllSANS(Pkcs10RequestHolder p10Holder) {
        HashSet<String> snSet = new HashSet<String>();
        for (RDN rDN : p10Holder.getSubjectRDNs()) {
            for (AttributeTypeAndValue atv : rDN.getTypesAndValues()) {
                if (!BCStyle.CN.equals((ASN1Primitive)atv.getType())) continue;
                String cnValue = atv.getValue().toString();
                LOG.debug("cn found in CSR: " + cnValue);
                snSet.add(cnValue);
            }
        }
        for (RDN rDN : p10Holder.getReqAttributes()) {
            String attrOid = rDN.getAttrType().getId();
            String attrReadableName = OidNameMapper.lookupOid((String)attrOid);
            if (PKCSObjectIdentifiers.pkcs_9_at_extensionRequest.equals((ASN1Primitive)rDN.getAttrType())) {
                LOG.debug("CSR contains extensionRequest");
                this.retrieveSANFromCSRAttribute(snSet, (Attribute)rDN);
                continue;
            }
            if ("certReqExtensions".equals(attrReadableName)) {
                LOG.debug("CSR contains attrReadableName");
                this.retrieveSANFromCSRAttribute(snSet, (Attribute)rDN);
                continue;
            }
            String value = this.getASN1ValueAsString((Attribute)rDN);
            LOG.debug("found attrReadableName '{}' with value '{}'", (Object)attrReadableName, (Object)value);
        }
        return snSet;
    }

    private ResponseEntity<OrderResponse> buildOrderResponse(HttpHeaders additionalHeaders, AcmeOrder orderDao, UriComponentsBuilder baseUriBuilder, boolean valid) {
        HashSet<String> authorizationsResp = new HashSet<String>();
        for (AcmeAuthorization authDao : orderDao.getAcmeAuthorizations()) {
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUri((URI)baseUriBuilder.build().normalize().toUri());
            LOG.debug("uriBuilder: {}", (Object)uriBuilder.toUriString());
            UriComponentsBuilder uriBuilderOrder = uriBuilder.path(this.ORDER_RESOURCE_MAPPING);
            LOG.debug("uriBuilderOrder: {}", (Object)uriBuilderOrder.toUriString());
            String authUrl = this.locationUriOfAuth(authDao.getAcmeAuthorizationId().longValue(), uriBuilderOrder).toString();
            authorizationsResp.add(authUrl);
            LOG.debug("authUrl: {}", (Object)authUrl);
        }
        if (this.finalizeLocationBackwardCompat) {
            String orderLocation = ServletUriComponentsBuilder.fromCurrentRequestUri().build().toUriString();
            additionalHeaders.add("location", orderLocation);
            LOG.debug("added location header '{}' for backward compatibility reasons.", (Object)orderLocation);
        }
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUri((URI)baseUriBuilder.build().normalize().toUri());
        String finalizeUrl = uriBuilder.path(this.ORDER_RESOURCE_MAPPING).path("/finalize/").path(Long.toString(orderDao.getOrderId())).build().toUriString();
        LOG.debug("order request finalize url: {}", (Object)finalizeUrl);
        String certificateUrl = null;
        if (orderDao.getCertificate() != null) {
            long certId = orderDao.getCertificate().getId();
            uriBuilder = UriComponentsBuilder.fromUri((URI)baseUriBuilder.build().normalize().toUri());
            certificateUrl = uriBuilder.path(this.CERTIFICATE_RESOURCE_MAPPING).path("/").path(Long.toString(certId)).build().toUriString();
            LOG.debug("order request cert url: {}", (Object)certificateUrl);
        }
        OrderResponse orderResp = new OrderResponse(orderDao, authorizationsResp, finalizeUrl, certificateUrl);
        if (LOG.isDebugEnabled()) {
            LOG.debug("order response for verified request: {}", (Object)this.jwtUtil.getOrderResponseAsJSON(orderResp));
        }
        if (valid) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)orderResp);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)orderResp);
    }

    private Certificate startCertificateCreationProcess(AcmeOrder orderDao, Pipeline pipeline, String requestorName, String csrAsPem) {
        NamedValues[] nvArr = new NamedValues[0];
        ArrayList messageList = new ArrayList();
        CSR csr = this.cpUtil.buildCSR(csrAsPem, requestorName, "ACME_CERTIFICATE_REQUESTED", "", pipeline, nvArr, messageList);
        if (csr == null) {
            LOG.info("building CSR failed");
            String msg = "";
            if (!messageList.isEmpty()) {
                msg = (String)messageList.get(0);
            }
            ProblemDetail problem = new ProblemDetail(ACMEUtil.BAD_CSR, msg, HttpStatus.BAD_REQUEST, "", ACMEController.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
        orderDao.setCsr(csr);
        Certificate cert = this.cpUtil.processCertificateRequest(csr, requestorName, "ACME_CERTIFICATE_CREATED", pipeline);
        if (cert == null) {
            LOG.warn("creation of certificate by ACME order {} failed ", (Object)orderDao.getOrderId());
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceACMEOrderInvalid(orderDao.getAccount(), orderDao, "certificate creation failed"));
            orderDao.setStatus(AcmeOrderStatus.INVALID);
        } else {
            LOG.debug("updating order id {} with new certificate id {}", (Object)orderDao.getOrderId(), (Object)cert.getId());
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceACMEOrderSucceeded(orderDao.getAccount(), orderDao));
            orderDao.setCertificate(cert);
            orderDao.setStatus(AcmeOrderStatus.VALID);
            LOG.debug("adding certificate attribute 'ACME_ACCOUNT_ID' {} for certificate id {}", (Object)orderDao.getAccount().getAccountId(), (Object)cert.getId());
            this.certUtil.setCertAttribute(cert, "ACME:ACCOUNT_ID", orderDao.getAccount().getAccountId().longValue());
            this.certUtil.setCertAttribute(cert, "ACME:ORDER_ID", orderDao.getOrderId().longValue());
        }
        return cert;
    }

    private String getASN1ValueAsString(Attribute attr) {
        return this.getASN1ValueAsString(attr.getAttrValues().toArray());
    }

    private String getASN1ValueAsString(ASN1Encodable[] asn1EncArr) {
        String value = "";
        for (ASN1Encodable asn1Enc : asn1EncArr) {
            if (value.length() > 0) {
                value = value + ", ";
            }
            value = value + asn1Enc.toString();
        }
        return value;
    }

    private void retrieveSANFromCSRAttribute(Set<String> sanSet, Attribute attrExtension) {
        HashSet generalNameSet = new HashSet();
        CSRUtil.retrieveSANFromCSRAttribute(generalNameSet, (Attribute)attrExtension);
        for (GeneralName gn : generalNameSet) {
            sanSet.add(gn.getName().toString());
        }
    }
}

