/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.errors;

import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.service.UsernameAlreadyUsedException;
import de.trustable.ca3s.core.web.rest.errors.EmailAlreadyUsedException;
import de.trustable.ca3s.core.web.rest.errors.ErrorConstants;
import de.trustable.ca3s.core.web.rest.errors.FieldErrorVM;
import de.trustable.ca3s.core.web.rest.errors.InvalidPasswordException;
import de.trustable.ca3s.core.web.rest.errors.LoginAlreadyUsedException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.problem.DefaultProblem;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.spring.web.advice.ProblemHandling;
import org.zalando.problem.spring.web.advice.security.SecurityAdviceTrait;
import org.zalando.problem.violations.ConstraintViolationProblem;
import tech.jhipster.web.util.HeaderUtil;

@ControllerAdvice
public class ExceptionTranslator
implements ProblemHandling,
SecurityAdviceTrait {
    private static final String FIELD_ERRORS_KEY = "fieldErrors";
    private static final String MESSAGE_KEY = "message";
    private static final String PATH_KEY = "path";
    private static final String VIOLATIONS_KEY = "violations";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;

    public ResponseEntity<Problem> process(@Nullable ResponseEntity<Problem> entity, NativeWebRequest request) {
        if (entity == null) {
            return entity;
        }
        Problem problem = (Problem)entity.getBody();
        if (!(problem instanceof ConstraintViolationProblem) && !(problem instanceof DefaultProblem)) {
            return entity;
        }
        ProblemBuilder builder = Problem.builder().withType(Problem.DEFAULT_TYPE.equals(problem.getType()) ? ErrorConstants.DEFAULT_TYPE : problem.getType()).withStatus(problem.getStatus()).withTitle(problem.getTitle()).with(PATH_KEY, (Object)((HttpServletRequest)request.getNativeRequest(HttpServletRequest.class)).getRequestURI());
        if (problem instanceof ConstraintViolationProblem) {
            builder.with(VIOLATIONS_KEY, (Object)((ConstraintViolationProblem)problem).getViolations()).with(MESSAGE_KEY, (Object)"error.validation");
        } else {
            builder.withCause(((DefaultProblem)problem).getCause()).withDetail(problem.getDetail()).withInstance(problem.getInstance());
            problem.getParameters().forEach((arg_0, arg_1) -> ((ProblemBuilder)builder).with(arg_0, arg_1));
            if (!problem.getParameters().containsKey(MESSAGE_KEY) && problem.getStatus() != null) {
                builder.with(MESSAGE_KEY, (Object)("error.http." + problem.getStatus().getStatusCode()));
            }
        }
        return new ResponseEntity((Object)builder.build(), (MultiValueMap)entity.getHeaders(), entity.getStatusCode());
    }

    public ResponseEntity<Problem> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, @Nonnull NativeWebRequest request) {
        BindingResult result = ex.getBindingResult();
        List fieldErrors = result.getFieldErrors().stream().map(f -> new FieldErrorVM(f.getObjectName().replaceFirst("DTO$", ""), f.getField(), f.getCode())).collect(Collectors.toList());
        ThrowableProblem problem = Problem.builder().withType(ErrorConstants.CONSTRAINT_VIOLATION_TYPE).withTitle("Method argument not valid").withStatus(this.defaultConstraintViolationStatus()).with(MESSAGE_KEY, (Object)"error.validation").with(FIELD_ERRORS_KEY, fieldErrors).build();
        return this.create((Throwable)ex, (Problem)problem, request);
    }

    @ExceptionHandler
    public ResponseEntity<Problem> handleEmailAlreadyUsedException(de.trustable.ca3s.core.service.EmailAlreadyUsedException ex, NativeWebRequest request) {
        EmailAlreadyUsedException problem = new EmailAlreadyUsedException();
        return this.create((ThrowableProblem)problem, request, HeaderUtil.createFailureAlert((String)this.applicationName, (boolean)true, (String)problem.getEntityName(), (String)problem.getErrorKey(), (String)problem.getMessage()));
    }

    @ExceptionHandler
    public ResponseEntity<Problem> handleUsernameAlreadyUsedException(UsernameAlreadyUsedException ex, NativeWebRequest request) {
        LoginAlreadyUsedException problem = new LoginAlreadyUsedException();
        return this.create((ThrowableProblem)problem, request, HeaderUtil.createFailureAlert((String)this.applicationName, (boolean)true, (String)problem.getEntityName(), (String)problem.getErrorKey(), (String)problem.getMessage()));
    }

    @ExceptionHandler
    public ResponseEntity<Problem> handleInvalidPasswordException(de.trustable.ca3s.core.service.InvalidPasswordException ex, NativeWebRequest request) {
        return this.create((ThrowableProblem)new InvalidPasswordException(), request);
    }

    @ExceptionHandler
    public ResponseEntity<Problem> handleBadRequestAlertException(BadRequestAlertException ex, NativeWebRequest request) {
        return this.create((ThrowableProblem)ex, request, HeaderUtil.createFailureAlert((String)this.applicationName, (boolean)true, (String)ex.getEntityName(), (String)ex.getErrorKey(), (String)ex.getMessage()));
    }

    @ExceptionHandler
    public ResponseEntity<Problem> handleConcurrencyFailure(ConcurrencyFailureException ex, NativeWebRequest request) {
        ThrowableProblem problem = Problem.builder().withStatus((StatusType)Status.CONFLICT).with(MESSAGE_KEY, (Object)"error.concurrencyFailure").build();
        return this.create((Throwable)ex, (Problem)problem, request);
    }
}

