/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.repository;

import de.trustable.ca3s.core.domain.ACMEAccount_;
import de.trustable.ca3s.core.domain.AcmeAuthorization;
import de.trustable.ca3s.core.domain.AcmeAuthorization_;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.AcmeOrder_;
import de.trustable.ca3s.core.domain.enumeration.AcmeOrderStatus;
import de.trustable.ca3s.core.repository.AcmeOrderRepository;
import de.trustable.ca3s.core.repository.SelectionData;
import de.trustable.ca3s.core.repository.SpecificationsHelper;
import de.trustable.ca3s.core.service.dto.ACMEOrderView;
import de.trustable.ca3s.core.service.dto.Selector;
import de.trustable.ca3s.core.service.util.ACMEOrderUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ACMEOrderSpecifications {
    static Logger logger = LoggerFactory.getLogger(ACMEOrderSpecifications.class);
    static final String SORT = "sort";
    static final String ORDER = "order";

    private ACMEOrderSpecifications() {
    }

    public static Page<ACMEOrderView> handleQueryParamsACMEOrderView(EntityManager entityManager, AcmeOrderRepository acmeOrderRepository, ACMEOrderUtil acmeOrderUtil, CriteriaBuilder cb, Map<String, String[]> parameterMap, List<String> additionalSelectionAttributes) {
        String[] paramArr;
        CriteriaQuery query = cb.createQuery(Object[].class);
        Root root = query.from(AcmeOrder.class);
        String sortCol = SpecificationsHelper.getStringValue((String[])parameterMap.get("sort"), (String)"id").trim();
        Selection orderSelection = null;
        String orderDirection = SpecificationsHelper.getStringValue((String[])parameterMap.get("order"), (String)"asc");
        int pageOffset = SpecificationsHelper.getIntValue((String[])parameterMap.get("offset"), (int)0);
        int pagesize = SpecificationsHelper.getIntValue((String[])parameterMap.get("limit"), (int)20);
        ArrayList selectionList = new ArrayList();
        ArrayList<String> colList = new ArrayList<String>();
        Map selectionMap = ACMEOrderSpecifications.getSelectionMap(parameterMap);
        String[] columnArr = new String[]{};
        if (parameterMap.containsKey("filter") && (paramArr = parameterMap.get("filter")).length > 0) {
            columnArr = paramArr[0].split(",");
        }
        ArrayList<Predicate> predList = new ArrayList<Predicate>();
        for (String col : columnArr) {
            colList.add(col);
            if (selectionMap.containsKey(col)) {
                List selDataList = (List)selectionMap.get(col);
                for (SelectionData selDataItem : selDataList) {
                    logger.debug("buildPredicate for '{}', selector '{}', value '{}' ", new Object[]{col, selDataItem.selector, selDataItem.value});
                    predList.add(ACMEOrderSpecifications.buildPredicate((Root)root, (CriteriaBuilder)cb, (CriteriaQuery)query, (String)col, (String)selDataItem.selector, (String)selDataItem.value, selectionList, additionalSelectionAttributes));
                }
            } else {
                logger.debug("buildPredicate for '{}' without selector ", (Object)col);
                predList.add(ACMEOrderSpecifications.buildPredicate((Root)root, (CriteriaBuilder)cb, (CriteriaQuery)query, (String)col, null, (String)"", selectionList, additionalSelectionAttributes));
            }
            if (!col.equals(sortCol)) continue;
            orderSelection = (Selection)selectionList.get(selectionList.size() - 1);
        }
        Predicate pred = null;
        for (Predicate predPart : predList) {
            if (pred == null) {
                pred = predPart;
                continue;
            }
            pred = cb.and((Expression)pred, (Expression)predPart);
        }
        query.where(pred);
        Sort.Direction sortDir = Sort.Direction.ASC;
        if ("asc".equalsIgnoreCase(orderDirection)) {
            query.orderBy(new Order[]{cb.asc((Expression)orderSelection)});
        } else {
            query.orderBy(new Order[]{cb.desc((Expression)orderSelection)});
            sortDir = Sort.Direction.DESC;
        }
        query.multiselect(selectionList);
        TypedQuery typedQuery = entityManager.createQuery(query);
        typedQuery.setMaxResults(pagesize);
        typedQuery.setFirstResult(pageOffset);
        try {
            logger.debug("assembled query: " + ((Query)typedQuery.unwrap(Query.class)).getQueryString());
        }
        catch (Exception e) {
            logger.debug("failed in retrieve sql query", (Throwable)e);
        }
        List listResponse = typedQuery.getResultList();
        ArrayList<ACMEOrderView> acmeOrderViewList = new ArrayList<ACMEOrderView>();
        for (Object[] objArr : listResponse) {
            if (logger.isDebugEnabled() && objArr.length != colList.size()) {
                logger.debug("objArr len {}, colList len {}", (Object)objArr.length, (Object)colList.size());
            }
            ACMEOrderView acmeOrderView = ACMEOrderSpecifications.buildACMEOrderViewFromObjArr(colList, (Object[])objArr, (AcmeOrderRepository)acmeOrderRepository, (ACMEOrderUtil)acmeOrderUtil);
            acmeOrderViewList.add(acmeOrderView);
        }
        PageRequest pageable = PageRequest.of((int)(pageOffset / pagesize), (int)pagesize, (Sort.Direction)sortDir, (String[])new String[]{sortCol});
        CriteriaQuery queryCount = cb.createQuery(Long.class);
        Root iRoot = queryCount.from(AcmeOrder.class);
        ArrayList<Predicate> predCountList = new ArrayList<Predicate>();
        ArrayList selectionListCount = new ArrayList();
        for (String col : columnArr) {
            colList.add(col);
            if (selectionMap.containsKey(col)) {
                List selDataList = (List)selectionMap.get(col);
                for (SelectionData selDataItem : selDataList) {
                    logger.debug("buildPredicate for '{}', selector '{}', value '{}' ", new Object[]{col, selDataItem.selector, selDataItem.value});
                    predCountList.add(ACMEOrderSpecifications.buildPredicate((Root)iRoot, (CriteriaBuilder)cb, (CriteriaQuery)queryCount, (String)col, (String)selDataItem.selector, (String)selDataItem.value, selectionListCount, additionalSelectionAttributes));
                }
                continue;
            }
            logger.debug("buildPredicate for '{}' without selector ", (Object)col);
            predCountList.add(ACMEOrderSpecifications.buildPredicate((Root)iRoot, (CriteriaBuilder)cb, (CriteriaQuery)queryCount, (String)col, null, (String)"", selectionListCount, additionalSelectionAttributes));
        }
        Predicate predCount = null;
        for (Predicate predPart : predCountList) {
            if (predCount == null) {
                predCount = predPart;
                continue;
            }
            predCount = cb.and((Expression)predCount, (Expression)predPart);
        }
        queryCount.select((Selection)cb.count((Expression)iRoot));
        queryCount.where((Expression)predCount);
        Long nTotalElements = (Long)entityManager.createQuery(queryCount).getSingleResult();
        logger.debug("buildPredicate selects {} elements ", (Object)nTotalElements);
        return new PageImpl(acmeOrderViewList, (Pageable)pageable, nTotalElements.longValue());
    }

    private static ACMEOrderView buildACMEOrderViewFromObjArr(ArrayList<String> colList, Object[] objArr, AcmeOrderRepository acmeOrderRepository, ACMEOrderUtil acmeOrderUtil) {
        ACMEOrderView acmeOrderView = new ACMEOrderView();
        int i = 0;
        for (int n = 0; n < colList.size(); ++n) {
            Optional optionalAcmeOrder;
            if (!"id".equalsIgnoreCase(colList.get(n)) || !(optionalAcmeOrder = acmeOrderRepository.findById((Object)((Long)objArr[i]))).isPresent()) continue;
            acmeOrderView = acmeOrderUtil.from((AcmeOrder)optionalAcmeOrder.get());
        }
        for (String attribute : colList) {
            if (i >= objArr.length) {
                logger.debug("attribute '{}' exceeds objArr with #{} elements ", (Object)attribute, (Object)objArr.length);
                continue;
            }
            logger.debug("attribute '{}' has value '{}'", (Object)attribute, objArr[i]);
            if ("id".equalsIgnoreCase(attribute)) {
                acmeOrderView.setId((Long)objArr[i]);
            } else if ("orderId".equalsIgnoreCase(attribute)) {
                acmeOrderView.setAccountId((Long)objArr[i]);
            } else if ("status".equalsIgnoreCase(attribute)) {
                acmeOrderView.setStatus((AcmeOrderStatus)objArr[i]);
            } else if ("realm".equalsIgnoreCase(attribute)) {
                acmeOrderView.setRealm((String)objArr[i]);
            } else if ("expires".equalsIgnoreCase(attribute)) {
                acmeOrderView.setExpires((Instant)objArr[i]);
            } else if ("notBefore".equalsIgnoreCase(attribute)) {
                acmeOrderView.setNotBefore((Instant)objArr[i]);
            } else if ("notAfter".equalsIgnoreCase(attribute)) {
                acmeOrderView.setNotAfter((Instant)objArr[i]);
            } else if ("error".equalsIgnoreCase(attribute)) {
                acmeOrderView.setError((String)objArr[i]);
            } else if ("finalizeUrl".equalsIgnoreCase(attribute)) {
                acmeOrderView.setFinalizeUrl((String)objArr[i]);
            } else if ("certificateUrl".equalsIgnoreCase(attribute)) {
                acmeOrderView.setCertificateUrl((String)objArr[i]);
            } else if ("challengeTypes".equalsIgnoreCase(attribute)) {
                acmeOrderView.setChallengeTypes((String)objArr[i]);
            } else if (!"challengeUrls".equalsIgnoreCase(attribute)) {
                logger.warn("unexpected attribute '{}' from query", (Object)attribute);
            }
            ++i;
        }
        return acmeOrderView;
    }

    static Map<String, List<SelectionData>> getSelectionMap(Map<String, String[]> parameterMap) {
        HashMap<String, List<SelectionData>> selectorMap = new HashMap<String, List<SelectionData>>();
        for (int n = 1; n < 20; ++n) {
            String paramNameAttribute = "attributeName_" + n;
            logger.debug("paramNameAttribute {} ", (Object)paramNameAttribute);
            if (!parameterMap.containsKey(paramNameAttribute)) break;
            String attribute = SpecificationsHelper.getStringValue((String[])parameterMap.get(paramNameAttribute));
            if (attribute.length() == 0) {
                logger.debug("paramNameAttribute {} has no value", (Object)paramNameAttribute);
                continue;
            }
            String paramNameAttributeSelector = "attributeSelector_" + n;
            String attributeSelector = SpecificationsHelper.getStringValue((String[])parameterMap.get(paramNameAttributeSelector));
            if (attributeSelector.length() == 0) {
                logger.debug("paramNameAttributeSelector {} has no value", (Object)paramNameAttributeSelector);
                continue;
            }
            String paramNameAttributeValue = "attributeValue_" + n;
            String attributeValue = SpecificationsHelper.getStringValue((String[])parameterMap.get(paramNameAttributeValue));
            if (attributeValue.length() == 0 && Selector.requiresValue((String)attributeSelector)) {
                logger.debug("paramNameAttributeValue {} has no value", (Object)paramNameAttributeValue);
                continue;
            }
            logger.debug("Attribute {} selecting by {} for value {}", new Object[]{attribute, attributeSelector, attributeValue});
            SelectionData selData = new SelectionData(attributeSelector, attributeValue);
            if (selectorMap.containsKey(attribute)) {
                logger.debug("adding selector to exiting list for '{}'", (Object)attribute);
                ((List)selectorMap.get(attribute)).add(selData);
                continue;
            }
            logger.debug("creating new selector list for '{}'", (Object)attribute);
            ArrayList<SelectionData> selectorList = new ArrayList<SelectionData>();
            selectorList.add(selData);
            selectorMap.put(attribute, selectorList);
        }
        return selectorMap;
    }

    private static Predicate buildPredicate(Root<AcmeOrder> root, CriteriaBuilder cb, CriteriaQuery<?> query, String attribute, String attributeSelector, String attributeValue, List<Selection<?>> selectionList, List<String> selectionAttributes) {
        Predicate pred = cb.conjunction();
        if ("id".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AcmeOrder_.id));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateLong((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(AcmeOrder_.id), (String)attributeValue);
            }
        } else if ("orderId".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AcmeOrder_.orderId));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateLong((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(AcmeOrder_.orderId), (String)attributeValue);
            }
        } else if ("status".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AcmeOrder_.status));
            if (attributeValue.trim().length() > 0) {
                pred = ACMEOrderSpecifications.buildPredicateOrderStatus((String)attributeSelector, (CriteriaBuilder)cb, (Path)root.get(AcmeOrder_.status), (String)attributeValue);
            }
        } else if ("realm".equals(attribute)) {
            Join accJoin = root.join(AcmeOrder_.account, JoinType.LEFT);
            SpecificationsHelper.addNewColumn(selectionList, (Selection)accJoin.get(ACMEAccount_.realm));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)accJoin.get(ACMEAccount_.realm), (String)attributeValue.toLowerCase());
            }
        } else if ("expires".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AcmeOrder_.expires));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildDatePredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(AcmeOrder_.expires), (String)attributeValue);
            }
        } else if ("notBefore".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AcmeOrder_.notBefore));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildDatePredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(AcmeOrder_.notBefore), (String)attributeValue);
            }
        } else if ("notAfter".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AcmeOrder_.notAfter));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildDatePredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(AcmeOrder_.notAfter), (String)attributeValue);
            }
        } else if ("error".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AcmeOrder_.error));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(AcmeOrder_.error), (String)attributeValue);
            }
        } else if ("finalizeUrl".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AcmeOrder_.finalizeUrl));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(AcmeOrder_.finalizeUrl), (String)attributeValue);
            }
        } else if ("certificateUrl".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AcmeOrder_.certificateUrl));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(AcmeOrder_.certificateUrl), (String)attributeValue);
            }
        } else if ("challengeTypes".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AcmeOrder_.certificateUrl));
            if (attributeValue.trim().length() > 0) {
                Subquery certAuthSubquery = query.subquery(AcmeAuthorization.class);
                Root certAuthRoot = certAuthSubquery.from(AcmeAuthorization.class);
                pred = cb.exists(certAuthSubquery.select((Expression)certAuthRoot).where((Expression)cb.and((Expression)cb.equal((Expression)certAuthRoot.get("order"), (Expression)root.get("id")), (Expression)SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)certAuthRoot.get(AcmeAuthorization_.value), (String)attributeValue.toLowerCase()))));
            }
        } else if ("challengeUrls".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(AcmeOrder_.certificateUrl));
            if (attributeValue.trim().length() > 0) {
                Subquery certAuthSubquery = query.subquery(AcmeAuthorization.class);
                Root certAuthRoot = certAuthSubquery.from(AcmeAuthorization.class);
                pred = cb.exists(certAuthSubquery.select((Expression)certAuthRoot).where((Expression)cb.and((Expression)cb.equal((Expression)certAuthRoot.get("order"), (Expression)root.get("id")), (Expression)SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)certAuthRoot.get(AcmeAuthorization_.value), (String)attributeValue.toLowerCase()))));
            }
        } else {
            logger.warn("fall-thru clause adding 'true' condition for {} ", (Object)attribute);
        }
        return pred;
    }

    private static Predicate buildPredicateOrderStatus(String attributeSelector, CriteriaBuilder cb, Path<AcmeOrderStatus> path, String attributeValue) {
        AcmeOrderStatus orderStatus;
        if (attributeSelector == null) {
            return cb.conjunction();
        }
        try {
            orderStatus = AcmeOrderStatus.valueOf((String)attributeValue);
        }
        catch (IllegalArgumentException iae) {
            logger.debug("buildPredicateAccountStatus not an ACMEStatus ", (Throwable)iae);
            return cb.disjunction();
        }
        if (Selector.EQUAL.toString().equals(attributeSelector)) {
            logger.debug("buildPredicateAccountStatus equal ('{}') for value '{}'", (Object)attributeSelector, (Object)orderStatus);
            return cb.equal(path, (Object)orderStatus);
        }
        if (Selector.NOT_EQUAL.toString().equals(attributeSelector)) {
            logger.debug("buildPredicateAccountStatus notEqual ('{}') for value '{}'", (Object)attributeSelector, (Object)orderStatus);
            return cb.notEqual(path, (Object)orderStatus);
        }
        logger.debug("buildPredicateAccountStatus defaults to equals ('{}') for value '{}'", (Object)attributeSelector, (Object)orderStatus);
        return cb.equal(path, (Object)orderStatus);
    }
}

