/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.ACMEAccount;
import de.trustable.ca3s.core.service.ACMEAccountService;
import de.trustable.ca3s.core.service.dto.ACMEAccountView;
import de.trustable.ca3s.core.service.util.ACMEAccountUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.ResponseUtil;

@Transactional
@RestController
@RequestMapping(value={"/api"})
public class ACMEAccountViewResource {
    private final Logger log = LoggerFactory.getLogger(ACMEAccountViewResource.class);
    private final ACMEAccountService acmeAccountService;
    private final ACMEAccountUtil acmeAccountUtil;

    public ACMEAccountViewResource(ACMEAccountService acmeAccountService, ACMEAccountUtil acmeAccountUtil) {
        this.acmeAccountService = acmeAccountService;
        this.acmeAccountUtil = acmeAccountUtil;
    }

    @GetMapping(value={"/acmeAccountViews"})
    public List<ACMEAccountView> getAllACMEAccountViews() {
        this.log.debug("REST request to get all ACMEAccountViews");
        ArrayList<ACMEAccountView> avList = new ArrayList<ACMEAccountView>();
        for (ACMEAccount acmeAccount : this.acmeAccountService.findAll()) {
            avList.add(this.acmeAccountUtil.from(acmeAccount));
        }
        return avList;
    }

    @GetMapping(value={"/acmeAccountViews/{id}"})
    public ResponseEntity<ACMEAccountView> getACMEAccount(@PathVariable Long id) {
        this.log.debug("REST request to get ACMEAccountView : {}", (Object)id);
        Optional acmeAccountOptional = this.acmeAccountService.findOne(id);
        Optional<Object> avOpt = Optional.empty();
        if (acmeAccountOptional.isPresent()) {
            ACMEAccount acmeAccount = (ACMEAccount)acmeAccountOptional.get();
            ACMEAccountView acmeAccountView = this.acmeAccountUtil.from(acmeAccount);
            avOpt = Optional.of(acmeAccountView);
        }
        return ResponseUtil.wrapOrNotFound(avOpt);
    }
}

