/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.service.ProtectedContentService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class ProtectedContentResource {
    private final Logger log = LoggerFactory.getLogger(ProtectedContentResource.class);
    private static final String ENTITY_NAME = "protectedContent";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final ProtectedContentService protectedContentService;

    public ProtectedContentResource(ProtectedContentService protectedContentService) {
        this.protectedContentService = protectedContentService;
    }

    @PostMapping(value={"/protected-contents"})
    public ResponseEntity<ProtectedContent> createProtectedContent(@Valid @RequestBody ProtectedContent protectedContent) throws URISyntaxException {
        this.log.debug("REST request to save ProtectedContent : {}", (Object)protectedContent);
        if (protectedContent.getId() != null) {
            throw new BadRequestAlertException("A new protectedContent cannot already have an ID", ENTITY_NAME, "idexists");
        }
        ProtectedContent result = this.protectedContentService.save(protectedContent);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/protected-contents/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/protected-contents"})
    public ResponseEntity<ProtectedContent> updateProtectedContent(@Valid @RequestBody ProtectedContent protectedContent) throws URISyntaxException {
        this.log.debug("REST request to update ProtectedContent : {}", (Object)protectedContent);
        if (protectedContent.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        ProtectedContent result = this.protectedContentService.save(protectedContent);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)protectedContent.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/protected-contents"})
    public List<ProtectedContent> getAllProtectedContents() {
        this.log.debug("REST request to get all ProtectedContents");
        return this.protectedContentService.findAll();
    }

    @GetMapping(value={"/protected-contents/{id}"})
    public ResponseEntity<ProtectedContent> getProtectedContent(@PathVariable Long id) {
        this.log.debug("REST request to get ProtectedContent : {}", (Object)id);
        Optional protectedContent = this.protectedContentService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)protectedContent);
    }

    @DeleteMapping(value={"/protected-contents/{id}"})
    public ResponseEntity<Void> deleteProtectedContent(@PathVariable Long id) {
        this.log.debug("REST request to delete ProtectedContent : {}", (Object)id);
        this.protectedContentService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

