/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.repository;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.CertificateSpecifications;
import de.trustable.ca3s.core.service.dto.CertificateView;
import de.trustable.ca3s.core.service.util.CertificateSelectionUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class CertificateViewRepository {
    private final EntityManager entityManager;
    private final CertificateSelectionUtil certificateSelectionAttributeList;
    private final CertificateRepository certificateRepository;

    public CertificateViewRepository(EntityManager entityManager, CertificateSelectionUtil certificateSelectionAttributeList, CertificateRepository certificateRepository) {
        this.entityManager = entityManager;
        this.certificateSelectionAttributeList = certificateSelectionAttributeList;
        this.certificateRepository = certificateRepository;
    }

    public Page<CertificateView> findSelection(Map<String, String[]> parameterMap) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        return CertificateSpecifications.handleQueryParamsCertificateView((EntityManager)this.entityManager, (CriteriaBuilder)cb, parameterMap, (List)this.certificateSelectionAttributeList.getCertificateSelectionAttributes());
    }

    public Optional<CertificateView> findbyCertificateId(Long certificateId) {
        Optional optCert = this.certificateRepository.findById((Object)certificateId);
        if (optCert.isPresent()) {
            return Optional.of(new CertificateView((Certificate)optCert.get()));
        }
        return Optional.empty();
    }
}

