/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.domain.BPMNProcessInfo;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.CsrAttribute;
import de.trustable.ca3s.core.repository.CAConnectorConfigRepository;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.dto.BPMNUpload;
import de.trustable.ca3s.core.service.util.BPMNUtil;
import de.trustable.ca3s.core.web.rest.data.BpmnCheckResult;
import de.trustable.ca3s.core.web.rest.support.NotFoundException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.validation.Valid;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.camunda.bpm.engine.variable.VariableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/api"})
public class BPMNUpDownloadController {
    private static final Logger LOG = LoggerFactory.getLogger(BPMNUpDownloadController.class);
    final BPMNUtil bpmnUtil;
    final CSRRepository csrRepository;
    final CAConnectorConfigRepository caConnectorConfigRepository;
    final AuditService auditService;

    public BPMNUpDownloadController(BPMNUtil bpmnUtil, CSRRepository csrRepository, CAConnectorConfigRepository caConnectorConfigRepository, AuditService auditService) {
        this.bpmnUtil = bpmnUtil;
        this.csrRepository = csrRepository;
        this.caConnectorConfigRepository = caConnectorConfigRepository;
        this.auditService = auditService;
    }

    @RequestMapping(value={"/bpmn/{processId}"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ResponseEntity<InputStreamResource> getBPMN(@PathVariable String processId) throws NotFoundException {
        LOG.info("Received bpmn download request for id {} ", (Object)processId);
        for (ProcessDefinition pd : this.bpmnUtil.getProcessDefinitions()) {
            LOG.info("process definition present : id {}, name {} ", (Object)pd.getId(), (Object)pd.getName());
        }
        InputStreamResource inputStreamResource = new InputStreamResource(this.bpmnUtil.getProcessContent(processId));
        return new ResponseEntity((Object)inputStreamResource, HttpStatus.OK);
    }

    @PostMapping(value={"/bpmn"})
    @Transactional
    public ResponseEntity<BPMNProcessInfo> postBPMN(@Valid @RequestBody BPMNUpload bpmnUpload) {
        LOG.info("Received bpmn upload request with name {} ", (Object)bpmnUpload.getName());
        if (bpmnUpload.getContentXML().trim().isEmpty()) {
            LOG.warn("Received bpmn upload request with name {} has no XML content!", (Object)bpmnUpload.getName());
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        String processDefinitionId = this.bpmnUtil.addModel(bpmnUpload.getContentXML(), bpmnUpload.getName());
        LOG.debug("Deployed bpmn document with processDefinitionId {} successfully", (Object)processDefinitionId);
        BPMNProcessInfo bpmnProcessInfo = this.bpmnUtil.buildBPMNProcessInfoByProcessId(processDefinitionId, bpmnUpload.getName(), bpmnUpload.getType());
        return new ResponseEntity((Object)bpmnProcessInfo, HttpStatus.OK);
    }

    @RequestMapping(value={"/bpmn/check/csr/{processId}/{csrId}"}, method={RequestMethod.POST})
    public ResponseEntity<Map<String, String>> postBPMNForCSR(@PathVariable String processId, @PathVariable String csrId) {
        LOG.info("Received bpmn check request for process id {} and csr id {}", (Object)processId, (Object)csrId);
        Optional csrOpt = this.csrRepository.findById((Object)Long.parseLong(csrId));
        CAConnectorConfig caConfig = (CAConnectorConfig)this.caConnectorConfigRepository.getOne((Object)1L);
        ProcessInstanceWithVariables processInstanceWithVariables = this.bpmnUtil.checkCertificateCreationProcess((CSR)csrOpt.get(), caConfig, processId);
        if (processInstanceWithVariables != null) {
            BpmnCheckResult result = new BpmnCheckResult();
            VariableMap variables = processInstanceWithVariables.getVariables();
            for (String key : variables.keySet()) {
                if ("csrAttributes".equals(key)) {
                    for (CsrAttribute csrAtt : (Set)variables.get(key)) {
                        LOG.info("bpmn process returns CsrAttribute {} with value {}", (Object)csrAtt.getName(), (Object)csrAtt.getValue());
                        result.getCsrAttributes().add(new ImmutablePair((Object)csrAtt.getName(), (Object)csrAtt.getValue()));
                    }
                    continue;
                }
                if ("failureReason".equals(key)) {
                    result.setFailureReason(variables.get(key).toString());
                    continue;
                }
                if ("status".equals(key)) {
                    result.setStatus(variables.get(key).toString());
                    continue;
                }
                if ("isActive".equals(key)) {
                    result.setActive(Boolean.valueOf(Boolean.parseBoolean(variables.get(key).toString())));
                    continue;
                }
                String value = variables.get(key).toString();
                LOG.info("bpmn process returns variable {} with value {}", (Object)key, (Object)value);
                result.getCsrAttributes().add(new ImmutablePair((Object)key, (Object)value));
            }
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }
}

