/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.cmp;

import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.cmp.RemoteConnector;
import de.trustable.ca3s.core.service.cmp.VerifyingKeystoreSigner;
import de.trustable.ca3s.core.service.dto.CAStatus;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CaConnectorConfigUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import de.trustable.cmp.client.ProtectedMessageHandler;
import de.trustable.cmp.client.RemoteTargetHandler;
import de.trustable.cmp.client.cmpClient.CMPClientConfig;
import de.trustable.cmp.client.cmpClient.CMPClientImpl;
import de.trustable.cmp.client.cmpClient.DigestSigner;
import de.trustable.util.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Set;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.CRLReason;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CaCmpConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaCmpConnector.class);
    private final RemoteConnector remoteConnector;
    private final CryptoUtil cryptoUtil;
    private final CertificateUtil certUtil;
    private final CSRUtil csrUtil;
    private final ProtectedContentUtil protUtil;
    private final CaConnectorConfigUtil caConnectorConfigUtil;
    private final CertificateRepository certificateRepository;
    private final CertificateUtil certificateUtil;

    public CaCmpConnector(RemoteConnector remoteConnector, CryptoUtil cryptoUtil, CertificateUtil certUtil, CSRUtil csrUtil, ProtectedContentUtil protUtil, CertificateRepository certificateRepository, CaConnectorConfigUtil caConnectorConfigUtil, CertificateUtil certificateUtil) {
        this.remoteConnector = remoteConnector;
        this.cryptoUtil = cryptoUtil;
        this.certUtil = certUtil;
        this.csrUtil = csrUtil;
        this.protUtil = protUtil;
        this.certificateRepository = certificateRepository;
        this.caConnectorConfigUtil = caConnectorConfigUtil;
        this.certificateUtil = certificateUtil;
    }

    private CMPClientImpl getCMPClient(CAConnectorConfig caConnConfig) throws GeneralSecurityException {
        DigestSigner signer;
        CMPClientConfig cmpClientConfig = new CMPClientConfig();
        Certificate certificateMessageProtection = caConnConfig.getMessageProtection();
        boolean ignoreFailedVerification = this.caConnectorConfigUtil.getCAConnectorConfigAttribute(caConnConfig, "IGNORE_RESPONSE_MESSAGE_VERIFICATION", false);
        if (certificateMessageProtection == null) {
            LOGGER.debug("CMPClientConfig: instantiating DigestSigner");
            signer = new DigestSigner(this.protUtil.unprotectString(caConnConfig.getSecret().getContentBase64()), ignoreFailedVerification);
        } else {
            LOGGER.debug("CMPClientConfig: instantiating KeystoreSigner");
            try {
                CertificateUtil.KeyStoreAndPassphrase keyStoreAndPassphrase = this.certUtil.getContainer(certificateMessageProtection, "entryAlias", "passphraseChars".toCharArray(), "PBEWithHmacSHA256AndAES_256");
                signer = new VerifyingKeystoreSigner(keyStoreAndPassphrase.getKeyStore(), "entryAlias", new String(keyStoreAndPassphrase.getPassphraseChars()), ignoreFailedVerification, this.certificateUtil);
            }
            catch (IOException e) {
                throw new GeneralSecurityException("Problem building P12 container", e);
            }
        }
        cmpClientConfig.setMessageHandler((ProtectedMessageHandler)signer);
        Certificate certificateTlsAuthentication = caConnConfig.getTlsAuthentication();
        if (certificateTlsAuthentication != null) {
            LOGGER.debug("CMPClientConfig: using CertificateTlsAuthentication");
            try {
                CertificateUtil.KeyStoreAndPassphrase keyStoreAndPassphrase = this.certUtil.getContainer(certificateTlsAuthentication, "entryAlias", "passphraseChars".toCharArray(), "PBEWithHmacSHA256AndAES_256");
                cmpClientConfig.setP12ClientStore(keyStoreAndPassphrase.getKeyStore());
                cmpClientConfig.setP12ClientSecret(new String(keyStoreAndPassphrase.getPassphraseChars()));
            }
            catch (IOException e) {
                throw new GeneralSecurityException("Problem build P12 container", e);
            }
        }
        cmpClientConfig.setRemoteTargetHandler((RemoteTargetHandler)this.remoteConnector);
        cmpClientConfig.setCaUrl(caConnConfig.getCaUrl());
        LOGGER.debug("CMPClientConfig: CaUrl '{}'", (Object)cmpClientConfig.getCaUrl());
        String contenType = this.caConnectorConfigUtil.getCAConnectorConfigAttribute(caConnConfig, "CMP_MESSAGE_CONTENT_TYPE", "application/pkixcmp");
        cmpClientConfig.setMsgContentType(contenType);
        LOGGER.debug("CMPClientConfig: MsgContentType '{}'", (Object)cmpClientConfig.getMsgContentType());
        cmpClientConfig.setCmpAlias(URLEncoder.encode(caConnConfig.getSelector(), StandardCharsets.UTF_8).replaceAll("\\+", "%20"));
        LOGGER.debug("CMPClientConfig: CmpAlias '{}'", (Object)cmpClientConfig.getCmpAlias());
        String certIssuer = this.caConnectorConfigUtil.getCAConnectorConfigAttribute(caConnConfig, "X500_NAME", null);
        if (certIssuer != null && !certIssuer.trim().isEmpty()) {
            cmpClientConfig.setIssuerName(new X500Name(certIssuer));
            LOGGER.debug("CMPClientConfig: IssuerName '{}'", (Object)cmpClientConfig.getIssuerName());
        }
        String sni = this.caConnectorConfigUtil.getCAConnectorConfigAttribute(caConnConfig, "SNI", null);
        cmpClientConfig.setSni(sni);
        LOGGER.debug("CMPClientConfig: SNI '{}'", (Object)cmpClientConfig.getSni());
        boolean disableHostNameVerifier = this.caConnectorConfigUtil.getCAConnectorConfigAttribute(caConnConfig, "DISABLE_HOST_NAME_VERIFIER", true);
        cmpClientConfig.setDisableHostNameVerifier(disableHostNameVerifier);
        LOGGER.debug("CMPClientConfig: DisableHostNameVerifier '{}'", (Object)cmpClientConfig.isDisableHostNameVerifier());
        boolean multipleMessages = this.caConnectorConfigUtil.getCAConnectorConfigAttribute(caConnConfig, "MULTIPLE_MESSAGES", true);
        cmpClientConfig.setMultipleMessages(multipleMessages);
        LOGGER.debug("CMPClientConfig: MultipleMessages '{}'", (Object)cmpClientConfig.isMultipleMessages());
        boolean implicitConfirm = this.caConnectorConfigUtil.getCAConnectorConfigAttribute(caConnConfig, "IMPLICIT_CONFIRM", true);
        cmpClientConfig.setImplicitConfirm(implicitConfirm);
        LOGGER.debug("CMPClientConfig: ImplicitConfirm '{}'", (Object)cmpClientConfig.isImplicitConfirm());
        boolean fillEmptySubjectWithSAN = this.caConnectorConfigUtil.getCAConnectorConfigAttribute(caConnConfig, "FILL_EMPTY_SUBJECT_WITH_SAN", true);
        cmpClientConfig.setFillEmptySubjectWithSAN(fillEmptySubjectWithSAN);
        LOGGER.debug("CMPClientConfig: ImplicitConfirm '{}'", (Object)cmpClientConfig.isImplicitConfirm());
        cmpClientConfig.setVerbose(LOGGER.isDebugEnabled());
        return new CMPClientImpl(cmpClientConfig);
    }

    public Certificate signCertificateRequest(CSR csr, CAConnectorConfig caConnConfig) throws GeneralSecurityException {
        LOGGER.debug("csr contains #{} CsrAttributes, #{} RequestAttributes and #{} RDN", new Object[]{csr.getCsrAttributes().size(), csr.getRas().size(), csr.getRdns().size()});
        CMPClientImpl cmpClient = this.getCMPClient(caConnConfig);
        ByteArrayInputStream baisCsr = new ByteArrayInputStream(csr.getCsrBase64().getBytes());
        CMPClientImpl.CertificateResponseContent certificateResponseContent = cmpClient.signCertificateRequest((InputStream)baisCsr);
        Certificate cert = this.readCertResponse(certificateResponseContent, csr, caConnConfig);
        csr.setCertificate(cert);
        csr.setStatus(CsrStatus.ISSUED);
        return cert;
    }

    public void revokeCertificate(Certificate certDao, CRLReason crlReason, Date revocationDate, CAConnectorConfig caConnConfig) throws GeneralSecurityException {
        this.revokeCertificate(new X500Name(certDao.getIssuer()), new X500Name(certDao.getSubject()), new BigInteger(certDao.getSerial()), crlReason, caConnConfig);
    }

    public void revokeCertificate(X500Name issuerDN, X500Name subjectDN, BigInteger serial, CRLReason crlReason, CAConnectorConfig caConnConfig) throws GeneralSecurityException {
        CMPClientImpl cmpClient = this.getCMPClient(caConnConfig);
        cmpClient.revokeCertificate(issuerDN, subjectDN, serial, crlReason);
    }

    public CAStatus getStatus(CAConnectorConfig caConnConfig) {
        return CAStatus.Active;
    }

    public Certificate readCertResponse(CMPClientImpl.CertificateResponseContent certificateResponseContent, CSR csr, CAConnectorConfig config) throws GeneralSecurityException {
        this.handleExtraCerts(certificateResponseContent.getAdditionalCertificates());
        if (certificateResponseContent.getCreatedCertificate() == null) {
            this.csrUtil.setStatus(csr, CsrStatus.REJECTED);
            this.csrUtil.setCsrAttribute(csr, "REJECTION_INFO", certificateResponseContent.getMessage(), true);
            throw new GeneralSecurityException("CMP response contains no certificate, \n" + certificateResponseContent.getMessage());
        }
        Certificate certDao = this.certUtil.createCertificate(certificateResponseContent.getCreatedCertificate().getEncoded(), csr, null, false);
        certDao.setRevocationCA(config);
        this.certificateRepository.save((Object)certDao);
        return certDao;
    }

    private void handleExtraCerts(Set<X509Certificate> certSet) throws GeneralSecurityException {
        if (certSet == null) {
            return;
        }
        for (X509Certificate certificate : certSet) {
            Certificate certDao = this.certUtil.createCertificate(certificate.getEncoded(), null, null, true);
            this.certificateRepository.save((Object)certDao);
            LOGGER.debug("Additional cert '" + certDao.getSubject() + "' from CMP response");
        }
    }
}

