/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.cmp;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.CryptoService;
import de.trustable.cmp.client.cmpClient.KeystoreSigner;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.cmp.CMPException;
import org.bouncycastle.cert.cmp.ProtectedPKIMessage;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyingKeystoreSigner
extends KeystoreSigner {
    Logger LOGGER = LoggerFactory.getLogger(VerifyingKeystoreSigner.class);
    private final CertificateUtil certificateUtil;

    public VerifyingKeystoreSigner(KeyStore ks, String ksAlias, String ksSecret, boolean ignoreFailedVerification, CertificateUtil certificateUtil) throws KeyStoreException {
        super(ks, ksAlias, ksSecret, ignoreFailedVerification);
        this.certificateUtil = certificateUtil;
    }

    public boolean verifyMessage(ProtectedPKIMessage message) throws GeneralSecurityException {
        this.LOGGER.debug("in KeystoreSigner.verifyMessage ...");
        try {
            if (message.hasPasswordBasedMacProtection()) {
                throw new GeneralSecurityException("Server used MacProtection, but certificate & key present!");
            }
        }
        catch (Exception ex) {
            if (this.isIgnoreFailedVerification()) {
                this.LOGGER.info("hasPasswordBasedMacProtection causes exception", (Throwable)ex);
            }
            throw ex;
        }
        X509CertificateHolder[] x509CertificateHolderArray = message.getCertificates();
        int n = x509CertificateHolderArray.length;
        int n2 = 0;
        if (n2 < n) {
            X509CertificateHolder x509CertificateHolder = x509CertificateHolderArray[n2];
            try {
                Certificate certificate = this.certificateUtil.createCertificate(x509CertificateHolder.getEncoded(), null, null, false, "");
                if (certificate.isEndEntity()) {
                    try {
                        X509Certificate x509Cert = CryptoService.convertPemToCertificate((String)certificate.getContent());
                        ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(x509Cert);
                        if (message.verify(verifierProvider)) {
                            this.LOGGER.debug("verifyMessage succeeded for certificate #{} ", (Object)certificate.getId());
                            if (!certificate.isActive()) {
                                this.LOGGER.info("certificate #{} NOT active", (Object)certificate.getId());
                            }
                            return true;
                        }
                    }
                    catch (CMPException | OperatorCreationException e) {
                        if (this.isIgnoreFailedVerification()) {
                            this.LOGGER.info("verification of ProtectedPKIMessage failed", e);
                        }
                        throw new GeneralSecurityException(e);
                    }
                }
                if (this.isIgnoreFailedVerification()) {
                    this.LOGGER.info("no matching certificate found for ProtectedPKIMessage verification");
                    return true;
                }
                throw new GeneralSecurityException("no matching certificate found for ProtectedPKIMessage verification");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }
}

