/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto.ejbca;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.JsonObject;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class CertificateRestResponseV2 {
    public static final String SERIALIZED_NAME_FINGERPRINT = "fingerprint";
    @JsonProperty(value="fingerprint")
    private String fingerprint;
    public static final String SERIALIZED_NAME_C_A_FINGERPRINT = "cAFingerprint";
    @JsonProperty(value="cAFingerprint")
    private String cAFingerprint;
    public static final String SERIALIZED_NAME_CERTIFICATE_PROFILE_ID = "certificateProfileId";
    @JsonProperty(value="certificateProfileId")
    private Integer certificateProfileId;
    public static final String SERIALIZED_NAME_END_ENTITY_PROFILE_ID = "endEntityProfileId";
    @JsonProperty(value="endEntityProfileId")
    private Integer endEntityProfileId;
    public static final String SERIALIZED_NAME_CERTIFICATE_PROFILE = "certificateProfile";
    @JsonProperty(value="certificateProfile")
    private String certificateProfile;
    public static final String SERIALIZED_NAME_END_ENTITY_PROFILE = "endEntityProfile";
    @JsonProperty(value="endEntityProfile")
    private String endEntityProfile;
    public static final String SERIALIZED_NAME_EXPIRE_DATE = "expireDate";
    @JsonProperty(value="expireDate")
    private Long expireDate;
    public static final String SERIALIZED_NAME_INVALIDITY_DATE = "invalidity_date";
    @JsonProperty(value="invalidity_date")
    private Long invalidityDate;
    public static final String SERIALIZED_NAME_ISSUER_D_N = "issuerDN";
    @JsonProperty(value="issuerDN")
    private String issuerDN;
    public static final String SERIALIZED_NAME_NOT_BEFORE = "notBefore";
    @JsonProperty(value="notBefore")
    private Long notBefore;
    public static final String SERIALIZED_NAME_REVOCATION_DATE = "revocationDate";
    @JsonProperty(value="revocationDate")
    private Long revocationDate;
    public static final String SERIALIZED_NAME_REVOCATION_REASON = "revocationReason";
    @JsonProperty(value="revocationReason")
    private Integer revocationReason;
    public static final String SERIALIZED_NAME_SERIAL_NUMBER = "serialNumber";
    @JsonProperty(value="serialNumber")
    private String serialNumber;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @JsonProperty(value="status")
    private Integer status;
    public static final String SERIALIZED_NAME_SUBJECT_ALT_NAME = "subjectAltName";
    @JsonProperty(value="subjectAltName")
    private String subjectAltName;
    public static final String SERIALIZED_NAME_SUBJECT_D_N = "subjectDN";
    @JsonProperty(value="subjectDN")
    private String subjectDN;
    public static final String SERIALIZED_NAME_SUBJECT_KEY_ID = "subjectKeyId";
    @JsonProperty(value="subjectKeyId")
    private String subjectKeyId;
    public static final String SERIALIZED_NAME_TAG = "tag";
    @JsonProperty(value="tag")
    private String tag;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @JsonProperty(value="type")
    private Integer type;
    public static final String SERIALIZED_NAME_UDPATE_TIME = "udpateTime";
    @JsonProperty(value="udpateTime")
    private Long udpateTime;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @JsonProperty(value="username")
    private String username;
    public static final String SERIALIZED_NAME_BASE64_CERT = "base64Cert";
    @JsonProperty(value="base64Cert")
    private String base64Cert;
    public static final String SERIALIZED_NAME_CERTIFICATE_REQUEST = "certificateRequest";
    @JsonProperty(value="certificateRequest")
    private String certificateRequest;
    public static final String SERIALIZED_NAME_CRL_PARTITION_INDEX = "crlPartitionIndex";
    @JsonProperty(value="crlPartitionIndex")
    private Integer crlPartitionIndex;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CertificateRestResponseV2() {
    }

    public CertificateRestResponseV2(String fingerprint, String cAFingerprint, Integer certificateProfileId, Integer endEntityProfileId, String certificateProfile, String endEntityProfile, Long expireDate, Long invalidityDate, String issuerDN, Long notBefore, Long revocationDate, Integer revocationReason, String serialNumber, Integer status, String subjectAltName, String subjectDN, String subjectKeyId, String tag, Integer type, Long udpateTime, String username, String base64Cert, String certificateRequest, Integer crlPartitionIndex) {
        this();
        this.fingerprint = fingerprint;
        this.cAFingerprint = cAFingerprint;
        this.certificateProfileId = certificateProfileId;
        this.endEntityProfileId = endEntityProfileId;
        this.certificateProfile = certificateProfile;
        this.endEntityProfile = endEntityProfile;
        this.expireDate = expireDate;
        this.invalidityDate = invalidityDate;
        this.issuerDN = issuerDN;
        this.notBefore = notBefore;
        this.revocationDate = revocationDate;
        this.revocationReason = revocationReason;
        this.serialNumber = serialNumber;
        this.status = status;
        this.subjectAltName = subjectAltName;
        this.subjectDN = subjectDN;
        this.subjectKeyId = subjectKeyId;
        this.tag = tag;
        this.type = type;
        this.udpateTime = udpateTime;
        this.username = username;
        this.base64Cert = base64Cert;
        this.certificateRequest = certificateRequest;
        this.crlPartitionIndex = crlPartitionIndex;
    }

    @Nullable
    @ApiModelProperty(example="123abc456def789ghi123klm456nop789qrs123t", value="Certificate fingerprint")
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Nullable
    @ApiModelProperty(example="abc123def456ghi789klm123nop456qrs789tvx1", value="Certificate Authority fingerprint")
    public String getcAFingerprint() {
        return this.cAFingerprint;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Certificate Profile Identifier")
    public Integer getCertificateProfileId() {
        return this.certificateProfileId;
    }

    @Nullable
    @ApiModelProperty(example="1", value="End Entity Profile Identifier")
    public Integer getEndEntityProfileId() {
        return this.endEntityProfileId;
    }

    @Nullable
    @ApiModelProperty(example="cert profile", value="Certificate Profile Name")
    public String getCertificateProfile() {
        return this.certificateProfile;
    }

    @Nullable
    @ApiModelProperty(example="End Entity Profile", value="End Entity Profile Name")
    public String getEndEntityProfile() {
        return this.endEntityProfile;
    }

    @Nullable
    @ApiModelProperty(example="2147483647000", value="Date after which certificate should be considered expired")
    public Long getExpireDate() {
        return this.expireDate;
    }

    @Nullable
    @ApiModelProperty(example="2147483647000", value="Date after which certificate should be considered invalid")
    public Long getInvalidityDate() {
        return this.invalidityDate;
    }

    @Nullable
    @ApiModelProperty(example="CN=ExampleCA", value="Issuer Distinguished Name")
    public String getIssuerDN() {
        return this.issuerDN;
    }

    @Nullable
    @ApiModelProperty(example="1659952800011", value="Date at which certificate became valid")
    public Long getNotBefore() {
        return this.notBefore;
    }

    @Nullable
    @ApiModelProperty(example="-1", value="Revocation date")
    public Long getRevocationDate() {
        return this.revocationDate;
    }

    @Nullable
    @ApiModelProperty(example="-1", value="Revocation reson")
    public Integer getRevocationReason() {
        return this.revocationReason;
    }

    @Nullable
    @ApiModelProperty(example="1234567890ABCDEF", value="Hex Serial Number")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Nullable
    @ApiModelProperty(example="20", value="Certificate status")
    public Integer getStatus() {
        return this.status;
    }

    @Nullable
    @ApiModelProperty(example="rfc822Name=john.doe@example.com", value="Subject Alternative Name (SAN)")
    public String getSubjectAltName() {
        return this.subjectAltName;
    }

    @Nullable
    @ApiModelProperty(example="CN=John Doe,SURNAME=Doe,GIVENNAME=John,C=SE", value="Subject Distinguished Name")
    public String getSubjectDN() {
        return this.subjectDN;
    }

    @Nullable
    @ApiModelProperty(example="z123abc456def789ghi123klm456nop789qrs123", value="Subject Key Identifier")
    public String getSubjectKeyId() {
        return this.subjectKeyId;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getTag() {
        return this.tag;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Integer getType() {
        return this.type;
    }

    @Nullable
    @ApiModelProperty(example="1659967133000", value="Update time")
    public Long getUdpateTime() {
        return this.udpateTime;
    }

    @Nullable
    @ApiModelProperty(example="JohnDoe", value="Username")
    public String getUsername() {
        return this.username;
    }

    @Nullable
    @ApiModelProperty(example="TUlJR...t2A==", value="Base64 encoded certificate")
    public String getBase64Cert() {
        return this.base64Cert;
    }

    @Nullable
    @ApiModelProperty(example="-----BEGIN CERTIFICATE REQUEST----- MIICh...V8shQ== -----END CERTIFICATE REQUEST-----", value="Certificate request")
    public String getCertificateRequest() {
        return this.certificateRequest;
    }

    @Nullable
    @ApiModelProperty(example="1", value="CRL partition index")
    public Integer getCrlPartitionIndex() {
        return this.crlPartitionIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateRestResponseV2 certificateRestResponseV2 = (CertificateRestResponseV2)o;
        return Objects.equals(this.fingerprint, certificateRestResponseV2.fingerprint) && Objects.equals(this.cAFingerprint, certificateRestResponseV2.cAFingerprint) && Objects.equals(this.certificateProfileId, certificateRestResponseV2.certificateProfileId) && Objects.equals(this.endEntityProfileId, certificateRestResponseV2.endEntityProfileId) && Objects.equals(this.expireDate, certificateRestResponseV2.expireDate) && Objects.equals(this.invalidityDate, certificateRestResponseV2.invalidityDate) && Objects.equals(this.issuerDN, certificateRestResponseV2.issuerDN) && Objects.equals(this.notBefore, certificateRestResponseV2.notBefore) && Objects.equals(this.revocationDate, certificateRestResponseV2.revocationDate) && Objects.equals(this.revocationReason, certificateRestResponseV2.revocationReason) && Objects.equals(this.serialNumber, certificateRestResponseV2.serialNumber) && Objects.equals(this.status, certificateRestResponseV2.status) && Objects.equals(this.subjectAltName, certificateRestResponseV2.subjectAltName) && Objects.equals(this.subjectDN, certificateRestResponseV2.subjectDN) && Objects.equals(this.subjectKeyId, certificateRestResponseV2.subjectKeyId) && Objects.equals(this.tag, certificateRestResponseV2.tag) && Objects.equals(this.type, certificateRestResponseV2.type) && Objects.equals(this.udpateTime, certificateRestResponseV2.udpateTime) && Objects.equals(this.username, certificateRestResponseV2.username) && Objects.equals(this.base64Cert, certificateRestResponseV2.base64Cert) && Objects.equals(this.certificateRequest, certificateRestResponseV2.certificateRequest) && Objects.equals(this.crlPartitionIndex, certificateRestResponseV2.crlPartitionIndex);
    }

    public int hashCode() {
        return Objects.hash(this.fingerprint, this.cAFingerprint, this.certificateProfileId, this.endEntityProfileId, this.expireDate, this.invalidityDate, this.issuerDN, this.notBefore, this.revocationDate, this.revocationReason, this.serialNumber, this.status, this.subjectAltName, this.subjectDN, this.subjectKeyId, this.tag, this.type, this.udpateTime, this.username, this.base64Cert, this.certificateRequest, this.crlPartitionIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CertificateRestResponseV2 {\n");
        sb.append("    fingerprint: ").append(this.toIndentedString((Object)this.fingerprint)).append("\n");
        sb.append("    cAFingerprint: ").append(this.toIndentedString((Object)this.cAFingerprint)).append("\n");
        sb.append("    certificateProfileId: ").append(this.toIndentedString((Object)this.certificateProfileId)).append("\n");
        sb.append("    certificateProfile: ").append(this.toIndentedString((Object)this.certificateProfile)).append("\n");
        sb.append("    endEntityProfileId: ").append(this.toIndentedString((Object)this.endEntityProfileId)).append("\n");
        sb.append("    endEntityProfile: ").append(this.toIndentedString((Object)this.endEntityProfile)).append("\n");
        sb.append("    expireDate: ").append(this.toIndentedString((Object)this.expireDate)).append("\n");
        sb.append("    invalidityDate: ").append(this.toIndentedString((Object)this.invalidityDate)).append("\n");
        sb.append("    issuerDN: ").append(this.toIndentedString((Object)this.issuerDN)).append("\n");
        sb.append("    notBefore: ").append(this.toIndentedString((Object)this.notBefore)).append("\n");
        sb.append("    revocationDate: ").append(this.toIndentedString((Object)this.revocationDate)).append("\n");
        sb.append("    revocationReason: ").append(this.toIndentedString((Object)this.revocationReason)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString((Object)this.serialNumber)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    subjectAltName: ").append(this.toIndentedString((Object)this.subjectAltName)).append("\n");
        sb.append("    subjectDN: ").append(this.toIndentedString((Object)this.subjectDN)).append("\n");
        sb.append("    subjectKeyId: ").append(this.toIndentedString((Object)this.subjectKeyId)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString((Object)this.tag)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    udpateTime: ").append(this.toIndentedString((Object)this.udpateTime)).append("\n");
        sb.append("    username: ").append(this.toIndentedString((Object)this.username)).append("\n");
        sb.append("    base64Cert: ").append(this.toIndentedString((Object)this.base64Cert)).append("\n");
        sb.append("    certificateRequest: ").append(this.toIndentedString((Object)this.certificateRequest)).append("\n");
        sb.append("    crlPartitionIndex: ").append(this.toIndentedString((Object)this.crlPartitionIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CertificateRestResponseV2 is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CertificateRestResponseV2` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FINGERPRINT) != null && !jsonObj.get(SERIALIZED_NAME_FINGERPRINT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FINGERPRINT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fingerprint` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FINGERPRINT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_C_A_FINGERPRINT) != null && !jsonObj.get(SERIALIZED_NAME_C_A_FINGERPRINT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_C_A_FINGERPRINT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cAFingerprint` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_C_A_FINGERPRINT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ISSUER_D_N) != null && !jsonObj.get(SERIALIZED_NAME_ISSUER_D_N).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ISSUER_D_N).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `issuerDN` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ISSUER_D_N).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERIAL_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_SERIAL_NUMBER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SERIAL_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `serialNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERIAL_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBJECT_ALT_NAME) != null && !jsonObj.get(SERIALIZED_NAME_SUBJECT_ALT_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SUBJECT_ALT_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subjectAltName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBJECT_ALT_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBJECT_D_N) != null && !jsonObj.get(SERIALIZED_NAME_SUBJECT_D_N).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SUBJECT_D_N).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subjectDN` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBJECT_D_N).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBJECT_KEY_ID) != null && !jsonObj.get(SERIALIZED_NAME_SUBJECT_KEY_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SUBJECT_KEY_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subjectKeyId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBJECT_KEY_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAG) != null && !jsonObj.get(SERIALIZED_NAME_TAG).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TAG).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `tag` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAG).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNAME) != null && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BASE64_CERT) != null && !jsonObj.get(SERIALIZED_NAME_BASE64_CERT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BASE64_CERT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `base64Cert` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BASE64_CERT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CERTIFICATE_REQUEST) != null && !jsonObj.get(SERIALIZED_NAME_CERTIFICATE_REQUEST).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CERTIFICATE_REQUEST).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `certificateRequest` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CERTIFICATE_REQUEST).toString()));
        }
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FINGERPRINT);
        openapiFields.add(SERIALIZED_NAME_C_A_FINGERPRINT);
        openapiFields.add(SERIALIZED_NAME_CERTIFICATE_PROFILE_ID);
        openapiFields.add(SERIALIZED_NAME_END_ENTITY_PROFILE_ID);
        openapiFields.add(SERIALIZED_NAME_EXPIRE_DATE);
        openapiFields.add("invalidityDate");
        openapiFields.add(SERIALIZED_NAME_ISSUER_D_N);
        openapiFields.add(SERIALIZED_NAME_NOT_BEFORE);
        openapiFields.add(SERIALIZED_NAME_REVOCATION_DATE);
        openapiFields.add(SERIALIZED_NAME_REVOCATION_REASON);
        openapiFields.add(SERIALIZED_NAME_SERIAL_NUMBER);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_SUBJECT_ALT_NAME);
        openapiFields.add(SERIALIZED_NAME_SUBJECT_D_N);
        openapiFields.add(SERIALIZED_NAME_SUBJECT_KEY_ID);
        openapiFields.add(SERIALIZED_NAME_TAG);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_UDPATE_TIME);
        openapiFields.add(SERIALIZED_NAME_USERNAME);
        openapiFields.add(SERIALIZED_NAME_BASE64_CERT);
        openapiFields.add(SERIALIZED_NAME_CERTIFICATE_REQUEST);
        openapiFields.add(SERIALIZED_NAME_CRL_PARTITION_INDEX);
        openapiRequiredFields = new HashSet();
    }
}

