/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.ejbca;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.schedule.ImportInfo;
import de.trustable.ca3s.core.service.cmp.SSLSocketFactoryWrapper;
import de.trustable.ca3s.core.service.dto.ejbca.CertificateRestResponseV2;
import de.trustable.ca3s.core.service.dto.ejbca.Pagination;
import de.trustable.ca3s.core.service.dto.ejbca.SearchCertificateCriteriaRestRequest;
import de.trustable.ca3s.core.service.dto.ejbca.SearchCertificateSortRestRequest;
import de.trustable.ca3s.core.service.dto.ejbca.SearchCertificatesRestRequestV2;
import de.trustable.ca3s.core.service.dto.ejbca.SearchCertificatesRestResponseV2;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.time.Instant;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EjbcaConnector {
    Logger LOGGER = LoggerFactory.getLogger(EjbcaConnector.class);
    final int PAGE_SIZE = 10;
    private final X509TrustManager ca3sTrustManager;
    private final CertificateUtil certUtil;

    public EjbcaConnector(X509TrustManager ca3sTrustManager, CertificateUtil certUtil) {
        this.ca3sTrustManager = ca3sTrustManager;
        this.certUtil = certUtil;
    }

    @Transactional
    public int retrieveCertificates(CAConnectorConfig caConfig) throws IOException {
        ImportInfo importInfo;
        block6: {
            importInfo = new ImportInfo();
            if (caConfig.getCaUrl() == null) {
                this.LOGGER.warn("in retrieveCertificates: url missing");
                return 0;
            }
            SearchCertificatesRestRequestV2 searchCertificatesRestRequestV2 = new SearchCertificatesRestRequestV2();
            SearchCertificateCriteriaRestRequest certificateCriteriaRestRequest = new SearchCertificateCriteriaRestRequest();
            certificateCriteriaRestRequest.setProperty(SearchCertificateCriteriaRestRequest.PropertyEnum.ISSUED_DATE);
            String lastUpdate = caConfig.getLastUpdate() == null ? "2018-06-27T08:07:52Z" : caConfig.getLastUpdate().toString();
            certificateCriteriaRestRequest.setValue(lastUpdate);
            certificateCriteriaRestRequest.setOperation(SearchCertificateCriteriaRestRequest.OperationEnum.AFTER);
            searchCertificatesRestRequestV2.addCriteriaItem(certificateCriteriaRestRequest);
            Pagination pagination = new Pagination();
            pagination.setCurrentPage(Integer.valueOf(1));
            pagination.setPageSize(Integer.valueOf(10));
            searchCertificatesRestRequestV2.setPagination(pagination);
            SearchCertificateSortRestRequest searchCertificateSortRestRequest = new SearchCertificateSortRestRequest();
            searchCertificateSortRestRequest.setProperty(SearchCertificateSortRestRequest.PropertyEnum.ISSUED_DATE);
            searchCertificateSortRestRequest.setOperation(SearchCertificateSortRestRequest.OperationEnum.ASC);
            searchCertificatesRestRequestV2.setSort(searchCertificateSortRestRequest);
            try {
                Certificate certificateTlsAuthentication = caConfig.getTlsAuthentication();
                String url = caConfig.getCaUrl().toLowerCase();
                if (url.startsWith("http://") || certificateTlsAuthentication == null) {
                    importInfo = this.invokeRestEndpoint(caConfig, importInfo, url, this.marshallRequest(searchCertificatesRestRequestV2), null, true, null, null);
                    break block6;
                }
                if (url.startsWith("https://")) {
                    CertificateUtil.KeyStoreAndPassphrase keyStoreAndPassphrase = this.certUtil.getContainer(certificateTlsAuthentication, "entryAlias", "passphraseChars".toCharArray(), "PBEWithHmacSHA256AndAES_256");
                    importInfo = this.invokeRestEndpoint(caConfig, importInfo, url, this.marshallRequest(searchCertificatesRestRequestV2), null, true, keyStoreAndPassphrase.getKeyStore(), new String(keyStoreAndPassphrase.getPassphraseChars()));
                    break block6;
                }
                return 0;
            }
            catch (IOException e) {
                this.LOGGER.debug("problem retrieving certificates from ejbca", (Throwable)e);
                throw e;
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return importInfo.getImported();
    }

    private ImportInfo invokeRestEndpoint(CAConnectorConfig caConfig, ImportInfo importInfo, String requestUrl, byte[] requestBytes, String sni, boolean disableHostNameVerifier, KeyStore keyStore, String keyPassword) throws IOException {
        this.LOGGER.debug("Sending request to: " + requestUrl);
        long startTime = System.currentTimeMillis();
        URL url = new URL(requestUrl);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        if ("https".equals(url.getProtocol())) {
            try {
                KeyManager[] keyManagers = null;
                if (keyStore != null) {
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                    keyManagerFactory.init(keyStore, keyPassword.toCharArray());
                    keyManagers = keyManagerFactory.getKeyManagers();
                    this.LOGGER.debug("using client keystore");
                }
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(keyManagers, new TrustManager[]{this.ca3sTrustManager}, new SecureRandom());
                SSLSocketFactory socketFactory = sc.getSocketFactory();
                if (sni != null && !sni.trim().isEmpty()) {
                    this.LOGGER.debug("using sni '{}' for CA '{}'", (Object)sni, (Object)requestUrl);
                    SSLParameters sslParameters = new SSLParameters();
                    ArrayList<SNIServerName> sniHostNames = new ArrayList<SNIServerName>(1);
                    sniHostNames.add(new SNIHostName(sni));
                    sslParameters.setServerNames(sniHostNames);
                    socketFactory = new SSLSocketFactoryWrapper(socketFactory, sslParameters);
                }
                HttpsURLConnection conTLS = (HttpsURLConnection)con;
                if (disableHostNameVerifier) {
                    conTLS.setHostnameVerifier((HostnameVerifier)new /* Unavailable Anonymous Inner Class!! */);
                }
                conTLS.setSSLSocketFactory(socketFactory);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IOException("problem configuring the SSLContext", e);
            }
            catch (UnrecoverableKeyException e) {
                throw new IOException("problem reading keystore", e);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        } else if (!"http".equals(url.getProtocol())) {
            throw new IOException("Unexpected protocol '" + url.getProtocol() + "'");
        }
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/json");
        OutputStream os = con.getOutputStream();
        os.write(requestBytes);
        os.close();
        byte[] responseArr = IOUtils.toByteArray((InputStream)con.getInputStream());
        this.LOGGER.debug("Received response bytes: {}", (Object)new String(responseArr));
        this.parseResponse(responseArr, importInfo, caConfig);
        if (con.getResponseCode() != 200) {
            throw new IOException("Error sending CMP request. Response code != 200 : " + con.getResponseCode());
        }
        this.LOGGER.debug("Received certificate reply.");
        con.disconnect();
        this.LOGGER.debug("duration of remote EJBCA inventory call " + (System.currentTimeMillis() - startTime));
        return importInfo;
    }

    byte[] marshallRequest(SearchCertificatesRestRequestV2 searchCertificatesRestRequestV2) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        objectMapper.writeValue((OutputStream)boas, (Object)searchCertificatesRestRequestV2);
        this.LOGGER.debug("in retrieveCertificates: query: {}", (Object)boas.toString());
        return boas.toByteArray();
    }

    void parseResponse(byte[] responseArr, ImportInfo importInfo, CAConnectorConfig caConfig) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            SearchCertificatesRestResponseV2 certificateSearchResponse = (SearchCertificatesRestResponseV2)objectMapper.readValue(responseArr, SearchCertificatesRestResponseV2.class);
            for (CertificateRestResponseV2 certificateRestResponse : certificateSearchResponse.getCertificates()) {
                String desc = (certificateRestResponse.getSubjectDN() == null ? "" : certificateRestResponse.getSubjectDN()) + ", #" + certificateRestResponse.getSerialNumber();
                if (certificateRestResponse.getBase64Cert() != null) {
                    CSR csr = null;
                    if (certificateRestResponse.getCertificateRequest() != null) {
                        this.LOGGER.info("CertificateRestResponseV2 contains csr!");
                    }
                    byte[] certBytes = Base64.decodeBase64((byte[])Base64.decodeBase64((String)certificateRestResponse.getBase64Cert()));
                    try {
                        Instant notBeforeConfig;
                        try {
                            Certificate certificate = this.certUtil.createCertificate(certBytes, csr, "", true, caConfig.getCaUrl());
                            this.LOGGER.debug("imported certificate: {}", (Object)certificate);
                            importInfo.incImported();
                        }
                        catch (Exception e) {
                            this.LOGGER.info("CertificateRestResponseV2: processing certificate for '{}' failed: {} ", (Object)desc, (Object)e.getMessage());
                            importInfo.incRejected();
                        }
                        if (certificateRestResponse.getNotBefore() == null) continue;
                        this.LOGGER.info("CertificateRestResponseV2 contains UpdateTime: {}", (Object)certificateRestResponse.getUdpateTime());
                        Instant notBeforeInstant = Instant.ofEpochMilli(certificateRestResponse.getNotBefore());
                        if (!notBeforeInstant.isAfter(notBeforeConfig = caConfig.getLastUpdate() == null ? Instant.MIN : caConfig.getLastUpdate())) continue;
                        this.LOGGER.info("caConfig.setLastUpdate( {} )", (Object)certificateRestResponse.getUdpateTime());
                        caConfig.setLastUpdate(notBeforeInstant);
                    }
                    catch (Exception e) {
                        this.LOGGER.info("CertificateRestResponseV2: processing last update failed: {} ", (Object)e.getMessage());
                    }
                    continue;
                }
                this.LOGGER.info("CertificateRestResponseV2 does not contain base64 data for {}", (Object)desc);
            }
        }
        catch (IOException e) {
            this.LOGGER.info("unmarshalling CertificateRestResponseV2", (Throwable)e);
        }
    }
}

