/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.AcmeChallenge;
import de.trustable.ca3s.core.repository.AcmeChallengeRepository;
import de.trustable.ca3s.core.service.AcmeChallengeService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AcmeChallengeServiceImpl
implements AcmeChallengeService {
    private final Logger log = LoggerFactory.getLogger(AcmeChallengeServiceImpl.class);
    private final AcmeChallengeRepository acmeChallengeRepository;

    public AcmeChallengeServiceImpl(AcmeChallengeRepository acmeChallengeRepository) {
        this.acmeChallengeRepository = acmeChallengeRepository;
    }

    public AcmeChallenge save(AcmeChallenge acmeChallenge) {
        this.log.debug("Request to save AcmeChallenge : {}", (Object)acmeChallenge);
        return (AcmeChallenge)this.acmeChallengeRepository.save((Object)acmeChallenge);
    }

    @Transactional(readOnly=true)
    public List<AcmeChallenge> findAll() {
        this.log.debug("Request to get all AcmeChallenges");
        return this.acmeChallengeRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<AcmeChallenge> findOne(Long id) {
        this.log.debug("Request to get AcmeChallenge : {}", (Object)id);
        return this.acmeChallengeRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete AcmeChallenge : {}", (Object)id);
        this.acmeChallengeRepository.deleteById((Object)id);
    }

    public List<AcmeChallenge> findPendingByRequestProxy(Long requestProxyId) {
        return this.acmeChallengeRepository.findPendingByRequestProxy(requestProxyId);
    }
}

