/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.CRLExpirationNotification;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.CRLExpirationNotificationRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.CRLExpirationNotificationService;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CRLExpirationNotificationServiceImpl
implements CRLExpirationNotificationService {
    private final Logger log = LoggerFactory.getLogger(CRLExpirationNotificationServiceImpl.class);
    private final CRLExpirationNotificationRepository cRLExpirationNotificationRepository;
    private final CertificateRepository certificateRepository;
    private final CertificateUtil certUtil;

    public CRLExpirationNotificationServiceImpl(CRLExpirationNotificationRepository cRLExpirationNotificationRepository, CertificateRepository certificateRepository, CertificateUtil certUtil) {
        this.cRLExpirationNotificationRepository = cRLExpirationNotificationRepository;
        this.certificateRepository = certificateRepository;
        this.certUtil = certUtil;
    }

    public List<CRLExpirationNotification> createByCertificateId(Long certificateId) {
        Certificate certificate;
        this.log.debug("Request to create a CRLExpirationNotification from certificate id : {}", (Object)certificateId);
        ArrayList<CRLExpirationNotification> crlExpirationNotificationList = new ArrayList<CRLExpirationNotification>();
        Optional certificateOptional = this.certificateRepository.findById((Object)certificateId);
        if (certificateOptional.isPresent() && (certificate = (Certificate)certificateOptional.get()).getIssuingCertificate() != null) {
            List crlUrls = this.certUtil.getCertAttributes(certificate, "CRL_URL");
            for (String crlUrl : crlUrls) {
                CRLExpirationNotification crlExpirationNotification = new CRLExpirationNotification();
                crlExpirationNotification.setCrlUrl(crlUrl);
                crlExpirationNotification.setNotifyUntil(certificate.getIssuingCertificate().getValidTo());
                crlExpirationNotification.setNotifyBefore(Duration.ofDays(7L));
                crlExpirationNotificationList.add(crlExpirationNotification);
            }
        }
        this.cRLExpirationNotificationRepository.saveAll(crlExpirationNotificationList);
        return crlExpirationNotificationList;
    }

    public CRLExpirationNotification save(CRLExpirationNotification cRLExpirationNotification) {
        this.log.debug("Request to save CRLExpirationNotification : {}", (Object)cRLExpirationNotification);
        return (CRLExpirationNotification)this.cRLExpirationNotificationRepository.save((Object)cRLExpirationNotification);
    }

    public CRLExpirationNotification update(CRLExpirationNotification cRLExpirationNotification) {
        this.log.debug("Request to update CRLExpirationNotification : {}", (Object)cRLExpirationNotification);
        return (CRLExpirationNotification)this.cRLExpirationNotificationRepository.save((Object)cRLExpirationNotification);
    }

    public Optional<CRLExpirationNotification> partialUpdate(CRLExpirationNotification cRLExpirationNotification) {
        this.log.debug("Request to partially update CRLExpirationNotification : {}", (Object)cRLExpirationNotification);
        return this.cRLExpirationNotificationRepository.findById((Object)cRLExpirationNotification.getId()).map(existingCRLExpirationNotification -> {
            if (cRLExpirationNotification.getCrlUrl() != null) {
                existingCRLExpirationNotification.setCrlUrl(cRLExpirationNotification.getCrlUrl());
            }
            if (cRLExpirationNotification.getNotifyBefore() != null) {
                existingCRLExpirationNotification.setNotifyBefore(cRLExpirationNotification.getNotifyBefore());
            }
            return existingCRLExpirationNotification;
        }).map(arg_0 -> ((CRLExpirationNotificationRepository)this.cRLExpirationNotificationRepository).save(arg_0));
    }

    @Transactional(readOnly=true)
    public List<CRLExpirationNotification> findAll() {
        this.log.debug("Request to get all CRLExpirationNotifications");
        return this.cRLExpirationNotificationRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<CRLExpirationNotification> findOne(Long id) {
        this.log.debug("Request to get CRLExpirationNotification : {}", (Object)id);
        return this.cRLExpirationNotificationRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete CRLExpirationNotification : {}", (Object)id);
        this.cRLExpirationNotificationRepository.deleteById((Object)id);
    }
}

