/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.AcmeAuthorization;
import de.trustable.ca3s.core.domain.AcmeChallenge;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.enumeration.AcmeOrderStatus;
import de.trustable.ca3s.core.domain.enumeration.ChallengeStatus;
import de.trustable.ca3s.core.repository.AcmeOrderRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.dto.AcmeChallengeView;
import de.trustable.ca3s.core.service.dto.AcmeOrderView;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AcmeOrderUtil {
    static Logger LOG = LoggerFactory.getLogger(AcmeOrderUtil.class);
    private final AuditService auditService;
    private final AcmeOrderRepository orderRepository;

    public AcmeOrderUtil(AuditService auditService, AcmeOrderRepository orderRepository) {
        this.auditService = auditService;
        this.orderRepository = orderRepository;
    }

    public AcmeOrderView from(AcmeOrder acmeOrder) {
        AcmeOrderView acmeOrderView = new AcmeOrderView();
        acmeOrderView.setId(acmeOrder.getId());
        acmeOrderView.setOrderId(String.valueOf(acmeOrder.getOrderId()));
        acmeOrderView.setAccountId(String.valueOf(acmeOrder.getAccount().getId()));
        acmeOrderView.setRealm(acmeOrder.getAccount().getRealm());
        acmeOrderView.setStatus(acmeOrder.getStatus());
        if (acmeOrder.getCertificate() != null) {
            acmeOrderView.setCertificateId(acmeOrder.getCertificate().getId());
        }
        if (acmeOrder.getCsr() != null) {
            acmeOrderView.setCsrId(acmeOrder.getCsr().getId());
        }
        acmeOrderView.setCreatedOn(acmeOrder.getCreatedOn());
        acmeOrderView.setExpires(acmeOrder.getExpires());
        LOG.info("expires from AcmeOrder: " + acmeOrder.getExpires());
        acmeOrderView.setNotBefore(acmeOrder.getNotBefore());
        acmeOrderView.setNotAfter(acmeOrder.getNotAfter());
        acmeOrderView.setError(acmeOrder.getError());
        acmeOrderView.setFinalizeUrl(acmeOrder.getFinalizeUrl());
        acmeOrderView.setCertificateUrl(acmeOrder.getCertificateUrl());
        HashSet<String> urlSet = new HashSet<String>();
        HashSet<String> typeSet = new HashSet<String>();
        for (AcmeAuthorization acmeAuthorization : acmeOrder.getAcmeAuthorizations()) {
            for (AcmeChallenge acmeChallenge : acmeAuthorization.getChallenges()) {
                urlSet.add(acmeChallenge.getValue());
                typeSet.add(acmeChallenge.getType());
            }
        }
        Object urls = "";
        Iterator itUrl = urlSet.iterator();
        while (itUrl.hasNext()) {
            if (!((String)urls).isEmpty()) {
                urls = (String)urls + "; ";
            }
            urls = (String)urls + (String)itUrl.next();
        }
        acmeOrderView.setChallengeUrls((String)urls);
        Object types = "";
        Iterator itType = typeSet.iterator();
        while (itType.hasNext()) {
            if (!((String)types).isEmpty()) {
                types = (String)types + "; ";
            }
            types = (String)types + (String)itType.next();
        }
        acmeOrderView.setChallengeTypes((String)types);
        return acmeOrderView;
    }

    public List<AcmeChallengeView> challengeListfrom(AcmeOrder acmeOrder) {
        ArrayList<AcmeChallengeView> acmeChallengeViewList = new ArrayList<AcmeChallengeView>();
        for (AcmeAuthorization acmeAuthorization : acmeOrder.getAcmeAuthorizations()) {
            for (AcmeChallenge acmeChallenge : acmeAuthorization.getChallenges()) {
                AcmeChallengeView acmeChallengeView = this.getAcmeChallengeView(acmeAuthorization, acmeChallenge);
                acmeChallengeViewList.add(acmeChallengeView);
            }
        }
        return acmeChallengeViewList;
    }

    @NotNull
    private AcmeChallengeView getAcmeChallengeView(AcmeAuthorization acmeAuthorization, AcmeChallenge acmeChallenge) {
        AcmeChallengeView acmeChallengeView = new AcmeChallengeView();
        acmeChallengeView.setAuthorizationType(acmeAuthorization.getType());
        acmeChallengeView.setAuthorizationValue(acmeAuthorization.getValue());
        acmeChallengeView.setChallengeId(acmeChallenge.getId());
        acmeChallengeView.setStatus(acmeChallenge.getStatus());
        acmeChallengeView.setType(acmeChallenge.getType());
        acmeChallengeView.setValue(acmeChallenge.getValue());
        acmeChallengeView.setValidated(acmeChallenge.getValidated());
        return acmeChallengeView;
    }

    public void alignOrderState(AcmeOrder orderDao) {
        if (orderDao.getStatus().equals((Object)AcmeOrderStatus.READY)) {
            LOG.info("order status already '{}', no re-check after challenge state change required", (Object)orderDao.getStatus());
            return;
        }
        if (orderDao.getStatus() != AcmeOrderStatus.PENDING) {
            LOG.warn("unexpected order status '{}' (!= Pending), no re-check after challenge state change required", (Object)orderDao.getStatus());
            return;
        }
        boolean orderReady = true;
        for (AcmeAuthorization authDao : orderDao.getAcmeAuthorizations()) {
            boolean authReady = false;
            for (AcmeChallenge challDao : authDao.getChallenges()) {
                if (challDao.getStatus() != ChallengeStatus.VALID) continue;
                LOG.debug("challenge {} of type {} is valid ", (Object)challDao.getChallengeId(), (Object)challDao.getType());
                authReady = true;
                break;
            }
            if (authReady) {
                LOG.debug("found valid challenge, authorization id {} is valid ", (Object)authDao.getAcmeAuthorizationId());
                continue;
            }
            LOG.debug("no valid challenge, authorization id {} and order {} still pending", (Object)authDao.getAcmeAuthorizationId(), (Object)orderDao.getOrderId());
            orderReady = false;
            break;
        }
        if (orderReady) {
            LOG.debug("order status set to READY");
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceAcmeOrderSucceeded(orderDao.getAccount(), orderDao));
            orderDao.setStatus(AcmeOrderStatus.READY);
            this.orderRepository.save((Object)orderDao);
        }
    }
}

