/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.trustable.ca3s.core.service.dto.acme.AccountRequest;
import de.trustable.ca3s.core.service.dto.acme.AccountResponse;
import de.trustable.ca3s.core.service.dto.acme.ChangeKeyRequest;
import de.trustable.ca3s.core.service.dto.acme.FinalizeRequest;
import de.trustable.ca3s.core.service.dto.acme.IdentifiersResponse;
import de.trustable.ca3s.core.service.dto.acme.JWKJsonDeserializer;
import de.trustable.ca3s.core.service.dto.acme.NewOrderRequest;
import de.trustable.ca3s.core.service.dto.acme.NewOrderResponse;
import de.trustable.ca3s.core.service.dto.acme.OrderResponse;
import de.trustable.ca3s.core.service.dto.acme.RevokeRequest;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.AcmeUtil;
import java.io.IOException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.InvalidJwtSignatureException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class JwtUtil {
    public static final String KID = "kid";
    public static final String NONCE = "nonce";
    public static final String JWK = "jwk";
    private static final String NO_EXPLICIT_JCA_PROVIDER = null;
    private static final String EMPTY_PAYLOAD_REPLACEMENT_B64 = "e30";
    private static final Logger LOG = LoggerFactory.getLogger(JwtUtil.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final JwtConsumer NOT_VALIDATING_JWT_CONSUMER = new JwtConsumerBuilder().setSkipAllValidators().setDisableRequireSignature().setSkipSignatureVerification().build();

    public JwtUtil() {
        this.objectMapper.registerModule((Module)new JavaTimeModule());
    }

    public JwtContext processFlattenedJWT(String flattenedJwsJson) {
        LOG.debug("Converting Flattened JWT: {}", (Object)flattenedJwsJson);
        try {
            JsonNode jsonRootNode = this.objectMapper.readTree(flattenedJwsJson);
            JsonNode jsonProtectedValue = jsonRootNode.get("protected");
            if (jsonProtectedValue == null) {
                throw new IOException("JWT component 'protected' missing");
            }
            String protectedValue = jsonProtectedValue.asText();
            LOG.debug("protected JWT content decoded: {}", (Object)new String(org.apache.commons.codec.binary.Base64.decodeBase64((String)protectedValue)));
            JsonNode jsonPayloadValue = jsonRootNode.get("payload");
            if (jsonPayloadValue == null) {
                throw new IOException("JWT component 'payload' missing");
            }
            String payload = jsonPayloadValue.asText();
            if (payload.length() == 0) {
                payload = EMPTY_PAYLOAD_REPLACEMENT_B64;
            }
            LOG.debug("JWT payload decoded: {}", (Object)new String(org.apache.commons.codec.binary.Base64.decodeBase64((String)payload)));
            JsonNode jsonSignatureValue = jsonRootNode.get("signature");
            if (jsonSignatureValue == null) {
                throw new IOException("JWT component 'signature' missing");
            }
            String signature = jsonSignatureValue.asText();
            String compactJwsSerialization = protectedValue + "." + payload + "." + signature;
            return NOT_VALIDATING_JWT_CONSUMER.process(compactJwsSerialization);
        }
        catch (IOException | InvalidJwtException e) {
            LOG.debug("Problem processing JWT from flattenedJwsJson : " + flattenedJwsJson, e);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "JWT processing problem", HttpStatus.BAD_REQUEST, e.getMessage(), AcmeUtil.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
    }

    public JwtContext processCompactJWT(String compactJwsSerialization) {
        LOG.debug("Processing Compact JWT: {}", (Object)compactJwsSerialization);
        try {
            return NOT_VALIDATING_JWT_CONSUMER.process(compactJwsSerialization);
        }
        catch (InvalidJwtException e) {
            LOG.debug("Problem processing JWT from compactJwsSerialization : " + compactJwsSerialization, (Throwable)e);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "JWT processing problem", HttpStatus.BAD_REQUEST, e.getMessage(), AcmeUtil.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
    }

    public JwtContext convertCompact(String compactJwsSerialization) throws InvalidJwtException {
        return NOT_VALIDATING_JWT_CONSUMER.process(compactJwsSerialization);
    }

    public void validateSignature(JwtContext context, String publicKeyBase64, long accountId) throws InvalidJwtException, JoseException, IOException {
        try {
            JsonWebStructure webStruct = this.getJsonWebStructure(context);
            String algHeader = webStruct.getAlgorithmHeaderValue();
            String keyAlgo = "RSA";
            if (algHeader.toUpperCase().startsWith("E")) {
                keyAlgo = "EC";
            }
            LOG.debug("jws key algo {} selected by JWT algorithm header {}", (Object)keyAlgo, (Object)algHeader);
            KeyFactory kf = KeyFactory.getInstance(keyAlgo);
            PublicKey publicKey = kf.generatePublic(new X509EncodedKeySpec(org.apache.commons.codec.binary.Base64.decodeBase64((String)publicKeyBase64)));
            try {
                JwtConsumer jwtConsumer = new JwtConsumerBuilder().setVerificationKey((Key)publicKey).build();
                jwtConsumer.processContext(context);
                LOG.debug("JWT signature validation successful for account {}", (Object)accountId);
            }
            catch (InvalidJwtSignatureException e) {
                String jwt = context.getJwt();
                LOG.debug("JWT signature validation failed for content '" + jwt + "'");
                String[] signatureSerializationParts = jwt.split("\\.");
                if (signatureSerializationParts.length != 3) {
                    LOG.debug("Unexpected number of parts in compact signature {} != 3", (Object)signatureSerializationParts.length);
                } else if (EMPTY_PAYLOAD_REPLACEMENT_B64.equals(signatureSerializationParts[1])) {
                    JsonWebSignature jws = new JsonWebSignature();
                    String compactSerialization = signatureSerializationParts[0] + ".." + signatureSerializationParts[2];
                    jws.setCompactSerialization(compactSerialization);
                    jws.setKey((Key)publicKey);
                    if (jws.verifySignature()) {
                        LOG.debug("JWT signature validation successful after settin payload to 'blank' for account {}", (Object)accountId);
                        return;
                    }
                }
                throw e;
            }
            catch (InvalidJwtException e) {
                LOG.error("Failed signature validation: " + e.getMessage());
                throw e;
            }
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new JoseException("problem reading public key from database", (Throwable)e);
        }
    }

    public void verifyJWT(JwtContext context, PublicKey publicKey) {
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setVerificationKey((Key)publicKey).build();
        try {
            jwtConsumer.processContext(context);
        }
        catch (InvalidJwtException e) {
            LOG.info("Problem verifying JWT", (Throwable)e);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "Problem verifying JWT", HttpStatus.BAD_REQUEST, e.getMessage(), AcmeUtil.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
    }

    public AccountRequest getAccountRequest(JwtClaims jwtClaims) {
        try {
            ObjectReader objectReader = this.objectMapper.readerFor(AccountRequest.class);
            return (AccountRequest)objectReader.readValue(jwtClaims.toJson());
        }
        catch (IOException e) {
            LOG.debug("Problem processing JWT payload for Account ", (Throwable)e);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "JWT processing problem", HttpStatus.BAD_REQUEST, e.getMessage(), AcmeUtil.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
    }

    public String getAccountResponseAsJSON(AccountResponse accountResponse) {
        ObjectWriter objectWriter = this.objectMapper.writerFor(AccountResponse.class);
        try {
            return objectWriter.writeValueAsString((Object)accountResponse);
        }
        catch (JsonProcessingException e) {
            LOG.debug("Problem writing AccountRedponse ", (Throwable)e);
            return e.getMessage();
        }
    }

    public String getOrderResponseAsJSON(NewOrderResponse newOrderResp) {
        ObjectWriter objectWriter = this.objectMapper.writerFor(NewOrderResponse.class);
        try {
            return objectWriter.writeValueAsString((Object)newOrderResp);
        }
        catch (JsonProcessingException e) {
            LOG.debug("Problem writing NewOrderResponse ", (Throwable)e);
            return e.getMessage();
        }
    }

    public String getOrderResponseAsJSON(OrderResponse orderResp) {
        ObjectWriter objectWriter = this.objectMapper.writerFor(OrderResponse.class);
        try {
            return objectWriter.writeValueAsString((Object)orderResp);
        }
        catch (JsonProcessingException e) {
            LOG.debug("Problem writing OrderResponse ", (Throwable)e);
            return e.getMessage();
        }
    }

    public ChangeKeyRequest getChangeKeyRequest(JwtClaims jwtClaims) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            SimpleModule module = new SimpleModule();
            module.addDeserializer(JsonWebKey.class, (JsonDeserializer)new JWKJsonDeserializer());
            mapper.registerModule((Module)module);
            ObjectReader objectReader = mapper.readerFor(ChangeKeyRequest.class);
            return (ChangeKeyRequest)objectReader.readValue(jwtClaims.toJson());
        }
        catch (IOException e) {
            LOG.debug("Problem processing JWT payload for ChangeKeyRequest", (Throwable)e);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "JWT processing problem", HttpStatus.BAD_REQUEST, e.getMessage(), AcmeUtil.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
    }

    public NewOrderRequest getNewOrderRequest(JwtClaims jwtClaims) {
        ObjectReader objectReader = this.objectMapper.readerFor(NewOrderRequest.class);
        try {
            return (NewOrderRequest)objectReader.readValue(jwtClaims.toJson());
        }
        catch (IOException e) {
            LOG.debug("Problem processing JWT payload for NewOrderRequest", (Throwable)e);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "problem parsing NewOrderRequest", HttpStatus.BAD_REQUEST, "", AcmeUtil.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
    }

    public IdentifiersResponse getIdentifiers(JwtClaims jwtClaims) {
        ObjectReader objectReader = this.objectMapper.readerFor(IdentifiersResponse.class);
        try {
            return (IdentifiersResponse)objectReader.readValue(jwtClaims.toJson());
        }
        catch (IOException e) {
            LOG.debug("Problem processing JWT payload for Identifier", (Throwable)e);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "problem parsing Identifier", HttpStatus.BAD_REQUEST, "", AcmeUtil.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
    }

    public FinalizeRequest getFinalizeReq(JwtClaims jwtClaims) {
        ObjectReader objectReader = this.objectMapper.readerFor(FinalizeRequest.class);
        try {
            return (FinalizeRequest)objectReader.readValue(jwtClaims.toJson());
        }
        catch (IOException e) {
            LOG.debug("Problem processing JWT payload for FinalizeRequest", (Throwable)e);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "problem parsing FinalizeRequest", HttpStatus.BAD_REQUEST, "", AcmeUtil.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
    }

    public RevokeRequest getRevokeReq(JwtClaims jwtClaims) {
        ObjectReader objectReader = this.objectMapper.readerFor(RevokeRequest.class);
        try {
            return (RevokeRequest)objectReader.readValue(jwtClaims.toJson());
        }
        catch (IOException e) {
            LOG.debug("Problem processing JWT payload for RevokeRequest", (Throwable)e);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "problem parsing RevokeRequest", HttpStatus.BAD_REQUEST, "", AcmeUtil.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
    }

    public JsonWebStructure getJsonWebStructure(JwtContext context) {
        if (context.getJoseObjects().isEmpty()) {
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "JsonWebStructure missing", HttpStatus.BAD_REQUEST, "", AcmeUtil.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
        if (context.getJoseObjects().size() > 1) {
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "JsonWebStructure contains more than one (" + context.getJoseObjects().size() + ") elements", HttpStatus.BAD_REQUEST, "", AcmeUtil.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
        return (JsonWebStructure)context.getJoseObjects().get(0);
    }

    public long getAccountIdForKid(String kid) {
        LOG.debug("No JWK, found kid: " + kid);
        String[] kidParts = kid.split("/");
        Long accountId = Long.MAX_VALUE;
        if (kidParts.length > 0) {
            accountId = Long.parseLong(kidParts[kidParts.length - 1]);
        }
        LOG.debug("Looking for accountId: " + accountId);
        return accountId;
    }

    public PublicKey getPublicKey(JsonWebStructure webStruct) {
        try {
            PublicJsonWebKey jwk = webStruct.getHeaders().getPublicJwkHeaderValue(JWK, NO_EXPLICIT_JCA_PROVIDER);
            return jwk.getPublicKey();
        }
        catch (NullPointerException | JoseException npe) {
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "problem reading / parsing JWK", HttpStatus.BAD_REQUEST, "", AcmeUtil.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
    }

    public String getKid(JsonWebStructure webStruct) throws JoseException {
        if (webStruct.getHeader(KID) != null) {
            return webStruct.getHeaders().getStringHeaderValue(KID);
        }
        return null;
    }

    public String getNonce(JsonWebStructure webStruct) throws JoseException {
        if (webStruct.getHeader(NONCE) != null) {
            return webStruct.getHeaders().getStringHeaderValue(NONCE);
        }
        return null;
    }

    public String getJWKThumbPrint(PublicKey newPK) throws JoseException {
        PublicJsonWebKey jwk = PublicJsonWebKey.Factory.newPublicJwk((Key)newPK);
        Base64.Encoder URL_ENCODER = Base64.getUrlEncoder().withoutPadding();
        return URL_ENCODER.encodeToString(jwk.calculateThumbprint("SHA-256"));
    }
}

