/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.security.IPBlockedException;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.local.LocalBucket;
import io.github.bucket4j.local.LocalBucketBuilder;
import java.time.Duration;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimiterService {
    Logger LOG = LoggerFactory.getLogger(RateLimiterService.class);
    int maxEntries = 100;
    private int rateSec = 0;
    private int rateMin = 20;
    private int rateHour = 0;
    LinkedHashMap<Long, Bucket> lruMapOrder;
    private final String endpointName;

    public String getEndpointName() {
        return this.endpointName;
    }

    public RateLimiterService(String endpointName) {
        this.endpointName = endpointName;
        this.lruMapOrder = new /* Unavailable Anonymous Inner Class!! */;
    }

    public RateLimiterService(String endpointName, int rateSec, int rateMin, int rateHour) {
        this(endpointName);
        this.rateSec = rateSec;
        this.rateMin = rateMin;
        this.rateHour = rateHour;
    }

    public void checkSprayingRateLimit(Long clientIP, String clientIPAsString) {
        Bucket bucket = this.getBucket(clientIP.longValue());
        long availableLoginTokens = bucket.getAvailableTokens();
        if (availableLoginTokens <= 0L) {
            throw new IPBlockedException("no token left in login bucket for " + clientIPAsString);
        }
        this.LOG.debug("login per IP rate limitation bucket has {} tokens left", (Object)availableLoginTokens);
    }

    public void consumeSprayingRateLimit(Long clientIP, String clientIPAsString) {
        Bucket bucket = this.getBucket(clientIP.longValue());
        if (!bucket.tryConsume(1L)) {
            throw new IPBlockedException("no token left in login bucket for " + clientIPAsString);
        }
        this.LOG.debug("login per IP rate limitation bucket has {} tokens left", (Object)bucket.getAvailableTokens());
    }

    public Bucket getBucket(long id) {
        if (this.lruMapOrder.containsKey(id)) {
            return (Bucket)this.lruMapOrder.get(id);
        }
        this.LOG.info("creating new bucket for '{}' '{}'", (Object)this.endpointName, (Object)id);
        LocalBucketBuilder bucketBuilder = Bucket.builder();
        if (this.rateSec > 0) {
            bucketBuilder.addLimit(Bandwidth.simple((long)this.rateSec, (Duration)Duration.ofSeconds(1L)));
        }
        if (this.rateMin > 0) {
            bucketBuilder.addLimit(Bandwidth.simple((long)this.rateMin, (Duration)Duration.ofMinutes(1L)));
        }
        if (this.rateHour > 0) {
            bucketBuilder.addLimit(Bandwidth.simple((long)this.rateHour, (Duration)Duration.ofHours(1L)));
        }
        LocalBucket bucket = bucketBuilder.build();
        this.lruMapOrder.put(id, bucket);
        return bucket;
    }
}

