/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.domain.AcmeAccount;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.AcmeOrderRepository;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.dto.acme.RevokeRequest;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.AcmeUtil;
import de.trustable.ca3s.core.service.util.BPMNUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.web.rest.acme.AcmeController;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.asn1.x509.CRLReason;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;

@RestController
@RequestMapping(value={"/acme/{realm}/cert"})
public class AcmeCertificateController
extends AcmeController {
    private static final Logger LOG = LoggerFactory.getLogger(AcmeCertificateController.class);
    private boolean chainIncludeRoot = true;
    private final CertificateRepository certificateRepository;
    private final CSRRepository csrRepository;
    private final CertificateUtil certificateUtil;
    private final AcmeOrderRepository acmeOrderRepository;
    private final BPMNUtil bpmnUtil;
    private final CertificateUtil certUtil;
    private final boolean certificateLocationBackwardCompat;

    public AcmeCertificateController(CertificateRepository certificateRepository, CSRRepository csrRepository, CertificateUtil certificateUtil, AcmeOrderRepository acmeOrderRepository, BPMNUtil bpmnUtil, CertificateUtil certUtil, @Value(value="${ca3s.acme.backward.certificate.location:false}") boolean certificateLocationBackwardCompat) {
        this.certificateRepository = certificateRepository;
        this.csrRepository = csrRepository;
        this.certificateUtil = certificateUtil;
        this.acmeOrderRepository = acmeOrderRepository;
        this.bpmnUtil = bpmnUtil;
        this.certUtil = certUtil;
        this.certificateLocationBackwardCompat = certificateLocationBackwardCompat;
    }

    @RequestMapping(value={"/{certId}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getCertificatePKIX(@PathVariable long certId, @RequestHeader(name="Accept", defaultValue="application/pem-certificate-chain") String accept, @PathVariable String realm, @RequestHeader(value="X-CA3S-Forwarded-Host", required=false) String forwardedHost) {
        LOG.info("Received certificate request for id {}", (Object)certId);
        return this.buildCertResponseForId(certId, accept, realm, forwardedHost);
    }

    public ResponseEntity<?> buildCertResponseForId(long certId, String accept, String realm, String forwardedHost) throws HttpClientErrorException, AcmeProblemException {
        ResponseEntity resp;
        Optional certOpt = this.certificateRepository.findById((Object)certId);
        if (certOpt.isEmpty()) {
            throw new HttpClientErrorException(HttpStatus.NOT_FOUND);
        }
        Certificate certDao = (Certificate)certOpt.get();
        HttpHeaders headers = this.buildNonceHeader();
        if (this.certificateLocationBackwardCompat) {
            String certLocation = this.getEffectiveUriComponentsBuilder(realm, forwardedHost).build().toUriString();
            headers.add("location", certLocation);
            LOG.debug("added certificate location header '{}' for backward compatibility reasons.", (Object)certLocation);
        }
        if ((resp = this.buildCertifcateResponse(accept, certDao, headers)) == null) {
            String msg = "problem returning certificate with accepting type " + accept;
            LOG.info(msg);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, msg, HttpStatus.UNSUPPORTED_MEDIA_TYPE, "", AcmeController.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
        return resp;
    }

    public ResponseEntity<?> buildCertifcateResponse(String accept, Certificate certDao) {
        return this.buildCertifcateResponse(accept, certDao, new HttpHeaders());
    }

    public ResponseEntity<?> buildCertifcateResponse(String accept, Certificate certDao, HttpHeaders headers) {
        if (accept == null || accept.trim().isEmpty()) {
            return this.buildPEMResponse(certDao, headers);
        }
        if (accept.contains("application/pkix-cert")) {
            return this.buildPkixCertResponse(certDao, headers);
        }
        if (accept.contains("application/pem-certificate-chain")) {
            return this.buildPEMResponse(certDao, headers);
        }
        if (accept.contains("application/pem-certificate")) {
            return this.buildPEMResponse(certDao, headers, false);
        }
        if (accept.contains("*/*")) {
            return this.buildPEMResponse(certDao, headers);
        }
        LOG.info("unexpected accept type {}", (Object)accept);
        return null;
    }

    @RequestMapping(value={"/revoke"}, method={RequestMethod.POST}, consumes={"application/jose+json"})
    public ResponseEntity<?> revokeCertificate(@RequestBody String requestBody, @PathVariable String realm) {
        LOG.info("Received revoke request for certificate ");
        try {
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            JsonWebStructure webStruct = this.jwtUtil.getJsonWebStructure(context);
            RevokeRequest revokeReq = this.jwtUtil.getRevokeReq(context.getJwtClaims());
            X509Certificate x509CertPayload = this.certificateUtil.getCertifcateFromBase64(revokeReq.getCertificate());
            LOG.info("Revoke request for certificate {} ", (Object)x509CertPayload.getSubjectX500Principal().toString());
            Certificate certDaoRevoke = this.certificateUtil.getCertificateByX509(x509CertPayload);
            if (certDaoRevoke == null) {
                LOG.warn("Certificate {} to be revoked not found in database", (Object)x509CertPayload.getSubjectX500Principal().toString());
                ProblemDetail problem = new ProblemDetail(AcmeUtil.UNAUTHORIZED, "problem authenticating account / order / certificate for RevokeRequest", HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
                throw new AcmeProblemException(problem);
            }
            String kid = this.jwtUtil.getKid(webStruct);
            if (kid == null) {
                LOG.info("Revocation authentication by JWK");
                Certificate certRequestSignature = null;
                try {
                    PublicKey certificatePubKey = this.jwtUtil.getPublicKey(webStruct);
                    List csrList = this.csrRepository.findByPublicKeyHash(this.cryptoUtil.getHashAsBase64(certificatePubKey.getEncoded()));
                    for (CSR csr : csrList) {
                        if (csr.getCertificate() == null) continue;
                        certRequestSignature = csr.getCertificate();
                        break;
                    }
                    if (certRequestSignature == null) {
                        ProblemDetail problem = new ProblemDetail(AcmeUtil.UNAUTHORIZED, "Certificate used for request signature not found", HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
                        throw new AcmeProblemException(problem);
                    }
                }
                catch (AcmeProblemException acmeProblemException) {
                    LOG.warn("Certificate revocation failed, neither KID nor JWK found in request", (Throwable)acmeProblemException);
                    ProblemDetail problem = new ProblemDetail(AcmeUtil.UNAUTHORIZED, "Certificate revocation failed, neither KID nor JWK found in request", HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
                    throw new AcmeProblemException(problem);
                }
                if (!Objects.equals(certDaoRevoke, certRequestSignature)) {
                    LOG.warn("Private key of certificate to be revoked did not sign the request");
                    ProblemDetail problem = new ProblemDetail(AcmeUtil.UNAUTHORIZED, "Private key of certificate to be revoked did not sign the request", HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
                    throw new AcmeProblemException(problem);
                }
            } else {
                LOG.info("Revocation authentication by KID");
                AcmeAccount acctDao = this.checkJWTSignatureForAccount(context, realm);
                Optional orderOptional = this.acmeOrderRepository.findByCertificate(certDaoRevoke);
                if (orderOptional.isEmpty()) {
                    LOG.warn("No order found for certificate #{} ", (Object)certDaoRevoke.getId());
                    ProblemDetail problem = new ProblemDetail(AcmeUtil.UNAUTHORIZED, "problem authenticating account / order / certificate for RevokeRequest", HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
                    throw new AcmeProblemException(problem);
                }
                AcmeOrder order = (AcmeOrder)orderOptional.get();
                if (!Objects.equals(order.getAccount(), acctDao)) {
                    LOG.warn("Order #{} related to certificate #{} does not belong to account #{}", new Object[]{order.getId(), certDaoRevoke.getId(), acctDao.getId()});
                    ProblemDetail problem = new ProblemDetail(AcmeUtil.UNAUTHORIZED, "problem authenticating account / order / certificate for RevokeRequest", HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
                    throw new AcmeProblemException(problem);
                }
                if (acctDao.getAccountId() != Long.parseLong(this.certUtil.getCertAttribute(certDaoRevoke, "ACME:ACCOUNT_ID"))) {
                    LOG.warn("Revoke request for certificate {} identified by account {} does not match cert's associated account {}", new Object[]{x509CertPayload.getSubjectX500Principal().toString(), acctDao.getAccountId(), this.certUtil.getCertAttribute(certDaoRevoke, "ACME:ACCOUNT_ID")});
                    HttpHeaders headers = this.buildNonceHeader();
                    return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).headers(headers)).build();
                }
            }
            if (certDaoRevoke.isRevoked()) {
                ProblemDetail problem = new ProblemDetail(AcmeUtil.ALREADY_REVOKED, "certificate already revoked", HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
                throw new AcmeProblemException(problem);
            }
            this.revokeCertificate(certDaoRevoke, Integer.toString(revokeReq.getReason()));
            HttpHeaders headers = this.buildNonceHeader();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).build();
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
        catch (Exception e) {
            LOG.info("problem revoking certificate ", (Throwable)e);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "problem revoking certificate ", HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
    }

    private List<Certificate> findCertificatesInDatabase(X509Certificate x509Cert) {
        String tbsDigestBase64;
        try {
            tbsDigestBase64 = Base64.encodeBase64String((byte[])this.cryptoUtil.getSHA256Digest(x509Cert.getTBSCertificate())).toLowerCase();
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            LOG.info("problem selecting certificate for RevokeRequest", (Throwable)e);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "problem retrieving certificate for RevokeRequest", HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
        List certList = this.certificateRepository.findByTBSDigest(tbsDigestBase64);
        return certList;
    }

    @RequestMapping(value={"/{certId}"}, method={RequestMethod.POST}, consumes={"application/jose+json", "application/pkix-cert"})
    public ResponseEntity<?> retrieveCertificate(@RequestBody String requestBody, @RequestHeader(name="Accept", defaultValue="application/pem-certificate-chain") String accept, @RequestHeader(value="Content-Type") String contentType, @PathVariable long certId, @PathVariable String realm, @RequestHeader(value="X-CA3S-Forwarded-Host", required=false) String forwardedHost) {
        try {
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            AcmeAccount acctDao = this.checkJWTSignatureForAccount(context, realm);
            LOG.info("Received certificate request for certifacte id {} of content-type {}, identified by account id {} ", new Object[]{certId, contentType, acctDao.getAccountId()});
            return this.buildCertResponseForId(certId, accept, realm, forwardedHost);
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
    }

    private ResponseEntity<byte[]> buildPkixCertResponse(Certificate certDao, HttpHeaders headers) {
        LOG.info("building PKIX certificate response");
        byte[] certBytes = Base64.decodeBase64((String)certDao.getContent());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(APPLICATION_PKIX_CERT).headers(headers)).body((Object)certBytes);
    }

    private ResponseEntity<?> buildPEMResponse(Certificate certDao, HttpHeaders headers) {
        return this.buildPEMResponse(certDao, headers, true);
    }

    private ResponseEntity<?> buildPEMResponse(Certificate certDao, HttpHeaders headers, boolean includeChain) {
        LOG.info("building PEM certificate response");
        try {
            Object resultPem = "";
            if (includeChain) {
                List chain = this.certUtil.getCertificateChain(certDao);
                Iterator it = chain.iterator();
                while (it.hasNext()) {
                    Certificate chainCertDao = (Certificate)it.next();
                    if (!it.hasNext() && !this.chainIncludeRoot) continue;
                    resultPem = (String)resultPem + chainCertDao.getContent();
                }
            } else {
                resultPem = (String)resultPem + certDao.getContent();
            }
            LOG.debug("returning cert and issuer : \n" + (String)resultPem);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(APPLICATION_PEM_CERT_CHAIN).headers(headers)).body((Object)((String)resultPem).getBytes());
        }
        catch (GeneralSecurityException ge) {
            String msg = "problem building certificate chain";
            LOG.info(msg, (Throwable)ge);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, msg, HttpStatus.INTERNAL_SERVER_ERROR, msg, AcmeController.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
    }

    private void revokeCertificate(Certificate certDao, String reason) throws Exception {
        if (certDao.isRevoked()) {
            LOG.warn("failureReason: certificate with id '" + certDao.getId() + "' already revoked.");
        }
        CRLReason crlReason = this.cryptoUtil.crlReasonFromString(reason);
        String crlReasonStr = this.cryptoUtil.crlReasonAsString(crlReason);
        LOG.debug("crlReason : " + crlReasonStr);
        Date revocationDate = new Date();
        this.bpmnUtil.startCertificateRevocationProcess(certDao, crlReason, revocationDate);
        certDao.setActive(Boolean.valueOf(false));
        certDao.setRevoked(Boolean.valueOf(true));
        certDao.setRevokedSince(Instant.now());
        certDao.setRevocationReason(crlReasonStr);
        certDao.setRevocationExecutionId("39");
        this.certificateRepository.save((Object)certDao);
    }
}

