/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.domain.AcmeAccount;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.enumeration.AccountStatus;
import de.trustable.ca3s.core.repository.AcmeAccountRepository;
import de.trustable.ca3s.core.service.dto.acme.AccountRequest;
import de.trustable.ca3s.core.service.dto.acme.AccountResponse;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.AcmeUtil;
import de.trustable.ca3s.core.service.util.AlgorithmRestrictionUtil;
import de.trustable.ca3s.core.service.util.BPMNUtil;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import de.trustable.ca3s.core.web.rest.acme.AcmeController;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.codec.binary.Base64;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@Transactional(dontRollbackOn={AcmeProblemException.class})
@RestController
@RequestMapping(value={"/acme/{realm}/newAccount"})
public class NewAccountController
extends AcmeController {
    private static final Logger LOG = LoggerFactory.getLogger(NewAccountController.class);
    private final AcmeAccountRepository acctRepository;
    private final BPMNUtil bpmnUtil;
    private final PipelineUtil pipelineUtil;
    private final AlgorithmRestrictionUtil algorithmRestrictionUtil;
    final boolean checkKeyRestrictions;

    public NewAccountController(AcmeAccountRepository acctRepository, BPMNUtil bpmnUtil, PipelineUtil pipelineUtil, AlgorithmRestrictionUtil algorithmRestrictionUtil, @Value(value="${ca3s.acme.account.checkKeyRestrictions:false}") boolean checkKeyRestrictions) {
        this.acctRepository = acctRepository;
        this.bpmnUtil = bpmnUtil;
        this.pipelineUtil = pipelineUtil;
        this.algorithmRestrictionUtil = algorithmRestrictionUtil;
        this.checkKeyRestrictions = checkKeyRestrictions;
    }

    @Transactional
    @RequestMapping(method={RequestMethod.POST}, consumes={"application/jose+json"})
    public ResponseEntity<?> consumingPostedJoseJson(@RequestBody String requestBody, @PathVariable String realm, @RequestHeader(value="X-CA3S-Forwarded-Host", required=false) String forwardedHost) {
        return this.consumeWithConverter(requestBody, realm, forwardedHost);
    }

    @Transactional
    @RequestMapping(method={RequestMethod.POST}, consumes={"application/jws"})
    public ResponseEntity<?> consumingPostedJws(@RequestBody String requestBody, @PathVariable String realm, @RequestHeader(value="X-CA3S-Forwarded-Host", required=false) String forwardedHost) {
        return this.consumeWithConverter(requestBody, realm, forwardedHost);
    }

    ResponseEntity<?> consumeWithConverter(String requestBody, String realm, String forwardedHost) {
        LOG.info("New ACCOUNT requested for realm {} using requestbody \n {}", (Object)realm, (Object)requestBody);
        HttpHeaders additionalHeaders = this.buildNonceHeader();
        try {
            AcmeAccount acctDaoReturn;
            List accListExisting;
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            AccountRequest newAcct = this.jwtUtil.getAccountRequest(context.getJwtClaims());
            LOG.debug("New ACCOUNT reads NewAccountRequest: " + newAcct);
            JsonWebStructure webStruct = this.jwtUtil.getJsonWebStructure(context);
            PublicKey pk = this.jwtUtil.getPublicKey(webStruct);
            if (pk == null) {
                accListExisting = new ArrayList<AcmeAccount>();
                accListExisting.add(this.checkJWTSignatureForAccount(context, realm));
            } else {
                this.jwtUtil.verifyJWT(context, pk);
                LOG.debug("provided public key verifies given JWT: " + pk);
                ArrayList messageList = new ArrayList();
                if (this.checkKeyRestrictions && !this.algorithmRestrictionUtil.isAlgorithmRestrictionsResolved(pk, messageList)) {
                    ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "Public key of new account not accepted.", HttpStatus.BAD_REQUEST, messageList.isEmpty() ? NO_DETAIL : (String)messageList.get(0), NO_INSTANCE);
                    throw new AcmeProblemException(problem);
                }
                LOG.debug("JWK with public key found {}, checking with database", (Object)pk);
                accListExisting = this.acctRepository.findByPublicKeyHashBase64(this.jwtUtil.getJWKThumbPrint(pk));
            }
            if (Boolean.TRUE.equals(newAcct.isOnlyReturnExisting())) {
                if (accListExisting.isEmpty()) {
                    ProblemDetail problem = new ProblemDetail(AcmeUtil.ACCOUNT_DOES_NOT_EXIST, "Account does not exist.", HttpStatus.BAD_REQUEST, NO_DETAIL, NO_INSTANCE);
                    throw new AcmeProblemException(problem);
                }
                acctDaoReturn = (AcmeAccount)accListExisting.get(0);
            } else if (accListExisting.isEmpty()) {
                Pipeline pipeline = this.getPipelineForRealm(realm);
                this.bpmnUtil.startACMEAccountCreationProcess(newAcct, pipeline);
                AcmeAccount newAcctDao = new AcmeAccount();
                newAcctDao.setAccountId(Long.valueOf(this.generateId()));
                newAcctDao.setRealm(realm);
                newAcctDao.setCreatedOn(Instant.now());
                String pkAsString = Base64.encodeBase64String((byte[])pk.getEncoded()).trim();
                newAcctDao.setPublicKey(pkAsString);
                String thumbPrint = this.jwtUtil.getJWKThumbPrint(pk);
                newAcctDao.setPublicKeyHash(thumbPrint);
                if (Boolean.TRUE.equals(newAcct.isTermsAgreed())) {
                    newAcctDao.setTermsOfServiceAgreed(newAcct.isTermsAgreed());
                } else {
                    newAcctDao.setTermsOfServiceAgreed(Boolean.valueOf(false));
                    if (Boolean.TRUE.equals(this.pipelineUtil.getPipelineAttribute(pipeline, "TOS_AGREEMENT_REQUIRED", false))) {
                        URI tosUri = null;
                        try {
                            tosUri = new URI(this.pipelineUtil.getPipelineAttribute(pipeline, "TOS_AGREEMENT_LINK", ""));
                        }
                        catch (URISyntaxException uriSyntaxException) {
                            LOG.warn("ToS agreement link is not a valid URI", (Throwable)uriSyntaxException);
                        }
                        ProblemDetail problem = new ProblemDetail(AcmeUtil.USER_ACTION_REQUIRED, "Agreement to terms of service required", HttpStatus.BAD_REQUEST, NO_DETAIL, tosUri);
                        throw new AcmeProblemException(problem);
                    }
                }
                this.acctRepository.save((Object)newAcctDao);
                this.updateAccountFromRequest(newAcctDao, newAcct, pipeline);
                newAcctDao.setStatus(AccountStatus.VALID);
                this.acctRepository.save((Object)newAcctDao);
                LOG.debug("New Account {} created", (Object)newAcctDao.getAccountId());
                acctDaoReturn = newAcctDao;
            } else {
                acctDaoReturn = (AcmeAccount)accListExisting.get(0);
            }
            URI locationUri = this.locationUriOf(acctDaoReturn.getAccountId().longValue(), this.getEffectiveUriComponentsBuilder(realm, forwardedHost));
            String locationHeader = locationUri.toASCIIString();
            LOG.debug("location header set to " + locationHeader);
            additionalHeaders.set("Location", locationHeader);
            AccountResponse accResp = new AccountResponse(acctDaoReturn, this.getEffectiveUriComponentsBuilder(realm, forwardedHost));
            accResp.setOrders(this.locationUriOfOrders(acctDaoReturn.getAccountId().longValue(), this.getEffectiveUriComponentsBuilder(realm, forwardedHost)).toString());
            if (accListExisting.isEmpty()) {
                LOG.debug("returning new account response " + this.jwtUtil.getAccountResponseAsJSON(accResp));
                LOG.debug("created for locationUri '{}' ", (Object)locationUri);
                return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)locationUri).headers(additionalHeaders)).body((Object)accResp);
            }
            LOG.debug("returning existing account response " + this.jwtUtil.getAccountResponseAsJSON(accResp));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)accResp);
        }
        catch (GeneralSecurityException e) {
            ProblemDetail problem = new ProblemDetail(AcmeUtil.UNAUTHORIZED, "Account creation problem.", HttpStatus.BAD_REQUEST, e.getMessage(), NO_INSTANCE);
            return this.buildProblemResponseEntity(new AcmeProblemException(problem));
        }
        catch (JoseException e) {
            ProblemDetail problem = new ProblemDetail(AcmeUtil.SERVER_INTERNAL, "Algorithm mismatch.", HttpStatus.BAD_REQUEST, NO_DETAIL, NO_INSTANCE);
            return this.buildProblemResponseEntity(new AcmeProblemException(problem));
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
    }

    private URI locationUriOf(long accountId, UriComponentsBuilder uriBuilder) {
        return this.accountResourceUriBuilderFrom(uriBuilder.path("..")).path("/").path(Long.toString(accountId)).build().normalize().toUri();
    }

    private URI locationUriOfOrders(long accountId, UriComponentsBuilder uriBuilder) {
        return this.accountResourceUriBuilderFrom(uriBuilder.path("..")).path("/").path(Long.toString(accountId)).path("/orders").build().normalize().toUri();
    }
}

