/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto.ejbca;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

public class RevokeStatusRestResponse {
    @JsonProperty(value="issuer_dn")
    private String issuerDn = null;
    @JsonProperty(value="serial_number")
    private String serialNumber = null;
    @JsonProperty(value="revocation_reason")
    private String revocationReason = null;
    @JsonProperty(value="revocation_date")
    private OffsetDateTime revocationDate = null;
    @JsonProperty(value="invalidity_date")
    private OffsetDateTime invalidityDate = null;
    @JsonProperty(value="message")
    private String message = null;
    @JsonProperty(value="revoked")
    private Boolean revoked = null;

    public RevokeStatusRestResponse issuerDn(String issuerDn) {
        this.issuerDn = issuerDn;
        return this;
    }

    @Schema(example="CN=ExampleCA", description="Issuer Distinguished Name")
    public String getIssuerDn() {
        return this.issuerDn;
    }

    public void setIssuerDn(String issuerDn) {
        this.issuerDn = issuerDn;
    }

    public RevokeStatusRestResponse serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    @Schema(example="1234567890ABCDEF", description="Hex Serial Number")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public RevokeStatusRestResponse revocationReason(String revocationReason) {
        this.revocationReason = revocationReason;
        return this;
    }

    @Schema(example="KEY_COMPROMISE", description="RFC5280 revokation reason")
    public String getRevocationReason() {
        return this.revocationReason;
    }

    public void setRevocationReason(String revocationReason) {
        this.revocationReason = revocationReason;
    }

    public RevokeStatusRestResponse revocationDate(OffsetDateTime revocationDate) {
        this.revocationDate = revocationDate;
        return this;
    }

    @Schema(example="1970-01-01T00:00Z", description="Revokation date")
    public OffsetDateTime getRevocationDate() {
        return this.revocationDate;
    }

    public void setRevocationDate(OffsetDateTime revocationDate) {
        this.revocationDate = revocationDate;
    }

    public RevokeStatusRestResponse invalidityDate(OffsetDateTime invalidityDate) {
        this.invalidityDate = invalidityDate;
        return this;
    }

    @Schema(example="1970-01-01T00:00Z", description="Invalidity date")
    public OffsetDateTime getInvalidityDate() {
        return this.invalidityDate;
    }

    public void setInvalidityDate(OffsetDateTime invalidityDate) {
        this.invalidityDate = invalidityDate;
    }

    public RevokeStatusRestResponse message(String message) {
        this.message = message;
        return this;
    }

    @Schema(example="Successfully revoked", description="Message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public RevokeStatusRestResponse revoked(Boolean revoked) {
        this.revoked = revoked;
        return this;
    }

    @Schema(description="")
    public Boolean isRevoked() {
        return this.revoked;
    }

    public void setRevoked(Boolean revoked) {
        this.revoked = revoked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevokeStatusRestResponse revokeStatusRestResponse = (RevokeStatusRestResponse)o;
        return Objects.equals(this.issuerDn, revokeStatusRestResponse.issuerDn) && Objects.equals(this.serialNumber, revokeStatusRestResponse.serialNumber) && Objects.equals(this.revocationReason, revokeStatusRestResponse.revocationReason) && Objects.equals(this.revocationDate, revokeStatusRestResponse.revocationDate) && Objects.equals(this.invalidityDate, revokeStatusRestResponse.invalidityDate) && Objects.equals(this.message, revokeStatusRestResponse.message) && Objects.equals(this.revoked, revokeStatusRestResponse.revoked);
    }

    public int hashCode() {
        return Objects.hash(this.issuerDn, this.serialNumber, this.revocationReason, this.revocationDate, this.invalidityDate, this.message, this.revoked);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RevokeStatusRestResponse {\n");
        sb.append("    issuerDn: ").append(this.toIndentedString((Object)this.issuerDn)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString((Object)this.serialNumber)).append("\n");
        sb.append("    revocationReason: ").append(this.toIndentedString((Object)this.revocationReason)).append("\n");
        sb.append("    revocationDate: ").append(this.toIndentedString((Object)this.revocationDate)).append("\n");
        sb.append("    invalidityDate: ").append(this.toIndentedString((Object)this.invalidityDate)).append("\n");
        sb.append("    message: ").append(this.toIndentedString((Object)this.message)).append("\n");
        sb.append("    revoked: ").append(this.toIndentedString((Object)this.revoked)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

