/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.Authority;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.exception.UserNotAuthenticatedException;
import de.trustable.ca3s.core.exception.UserNotFoundException;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.security.IPBlockedException;
import de.trustable.ca3s.core.security.jwt.TokenProvider;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.dto.CSRView;
import de.trustable.ca3s.core.service.dto.CertificateView;
import de.trustable.ca3s.core.service.dto.UserLoginData;
import de.trustable.ca3s.core.service.exception.BlockedCredentialsException;
import de.trustable.ca3s.core.service.util.RateLimiterService;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.validator.internal.constraintvalidators.hv.EmailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class UserUtil {
    private final Logger LOG = LoggerFactory.getLogger(UserUtil.class);
    private final TokenProvider tokenProvider;
    private final AuthenticationManagerBuilder authenticationManagerBuilder;
    private final UserRepository userRepository;
    private final AuditService auditService;
    private final boolean loginByEmailAddress;
    private final RateLimiterService rateLimiterService;
    private final HttpServletRequest request;

    public UserUtil(TokenProvider tokenProvider, AuthenticationManagerBuilder authenticationManagerBuilder, UserRepository userRepository, AuditService auditService, @Value(value="${ca3s.ui.login.allowEmailAddress:false}") boolean loginByEmailAddress, @Value(value="${ca3s.ui.login.ratelimit.second:0}") int rateSec, @Value(value="${ca3s.ui.login.ratelimit.minute:20}") int rateMin, @Value(value="${ca3s.ui.login.ratelimit.hour:0}") int rateHour, HttpServletRequest request) {
        this.tokenProvider = tokenProvider;
        this.authenticationManagerBuilder = authenticationManagerBuilder;
        this.userRepository = userRepository;
        this.auditService = auditService;
        this.loginByEmailAddress = loginByEmailAddress;
        this.rateLimiterService = new RateLimiterService("Login", rateSec, rateMin, rateHour);
        this.request = request;
    }

    public User getCurrentUser() {
        this.LOG.debug("getCurrentUser of a web session");
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            String msg = "auth == null!";
            this.LOG.warn(msg);
            throw new UserNotFoundException(msg);
        }
        String userName = auth.getName();
        if (userName == null) {
            String msg = "Current user == null!";
            this.LOG.warn(msg);
            throw new UserNotFoundException(msg);
        }
        Optional optCurrentUser = this.userRepository.findOneByLogin(userName);
        if (!optCurrentUser.isPresent()) {
            String msg = "Name '" + userName + "' not found as user";
            this.LOG.warn(msg);
            throw new UserNotFoundException(msg);
        }
        return (User)optCurrentUser.get();
    }

    public boolean isAdministrativeUser() {
        return UserUtil.isAdministrativeUser((User)this.getCurrentUser());
    }

    public static boolean isAdministrativeUser(User user) {
        for (Authority authority : user.getAuthorities()) {
            String authorityName = authority.getName();
            if (!authorityName.equals("ROLE_ADMIN") && !authorityName.equals("ROLE_RA") && !authorityName.equals("ROLE_RA_DOMAIN")) continue;
            return true;
        }
        return false;
    }

    public void addUserDetails(CertificateView certificateView) {
        Optional optionalUser;
        if (this.isAdministrativeUser() && (optionalUser = this.userRepository.findOneByLogin(certificateView.getRequestedBy())).isPresent()) {
            User user = (User)optionalUser.get();
            certificateView.setFirstName(user.getFirstName());
            certificateView.setLastName(user.getLastName());
            certificateView.setEmail(user.getEmail());
        }
    }

    public void addUserDetails(CSRView csrView) {
        Optional optionalUser;
        if (this.isAdministrativeUser() && (optionalUser = this.userRepository.findOneByLogin(csrView.getRequestedBy())).isPresent()) {
            User user = (User)optionalUser.get();
            csrView.setFirstName(user.getFirstName());
            csrView.setLastName(user.getLastName());
            csrView.setEmail(user.getEmail());
        }
    }

    public User getUserByLogin(String login) {
        Optional optionalUser;
        String currentLogin = login;
        if (this.loginByEmailAddress && new EmailValidator().isValid((CharSequence)currentLogin, null)) {
            optionalUser = this.userRepository.findOneWithAuthoritiesByEmailIgnoreCase(login);
        } else {
            currentLogin = login.toLowerCase(Locale.ENGLISH);
            optionalUser = this.userRepository.findOneWithAuthoritiesByLogin(currentLogin);
        }
        if (optionalUser.isEmpty()) {
            throw new UserNotAuthenticatedException("User " + currentLogin + " not authenticated");
        }
        return (User)optionalUser.get();
    }

    public String validateCredentials(UserLoginData userLoginData) {
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)userLoginData.getLogin(), (Object)userLoginData.getPassword());
        Authentication authentication = ((AuthenticationManager)this.authenticationManagerBuilder.getObject()).authenticate((Authentication)authenticationToken);
        this.handleSuccesfulAuthentication(userLoginData.getLogin());
        SecurityContextHolder.getContext().setAuthentication(authentication);
        return this.tokenProvider.createToken(authentication, userLoginData.isRememberMe());
    }

    public void checkIPBlocked(String username) {
        String clientIP = this.getClientIP();
        try {
            this.rateLimiterService.checkSprayingRateLimit(this.getClientIPAsLong(clientIP), clientIP);
        }
        catch (IPBlockedException ipBlockedException) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceLoginForIPBlocked(username, clientIP));
            throw ipBlockedException;
        }
    }

    public void handleSuccesfulAuthentication(String username) {
        String clientIP = this.getClientIP();
        User user = this.getUserByLogin(username);
        user.setFailedLogins(Long.valueOf(0L));
        user.setLastloginDate(Instant.now());
        user.setBlockedUntilDate(null);
        this.userRepository.save((Object)user);
        this.auditService.saveAuditTrace(this.auditService.createAuditTraceLoginSucceeded(null, clientIP));
    }

    public void handleBadCredentials(String username) {
        String clientIP = this.getClientIP();
        try {
            this.rateLimiterService.consumeSprayingRateLimit(this.getClientIPAsLong(clientIP), clientIP);
        }
        catch (IPBlockedException ipBlockedException) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceLoginForIPBlocked(username, clientIP));
            throw ipBlockedException;
        }
        User user = this.getUserByLogin(username);
        Long failedLogins = user.getFailedLogins() + 1L;
        int blockedForSec = 600;
        this.LOG.warn("User {} failed login count incremented to {}.", (Object)user.getLogin(), (Object)failedLogins);
        user.setFailedLogins(failedLogins);
        if (failedLogins > 5L) {
            Instant blockedUntilDate = Instant.now().plus((long)blockedForSec, ChronoUnit.SECONDS);
            user.setBlockedUntilDate(blockedUntilDate);
            String msg = "User '" + user.getLogin() + "' blocked";
            this.LOG.info(msg);
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceLoginFailed(username, clientIP));
            throw new BlockedCredentialsException(msg, blockedUntilDate);
        }
        this.auditService.saveAuditTrace(this.auditService.createAuditTraceLoginBlocked(username, clientIP, blockedForSec));
        this.userRepository.save((Object)user);
    }

    private String getClientIP() {
        String xfHeader = this.request.getHeader("X-Forwarded-For");
        String addressString = xfHeader == null || xfHeader.isEmpty() || !xfHeader.contains(this.request.getRemoteAddr()) ? this.request.getRemoteAddr() : xfHeader.split(",")[0];
        return addressString;
    }

    private Long getClientIPAsLong(String addressString) {
        try {
            return new BigInteger(InetAddress.getByName(addressString).getAddress()).longValue();
        }
        catch (UnknownHostException e) {
            return 0L;
        }
    }
}

