/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.Tenant;
import de.trustable.ca3s.core.repository.TenantRepository;
import de.trustable.ca3s.core.service.TenantService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class TenantResource {
    private final Logger log = LoggerFactory.getLogger(TenantResource.class);
    private static final String ENTITY_NAME = "tenant";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final TenantService tenantService;
    private final TenantRepository tenantRepository;

    public TenantResource(TenantService tenantService, TenantRepository tenantRepository) {
        this.tenantService = tenantService;
        this.tenantRepository = tenantRepository;
    }

    @PostMapping(value={"/tenants"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<Tenant> createTenant(@Valid @RequestBody Tenant tenant) throws URISyntaxException {
        this.log.debug("REST request to save Tenant : {}", (Object)tenant);
        if (tenant.getId() != null) {
            throw new BadRequestAlertException("A new tenant cannot already have an ID", ENTITY_NAME, "idexists");
        }
        Tenant result = this.tenantService.save(tenant);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/tenants/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/tenants/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<Tenant> updateTenant(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody Tenant tenant) throws URISyntaxException {
        this.log.debug("REST request to update Tenant : {}, {}", (Object)id, (Object)tenant);
        if (tenant.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, tenant.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.tenantRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        Tenant result = this.tenantService.update(tenant);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)tenant.getId().toString()))).body((Object)result);
    }

    @PatchMapping(value={"/tenants/{id}"}, consumes={"application/json", "application/merge-patch+json"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<Tenant> partialUpdateTenant(@PathVariable(value="id", required=false) Long id, @NotNull @RequestBody Tenant tenant) throws URISyntaxException {
        this.log.debug("REST request to partial update Tenant partially : {}, {}", (Object)id, (Object)tenant);
        if (tenant.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, tenant.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.tenantRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        Optional result = this.tenantService.partialUpdate(tenant);
        return ResponseUtil.wrapOrNotFound((Optional)result, (HttpHeaders)HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)tenant.getId().toString()));
    }

    @GetMapping(value={"/tenants"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public List<Tenant> getAllTenants() {
        this.log.debug("REST request to get all Tenants");
        return this.tenantService.findAll();
    }

    @GetMapping(value={"/tenants/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<Tenant> getTenant(@PathVariable Long id) {
        this.log.debug("REST request to get Tenant : {}", (Object)id);
        Optional tenant = this.tenantService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)tenant);
    }

    @DeleteMapping(value={"/tenants/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<Void> deleteTenant(@PathVariable Long id) {
        this.log.debug("REST request to delete Tenant : {}", (Object)id);
        this.tenantService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

