/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.schedule.CertExpiryScheduler;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ScheduleSupport {
    private final Logger LOG = LoggerFactory.getLogger(ScheduleSupport.class);
    private final CertExpiryScheduler certExpiryScheduler;

    public ScheduleSupport(CertExpiryScheduler certExpiryScheduler) {
        this.certExpiryScheduler = certExpiryScheduler;
    }

    @Transactional
    @PostMapping(value={"schedule/retrieveCertificates"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public int retrieveCertificates() {
        long startTime = System.currentTimeMillis();
        this.certExpiryScheduler.retrieveCertificates();
        this.LOG.debug("calling certExpiryScheduler.retrieveCertificates() took {} ms", (Object)(System.currentTimeMillis() - startTime));
        return 0;
    }

    @Transactional
    @PostMapping(value={"schedule/updateRevocationStatus"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public int updateRevocationStatus() {
        long startTime = System.currentTimeMillis();
        this.certExpiryScheduler.updateRevocationStatus();
        this.LOG.debug("calling certExpiryScheduler.updateRevocationStatus() took {} ms", (Object)(System.currentTimeMillis() - startTime));
        return 0;
    }
}

