/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.repository;

import de.trustable.ca3s.core.domain.CRLExpirationNotification;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.repository.AuditTraceRepository;
import de.trustable.ca3s.core.repository.CRLExpirationNotificationRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.CertificateSpecifications;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.service.dto.CertificateView;
import de.trustable.ca3s.core.service.util.CertificateSelectionUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class CertificateViewRepository {
    private final Logger LOG = LoggerFactory.getLogger(CertificateViewRepository.class);
    private final EntityManager entityManager;
    private final CertificateSelectionUtil certificateSelectionAttributeList;
    private final CertificateRepository certificateRepository;
    private final CRLExpirationNotificationRepository crlExpirationNotificationRepository;
    private final UserRepository userRepository;
    private final AuditTraceRepository auditTraceRepository;
    private final CertificateUtil certificateUtil;
    private final String certificateStoreIsolation;

    public CertificateViewRepository(EntityManager entityManager, CertificateSelectionUtil certificateSelectionAttributeList, CertificateRepository certificateRepository, CRLExpirationNotificationRepository crlExpirationNotificationRepository, UserRepository userRepository, AuditTraceRepository auditTraceRepository, CertificateUtil certificateUtil, @Value(value="${ca3s.ui.certificate-store.isolation:none}") String certificateStoreIsolation) {
        this.entityManager = entityManager;
        this.certificateSelectionAttributeList = certificateSelectionAttributeList;
        this.certificateRepository = certificateRepository;
        this.crlExpirationNotificationRepository = crlExpirationNotificationRepository;
        this.userRepository = userRepository;
        this.auditTraceRepository = auditTraceRepository;
        this.certificateUtil = certificateUtil;
        this.certificateStoreIsolation = certificateStoreIsolation;
    }

    public Page<CertificateView> findSelection(Map<String, String[]> parameterMap) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String userName = auth.getName();
        if (userName == null) {
            this.LOG.warn("Current user == null!");
            throw new UsernameNotFoundException("Current user == null!");
        }
        Optional optCurrentUser = this.userRepository.findOneByLogin(userName);
        if (!optCurrentUser.isPresent()) {
            this.LOG.warn("Name of ra officer '{}' not found as user", (Object)userName);
            throw new UsernameNotFoundException("Current user == null!");
        }
        return CertificateSpecifications.handleQueryParamsCertificateView((EntityManager)this.entityManager, (CriteriaBuilder)cb, parameterMap, (List)this.certificateSelectionAttributeList.getCertificateSelectionAttributes(), (CertificateRepository)this.certificateRepository, (User)((User)optCurrentUser.get()), (String)this.certificateStoreIsolation);
    }

    public Optional<CertificateView> findbyCertificateId(Long certificateId) {
        Optional optCert = this.certificateRepository.findById((Object)certificateId);
        if (optCert.isPresent()) {
            Certificate cert = (Certificate)optCert.get();
            CertificateView certificateView = new CertificateView(cert);
            if (!cert.isEndEntity()) {
                certificateView.setIssuingActiveCertificates(Boolean.valueOf(this.certificateUtil.hasIssuedActiveCertificates(cert)));
            }
            certificateView.setAuditPresent(Boolean.valueOf(!this.auditTraceRepository.findByCsrAndCert(cert, cert.getCsr()).isEmpty()));
            List crlExpirationNotificationList = this.crlExpirationNotificationRepository.findByCrlUrl(certificateView.getCrlUrl());
            if (!crlExpirationNotificationList.isEmpty()) {
                certificateView.setCrlExpirationNotificationId(((CRLExpirationNotification)crlExpirationNotificationList.get(0)).getId());
            }
            return Optional.of(certificateView);
        }
        return Optional.empty();
    }
}

