/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.NotificationService;
import de.trustable.ca3s.core.service.dto.CRLUpdateInfo;
import de.trustable.ca3s.core.service.util.CRLUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.PreferenceUtil;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class CertExpiryScheduler {
    transient Logger LOG = LoggerFactory.getLogger(CertExpiryScheduler.class);
    private final int maxRecordsPerTransaction;
    private final CertificateRepository certificateRepo;
    private final CertificateUtil certUtil;
    private final CRLUtil crlUtil;
    private final PreferenceUtil preferenceUtil;
    private final NotificationService notificationService;

    public CertExpiryScheduler(@Value(value="${ca3s.batch.maxRecordsPerTransaction:1000}") int maxRecordsPerTransaction, CertificateRepository certificateRepo, CertificateUtil certUtil, AuditService auditService, CRLUtil crlUtil, PreferenceUtil preferenceUtil, NotificationService notificationService) {
        this.maxRecordsPerTransaction = maxRecordsPerTransaction;
        this.certificateRepo = certificateRepo;
        this.certUtil = certUtil;
        this.crlUtil = crlUtil;
        this.preferenceUtil = preferenceUtil;
        this.notificationService = notificationService;
    }

    @Scheduled(fixedRateString="${ca3s.schedule.rate.certRetrieval:3600000}")
    public void retrieveCertificates() {
        Instant now = Instant.now();
        List becomingValidList = this.certificateRepo.findInactiveCertificatesByValidFrom(now);
        int count = 0;
        for (Certificate cert : becomingValidList) {
            cert.setActive(Boolean.valueOf(true));
            this.certificateRepo.save((Object)cert);
            this.LOG.info("Certificate {} becoming active passing 'validFrom'", (Object)cert.getId());
            if (count++ <= this.maxRecordsPerTransaction) continue;
            this.LOG.info("limited certificate validity processing to {} per call", (Object)this.maxRecordsPerTransaction);
            break;
        }
        List becomingInvalidList = this.certificateRepo.findActiveCertificatesByValidTo(now);
        count = 0;
        for (Certificate cert : becomingInvalidList) {
            cert.setActive(Boolean.valueOf(false));
            this.certificateRepo.save((Object)cert);
            this.LOG.info("Certificate {} becoming inactive due to expiry", (Object)cert.getId());
            if (count++ <= this.maxRecordsPerTransaction) continue;
            this.LOG.info("limited certificate validity processing to {} per call", (Object)this.maxRecordsPerTransaction);
            break;
        }
    }

    @Scheduled(fixedRateString="${ca3s.schedule.rate.revocationCheck:3600000}")
    public void updateRevocationStatus() {
        if (!this.preferenceUtil.isCheckCrl()) {
            this.LOG.info("Check of CRL status disabled");
            return;
        }
        long excessiveNextUpdate = System.currentTimeMillis() + 2000L * this.preferenceUtil.getMaxNextUpdatePeriodCRLSec();
        long startTime = System.currentTimeMillis();
        HashSet brokenCrlUrlList = new HashSet();
        List certWithURLList = this.certificateRepo.findActiveCertificateOrderedByCrlURL();
        this.LOG.debug("findActiveCertificateOrderedByCrlURL returns #{} certificates in {} ms", (Object)certWithURLList.size(), (Object)(System.currentTimeMillis() - startTime));
        int count = 0;
        for (Object[] resultArr : certWithURLList) {
            block11: {
                Certificate cert = (Certificate)resultArr[0];
                this.LOG.debug("Checking certificate {} for CRL status, URL '{}'", (Object)cert.getId(), resultArr[1]);
                String nextUpdate = this.certUtil.getCertAttribute(cert, "CRL_NEXT_UPDATE");
                if (nextUpdate != null) {
                    try {
                        long nextUpdateMilliSec = Long.parseLong(nextUpdate);
                        if (nextUpdateMilliSec > excessiveNextUpdate) {
                            this.LOG.info("Excessively long CRL validity period for certificate {} ({} sec left), enforcing check.", (Object)cert.getId(), (Object)((nextUpdateMilliSec - startTime) / 1000L));
                        } else if (startTime < nextUpdateMilliSec) {
                            this.LOG.debug("No CRL check for certificate {}, {} sec left ...", (Object)cert.getId(), (Object)((nextUpdateMilliSec - startTime) / 1000L));
                            continue;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        this.LOG.warn("unexpected value for 'next update' in ATTRIBUTE_CRL_NEXT_UPDATE: {} in cert {}", (Object)nextUpdate, (Object)cert.getId());
                    }
                }
                try {
                    CRLUpdateInfo crlInfo = this.certUtil.checkAllCRLsForCertificate(cert, CertificateUtil.convertPemToCertificate((String)cert.getContent()), this.crlUtil, brokenCrlUrlList);
                    if (crlInfo.isbCRLDownloadSuccess()) break block11;
                    this.LOG.info("Downloading all CRL #{} for certificate {} failed", (Object)crlInfo.getCrlUrlCount(), (Object)cert.getId());
                }
                catch (GeneralSecurityException gse) {
                    this.LOG.debug("problem converting certificate id '" + cert.getId() + "' to X509", (Throwable)gse);
                    continue;
                }
            }
            if (count++ <= this.maxRecordsPerTransaction) continue;
            this.LOG.info("limited certificate revocation check to {} per call", (Object)this.maxRecordsPerTransaction);
            break;
        }
        if (!brokenCrlUrlList.isEmpty()) {
            this.LOG.info("#{} CRL URLs marked as inaccessible / broken", (Object)brokenCrlUrlList.size());
        }
        this.LOG.info("#{} certificate revocation checks in {} mSec", (Object)count, (Object)(System.currentTimeMillis() - startTime));
    }

    @Scheduled(cron="${ca3s.schedule.cron.expiryNotificationCron:0 15 2 * * ?}")
    public int notifyRAOfficerHolderOnExpiry() {
        try {
            this.notificationService.notifyRAOfficerHolderOnExpiry();
        }
        catch (MessagingException e) {
            this.LOG.info("Problem sending ra officer notification email", (Throwable)e);
        }
        this.notificationService.notifyRequestorOnExpiry(null, true);
        return 0;
    }
}

