/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.util.CSRUtil;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ProtectedContentCleanupScheduler {
    transient Logger LOG = LoggerFactory.getLogger(ProtectedContentCleanupScheduler.class);
    private final ProtectedContentRepository protectedContentRepository;
    private final CSRRepository csrRepository;
    private final CSRUtil csrUtil;
    private final AuditService auditService;

    public ProtectedContentCleanupScheduler(ProtectedContentRepository protectedContentRepository, CSRRepository csrRepository, CSRUtil csrUtil, AuditService auditService) {
        this.protectedContentRepository = protectedContentRepository;
        this.csrRepository = csrRepository;
        this.csrUtil = csrUtil;
        this.auditService = auditService;
    }

    @Scheduled(fixedRateString="${ca3s.schedule.rate.protectedContentCleanup:600000}")
    public void runMinute() {
        Instant now = Instant.now();
        List invalidList = this.protectedContentRepository.findByValidToPassed(now);
        for (ProtectedContent pc : invalidList) {
            CSR csr;
            Optional optCsr;
            if (!ContentRelationType.CSR.equals((Object)pc.getRelationType()) || !(optCsr = this.csrRepository.findById((Object)pc.getRelatedId())).isPresent() || !CsrStatus.PENDING.equals((Object)(csr = (CSR)optCsr.get()).getStatus())) continue;
            this.csrUtil.setStatusAndRejectionReason(csr, CsrStatus.REJECTED, "created key for csr expired");
            this.auditService.createAuditTraceCsrRejected(csr, "created key for csr expired");
        }
        List expiredList = this.protectedContentRepository.findByDeleteAfterPassed(now);
        if (!expiredList.isEmpty()) {
            this.LOG.info("deleting #{} expired ProtectedContent objects", (Object)expiredList.size());
            for (ProtectedContent pc : invalidList) {
                this.LOG.debug("delete protected content due to passed deletion date: {}", (Object)pc);
            }
            this.protectedContentRepository.deleteAll((Iterable)expiredList);
        }
    }
}

