/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.security.saml;

import de.trustable.ca3s.core.security.jwt.TokenProvider;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;

public class CustomUrlAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    public static final String CA3S_JWT_COOKIE_NAME = "ca3sJWT";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final TokenProvider tokenProvider;
    private RequestCache requestCache = new HttpSessionRequestCache();

    public CustomUrlAuthenticationSuccessHandler(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        String jwt = this.tokenProvider.createToken(authentication, false);
        String targetUrl = this.determineTargetUrl(request, response, authentication);
        if (response.isCommitted()) {
            this.logger.debug((Object)LogMessage.format((String)"Did not redirect to %s since response already committed.", (Object)targetUrl));
        } else {
            this.logger.debug((Object)LogMessage.format((String)"Redirect to %s .", (Object)targetUrl));
            Cookie authCookie = new Cookie(CA3S_JWT_COOKIE_NAME, jwt);
            authCookie.setMaxAge(60);
            authCookie.setSecure(false);
            authCookie.setHttpOnly(false);
            authCookie.setPath("/");
            response.addCookie(authCookie);
            this.logger.debug((Object)"Setting JWT as cookie ca3sJWT.");
        }
        super.onAuthenticationSuccess(request, response, authentication);
    }
}

