/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto;

import de.trustable.ca3s.core.domain.AuditTrace;
import java.io.Serializable;
import java.time.Instant;

public class AuditView
implements Serializable {
    private Long id;
    private String actorName;
    private String actorRole;
    private String plainContent;
    private String[] contentParts;
    private String contentTemplate;
    private Instant createdOn;

    public AuditView() {
    }

    public AuditView(AuditTrace auditTrace) {
        this.id = auditTrace.getId();
        this.actorName = auditTrace.getActorName();
        this.actorRole = auditTrace.getActorRole();
        this.plainContent = auditTrace.getPlainContent();
        this.contentTemplate = auditTrace.getContentTemplate();
        this.createdOn = auditTrace.getCreatedOn();
        this.contentParts = this.plainContent.split(",");
        for (int i = 0; i < this.contentParts.length; ++i) {
            this.contentParts[i] = this.contentParts[i].replace("%2C", ",").replace("%25", "%");
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getActorName() {
        return this.actorName;
    }

    public String getActorRole() {
        return this.actorRole;
    }

    public String getPlainContent() {
        return this.plainContent;
    }

    public String[] getContentParts() {
        return this.contentParts;
    }

    public String getContentTemplate() {
        return this.contentTemplate;
    }

    public Instant getCreatedOn() {
        return this.createdOn;
    }
}

