/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto;

import java.io.Serializable;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Languages
implements Serializable {
    private final Logger LOG = LoggerFactory.getLogger(Languages.class);
    private static final long serialVersionUID = 296426474864181L;
    private String[] languageArr = new String[]{"en", "de", "pl"};

    public Languages() {
    }

    public Languages(String availableLanguages) {
        ArrayList<String> langList = new ArrayList<String>();
        if (availableLanguages != null) {
            for (String lang : availableLanguages.split(",")) {
                if (lang.isEmpty()) continue;
                langList.add(lang.toLowerCase().trim());
                this.LOG.debug("language added: '{}'", (Object)lang.toLowerCase().trim());
            }
        }
        if (langList.isEmpty()) {
            this.LOG.warn("No languages configured, using 'en'. Please add valid languages in property 'ca3s.ui.languages'!");
            langList.add("en");
        }
        this.languageArr = langList.toArray(new String[0]);
    }

    public String[] getLanguageArr() {
        return this.languageArr;
    }

    public void setLanguageArr(String[] languageArr) {
        this.languageArr = languageArr;
    }

    public String alignLanguage(String language) {
        for (String availLang : this.languageArr) {
            if (!availLang.equalsIgnoreCase(language.trim())) continue;
            return language.trim();
        }
        return this.languageArr[0];
    }
}

