/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto.acme;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.service.dto.acme.NewOrderResponse;
import de.trustable.ca3s.core.service.util.DateUtil;
import java.time.Instant;
import java.util.Date;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public class OrderResponse
extends NewOrderResponse {
    @JsonProperty(value="notBefore")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'hh:mm:ss'Z'")
    private Date notBefore;
    @JsonProperty(value="notAfter")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'hh:mm:ss'Z'")
    private Date notAfter;
    @JsonProperty(value="certificate")
    private String certificate;

    public OrderResponse(AcmeOrder orderDao, Set<String> authUrlSet, String finalizeUrl, String certificateUrl) {
        super(orderDao, authUrlSet, finalizeUrl);
        if (orderDao.getNotBefore() != null) {
            this.setNotBefore(DateUtil.asDate((Instant)orderDao.getNotBefore()));
        }
        if (orderDao.getNotAfter() != null) {
            this.setNotAfter(DateUtil.asDate((Instant)orderDao.getNotAfter()));
        }
        this.setCertificate(certificateUrl);
    }

    public OrderResponse() {
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'hh:mm:ss'Z'")
    public Date getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Date notBefore) {
        if (notBefore != null) {
            this.notBefore = notBefore;
        }
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'hh:mm:ss'Z'")
    public Date getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(Date notAfter) {
        if (notAfter != null) {
            this.notAfter = notAfter;
        }
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }
}

