/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import java.util.HashMap;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BPMNAsyncUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BPMNAsyncUtil.class);
    private final RuntimeService runtimeService;

    public BPMNAsyncUtil(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    @Async
    @Transactional
    public void onChange(String processName, Long certificateId) {
        block3: {
            LOG.info("Async call to onChange( '{}', {})", (Object)processName, (Object)certificateId);
            if (certificateId == null) {
                return;
            }
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("certificateId", certificateId.toString());
            try {
                ProcessInstanceWithVariables processInstance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processName).setVariables(variables)).executeWithVariablesInReturn();
                String processInstanceId = processInstance.getId();
                LOG.info("ProcessInstance: {}", (Object)processInstanceId);
                String string = processInstance.getVariables().get((Object)"status").toString();
            }
            catch (RuntimeException processException) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while calling bpmn process '" + processName + "'", (Throwable)processException);
            }
        }
    }
}

