/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.config.PreferenceDefaults;
import de.trustable.ca3s.core.domain.UserPreference;
import de.trustable.ca3s.core.service.UserPreferenceService;
import de.trustable.ca3s.core.service.dto.Preferences;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PreferenceUtil {
    private static final Logger log = LoggerFactory.getLogger(PreferenceUtil.class);
    public static final Long SYSTEM_PREFERENCE_ID = 1L;
    public static final String LIST_DELIMITER = ",";
    public static final String CHECK_CRL = "CheckCRL";
    public static final String NOTIFY_RA_ON_REQUEST = "NotifyRAOnRequest";
    public static final String MAX_NEXT_UPDATE_PERIOD_CRL_SEC = "MaxNextUpdatePeriodCrlSec";
    public static final String ACME_HTTP01_TIMEOUT_MILLI_SEC = "AcmeHTTP01TimeoutMilliSec";
    public static final String ACME_HTTP01_CALLBACK_PORTS = "AcmeHTTP01CallbackPorts";
    public static final String SERVER_SIDE_KEY_CREATION_ALLOWED = "ServerSideKeyCreationAllowed";
    public static final String SELECTED_HASHES = "SelectedHashes";
    public static final String SELECTED_SIGNING_ALGOS = "SelectedSigningAlgos";
    private final UserPreferenceService userPreferenceService;
    private final PreferenceDefaults preferenceDefaults;

    public PreferenceUtil(UserPreferenceService userPreferenceService, PreferenceDefaults preferenceDefaults) {
        this.userPreferenceService = userPreferenceService;
        this.preferenceDefaults = preferenceDefaults;
    }

    public boolean isCheckCrl() {
        Optional optBoolean = this.userPreferenceService.findPreferenceForUserId(CHECK_CRL, SYSTEM_PREFERENCE_ID);
        return optBoolean.filter(userPreference -> Boolean.parseBoolean(userPreference.getContent())).isPresent();
    }

    public boolean isNotifyRAOnRequest() {
        Optional optBoolean = this.userPreferenceService.findPreferenceForUserId(NOTIFY_RA_ON_REQUEST, SYSTEM_PREFERENCE_ID);
        return optBoolean.filter(userPreference -> Boolean.parseBoolean(userPreference.getContent())).isPresent();
    }

    public long getMaxNextUpdatePeriodCRLSec() {
        Optional optLong = this.userPreferenceService.findPreferenceForUserId(MAX_NEXT_UPDATE_PERIOD_CRL_SEC, SYSTEM_PREFERENCE_ID);
        return optLong.map(userPreference -> Long.parseLong(userPreference.getContent())).orElse(86400L);
    }

    public boolean isServerSideKeyCreationAllowed() {
        Optional optBoolean = this.userPreferenceService.findPreferenceForUserId(SERVER_SIDE_KEY_CREATION_ALLOWED, SYSTEM_PREFERENCE_ID);
        return optBoolean.filter(userPreference -> Boolean.parseBoolean(userPreference.getContent())).isPresent();
    }

    public long getAcmeHTTP01TimeoutMilliSec() {
        Optional optLong = this.userPreferenceService.findPreferenceForUserId(ACME_HTTP01_TIMEOUT_MILLI_SEC, SYSTEM_PREFERENCE_ID);
        return optLong.map(userPreference -> Long.parseLong(userPreference.getContent())).orElse(2000L);
    }

    public String getAcmeHTTP01CallbackPorts() {
        Optional optString = this.userPreferenceService.findPreferenceForUserId(ACME_HTTP01_CALLBACK_PORTS, SYSTEM_PREFERENCE_ID);
        if (optString.isPresent()) {
            return ((UserPreference)optString.get()).getContent();
        }
        return "5544";
    }

    public Preferences getSystemPrefs() {
        return this.getPrefs(SYSTEM_PREFERENCE_ID);
    }

    public Preferences getPrefs(Long userId) {
        Preferences prefs = new Preferences();
        prefs.setAvailableHashes(this.preferenceDefaults.getAvailableHashes());
        prefs.setAvailableSigningAlgos(this.preferenceDefaults.getAvailableSigningAlgos());
        prefs.setSelectedHashes(this.preferenceDefaults.getAvailableHashes());
        prefs.setSelectedSigningAlgos(this.preferenceDefaults.getAvailableSigningAlgos());
        log.debug("REST request to get Preference for user {}", (Object)userId);
        List upList = this.userPreferenceService.findAllForUserId(userId);
        for (UserPreference up : upList) {
            String[] valArr;
            String name = up.getName();
            if (SERVER_SIDE_KEY_CREATION_ALLOWED.equals(name)) {
                prefs.setServerSideKeyCreationAllowed(Boolean.parseBoolean(up.getContent()));
                continue;
            }
            if (ACME_HTTP01_CALLBACK_PORTS.equals(name)) {
                String[] portArr = up.getContent().split(LIST_DELIMITER);
                ArrayList<Integer> portList = new ArrayList<Integer>();
                for (String port : portArr) {
                    if ("0".equals(port)) continue;
                    try {
                        portList.add(Integer.parseInt(port));
                    }
                    catch (NumberFormatException nfe) {
                        log.info("unexpected value for ACME_HTTP01_CALLBACK_PORT '{}'", (Object)port);
                    }
                }
                int[] portIntArr = new int[portList.size()];
                for (int i = 0; i < portList.size(); ++i) {
                    portIntArr[i] = (Integer)portList.get(i);
                }
                prefs.setAcmeHTTP01CallbackPortArr(portIntArr);
                continue;
            }
            if (ACME_HTTP01_TIMEOUT_MILLI_SEC.equals(name)) {
                try {
                    prefs.setAcmeHTTP01TimeoutMilliSec(Long.parseLong(up.getContent()));
                }
                catch (NumberFormatException nfe) {
                    log.warn("unexpected Preference value for ACME_HTTP01_TIMEOUT_MILLI_SEC '{}'", (Object)nfe.getMessage());
                    prefs.setAcmeHTTP01TimeoutMilliSec(2000L);
                }
                continue;
            }
            if (NOTIFY_RA_ON_REQUEST.equals(name)) {
                prefs.setNotifyRAOnRequest(Boolean.parseBoolean(up.getContent()));
                continue;
            }
            if (CHECK_CRL.equals(name)) {
                prefs.setCheckCRL(Boolean.parseBoolean(up.getContent()));
                continue;
            }
            if (MAX_NEXT_UPDATE_PERIOD_CRL_SEC.equals(name)) {
                prefs.setMaxNextUpdatePeriodCRLHour((Long.parseLong(up.getContent()) + 1800L) / 3600L);
                continue;
            }
            if (SELECTED_HASHES.equals(name)) {
                valArr = up.getContent().split(LIST_DELIMITER);
                if (valArr.length == 0) {
                    log.error("Configuration problem: No valid hash algorithm defined");
                    continue;
                }
                if (valArr.length > 10) {
                    log.warn("Configuration problem: Too many hash algorithms ({}) defined", (Object)valArr.length);
                }
                prefs.setSelectedHashes(valArr);
                continue;
            }
            if (!SELECTED_SIGNING_ALGOS.equals(name)) continue;
            valArr = up.getContent().split(LIST_DELIMITER);
            if (valArr.length == 0) {
                log.error("Configuration problem: No valid signing algorithm defined");
                continue;
            }
            if (valArr.length > 32) {
                log.warn("Configuration problem: Too many signing algorithms ({}) defined", (Object)valArr.length);
            }
            prefs.setSelectedSigningAlgos(valArr);
        }
        return prefs;
    }
}

