/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import de.trustable.ca3s.core.service.util.PasswordUtil;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.jasypt.util.text.BasicTextEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProtectedContentUtil {
    private final Logger log = LoggerFactory.getLogger(ProtectedContentUtil.class);
    private final BasicTextEncryptor textEncryptor;
    public static final Instant MAX_INSTANT = Instant.parse("9990-12-30T23:59:59Z");
    private final ProtectedContentRepository protContentRepository;
    private final String salt;
    private final int iterations;
    private final String pbeAlgo;

    public ProtectedContentUtil(ProtectedContentRepository protContentRepository, @Value(value="${protectionSecret:mJvR25yt4NHTIqe5Hz7nUHhQNUuM}") String protectionSecretFallback, @Value(value="${ca3s.protectionSecret:#{null}}") String protectionSecret, @Value(value="${ca3s.connection.salt:ca3sSalt}") String salt, @Value(value="${ca3s.connection.iterations:4567}") int iterations, @Value(value="${ca3s.connection.pbeAlgo:PBKDF2WithHmacSHA256}") String pbeAlgo) {
        this.protContentRepository = protContentRepository;
        this.salt = salt;
        this.iterations = iterations;
        this.pbeAlgo = pbeAlgo;
        PasswordUtil passwordUtil = new PasswordUtil("^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{16,100}$");
        if (!(protectionSecret != null && protectionSecret.trim().length() != 0 || protectionSecretFallback == null || protectionSecretFallback.trim().isEmpty())) {
            if ("mJvR25yt4NHTIqe5Hz7nUHhQNUuM".equals(protectionSecretFallback)) {
                this.log.warn("Please provide a secure value for 'ca3s.protectionSecret'!");
            } else {
                this.log.warn("The configuration parameter 'protectionSecret' is deprecated! Use 'ca3s.protectionSecret'.");
            }
            protectionSecret = protectionSecretFallback;
        }
        if (protectionSecret == null || protectionSecret.trim().length() == 0) {
            this.log.warn("Configuration parameter 'protectionSecret' missing or invalid!!");
            throw new UnsupportedOperationException("Configuration parameter 'protectionSecret' missing or invalid");
        }
        passwordUtil.checkPassword(protectionSecret, "Value of 'ca3s.protectionSecret'");
        if (this.log.isDebugEnabled()) {
            this.log.debug("using protection secret '{}'", (Object)PasswordUtil.maskPassword((String)protectionSecret));
        }
        this.textEncryptor = new BasicTextEncryptor();
        this.textEncryptor.setPassword(protectionSecret);
    }

    public String protectString(String content) {
        return this.textEncryptor.encrypt(content);
    }

    public String unprotectString(String protectedContent) {
        return this.textEncryptor.decrypt(protectedContent);
    }

    public ProtectedContent createProtectedContent(String plainText, ProtectedContentType pct, ContentRelationType crt, long connectionId) {
        return this.createProtectedContent(plainText, pct, crt, connectionId, -1, MAX_INSTANT);
    }

    public ProtectedContent createProtectedContent(String plainText, ProtectedContentType pct, ContentRelationType crt, long connectionId, int leftUsages, Instant validTo) {
        ProtectedContent pc = new ProtectedContent();
        pc.setContentBase64(this.protectString(plainText));
        pc.setType(pct);
        pc.setRelationType(crt);
        pc.setRelatedId(Long.valueOf(connectionId));
        pc.setCreatedOn(Instant.now());
        pc.setLeftUsages(Integer.valueOf(leftUsages));
        pc.setValidTo(validTo);
        pc.setDeleteAfter(validTo.plus(1L, ChronoUnit.DAYS));
        this.protContentRepository.save((Object)pc);
        return pc;
    }

    public List<ProtectedContent> retrieveProtectedContent(ProtectedContentType type, ContentRelationType crt, long id) {
        List pcList = this.protContentRepository.findByTypeRelationId(type, crt, Long.valueOf(id));
        Instant now = Instant.now();
        Predicate<ProtectedContent> usableItem = pc -> (pc.getLeftUsages() == -1 || pc.getLeftUsages() > 0) && pc.getValidTo().isAfter(now);
        return pcList.stream().filter(usableItem).collect(Collectors.toList());
    }

    public byte[] deriveSecret(String secret) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return this.deriveSecret(secret.toCharArray());
    }

    public byte[] deriveSecret(char[] secret) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory skf = SecretKeyFactory.getInstance(this.pbeAlgo);
        PBEKeySpec specSecKey = new PBEKeySpec(secret, this.salt.getBytes(), this.iterations, 256);
        return skf.generateSecret(specSecKey).getEncoded();
    }
}

