/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.vault;

import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.dto.vault.SignRequest;
import de.trustable.ca3s.core.service.dto.vault.SignResponse;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class VaultPKIConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(VaultPKIConnector.class);
    long timeoutMilliSec = 1000L;
    private final CSRUtil csrUtil;
    private final CertificateUtil certUtil;
    private final ProtectedContentUtil protUtil;
    private final CertificateRepository certificateRepository;

    public VaultPKIConnector(CSRUtil csrUtil, CertificateUtil certUtil, ProtectedContentUtil protUtil, CertificateRepository certificateRepository) {
        this.csrUtil = csrUtil;
        this.certUtil = certUtil;
        this.protUtil = protUtil;
        this.certificateRepository = certificateRepository;
    }

    public Certificate signCertificateRequest(CSR csr, CAConnectorConfig caConnConfig) throws GeneralSecurityException {
        LOGGER.debug("csr contains #{} CsrAttributes, #{} RequestAttributes and #{} RDN", new Object[]{csr.getCsrAttributes().size(), csr.getRas().size(), csr.getRdns().size()});
        SimpleClientHttpRequestFactory simpleClientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        simpleClientHttpRequestFactory.setConnectTimeout((int)this.timeoutMilliSec);
        simpleClientHttpRequestFactory.setReadTimeout((int)this.timeoutMilliSec);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)simpleClientHttpRequestFactory);
        SignRequest signRequest = new SignRequest();
        signRequest.setCsr(csr.getCsrBase64());
        signRequest.setCommon_name(this.csrUtil.getCommonName(csr));
        LOGGER.debug("Vault request  {}", (Object)signRequest);
        HttpHeaders responseHeaders = new HttpHeaders();
        String token = this.protUtil.unprotectString(caConnConfig.getSecret().getContentBase64());
        responseHeaders.add("X-Vault-Token", token);
        HttpEntity request = new HttpEntity((Object)signRequest, (MultiValueMap)responseHeaders);
        ResponseEntity responseEntity = restTemplate.postForEntity(caConnConfig.getCaUrl(), (Object)request, SignResponse.class, new Object[0]);
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            LOGGER.info("Vault request returns HTTP status {}", (Object)responseEntity.getStatusCode());
            LOGGER.debug("Vault request returns HTTP response {}", (Object)responseEntity);
            throw new GeneralSecurityException("Vault request returns HTTP status " + responseEntity.getStatusCode());
        }
        SignResponse signResponse = (SignResponse)responseEntity.getBody();
        if (signResponse == null || signResponse.getData() == null || signResponse.getData().getCertificate() == null || signResponse.getData().getCertificate().trim().isEmpty()) {
            throw new GeneralSecurityException("Vault request does not return a certificate");
        }
        String certificate = signResponse.getData().getCertificate();
        Certificate certDao = null;
        try {
            certDao = this.certUtil.createCertificate(certificate, csr, null, false);
        }
        catch (IOException e) {
            LOGGER.debug("Vault request returns \n{}", (Object)certificate);
            throw new GeneralSecurityException("Vault request returns unparseable certificate");
        }
        certDao.setRevocationCA(caConnConfig);
        this.certificateRepository.save((Object)certDao);
        csr.setCertificate(certDao);
        csr.setStatus(CsrStatus.ISSUED);
        return certDao;
    }
}

