/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.exception.PasswordRestrictionMismatch;
import de.trustable.ca3s.core.repository.TenantRepository;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.security.SecurityUtils;
import de.trustable.ca3s.core.service.MailService;
import de.trustable.ca3s.core.service.UserService;
import de.trustable.ca3s.core.service.dto.Languages;
import de.trustable.ca3s.core.service.dto.PasswordChangeDTO;
import de.trustable.ca3s.core.service.dto.UserDTO;
import de.trustable.ca3s.core.web.rest.AccountResource;
import de.trustable.ca3s.core.web.rest.errors.EmailAlreadyUsedException;
import de.trustable.ca3s.core.web.rest.errors.EmailNotFoundException;
import de.trustable.ca3s.core.web.rest.errors.InvalidPasswordException;
import de.trustable.ca3s.core.web.rest.vm.KeyAndPasswordVM;
import de.trustable.ca3s.core.web.rest.vm.ManagedUserVM;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class AccountResource {
    @Value(value="${ca3s.ui.languages:en,de,pl}")
    private String availableLanguages;
    private final Logger log = LoggerFactory.getLogger(AccountResource.class);
    private final UserRepository userRepository;
    private final UserService userService;
    private final TenantRepository tenantRepository;
    private final MailService mailService;

    public AccountResource(UserRepository userRepository, UserService userService, TenantRepository tenantRepository, MailService mailService) {
        this.userRepository = userRepository;
        this.userService = userService;
        this.tenantRepository = tenantRepository;
        this.mailService = mailService;
    }

    @PostMapping(value={"/register"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void registerAccount(@Valid @RequestBody ManagedUserVM managedUserVM) throws MessagingException {
        this.checkPasswordLength(managedUserVM.getPassword());
        User user = this.userService.registerUser((UserDTO)managedUserVM, managedUserVM.getPassword());
        this.mailService.sendActivationEmail(user);
    }

    @GetMapping(value={"/activate"})
    public void activateAccount(@RequestParam(value="key") String key) {
        Optional user = this.userService.activateRegistration(key);
        if (!user.isPresent()) {
            throw new AccountResourceException("No user was found for this activation key");
        }
    }

    @GetMapping(value={"/authenticate"})
    public String isAuthenticated(HttpServletRequest request) {
        this.log.debug("REST request to check if the current user is authenticated");
        return request.getRemoteUser();
    }

    @Transactional
    @GetMapping(value={"/account"})
    public UserDTO getAccount() {
        Optional optUser = this.userService.getUserWithAuthorities();
        if (optUser.isPresent()) {
            Languages languages = new Languages(this.availableLanguages);
            User user = (User)optUser.get();
            if (user.getLangKey() == null) {
                user.setLangKey(languages.getLanguageArr()[0]);
            } else {
                user.setLangKey(languages.alignLanguage(user.getLangKey()));
            }
            UserDTO userDTO = new UserDTO(user, this.tenantRepository);
            return userDTO;
        }
        throw new AccountResourceException("User could not be found");
    }

    @Transactional
    @PostMapping(value={"/account"})
    public void saveAccount(@Valid @RequestBody UserDTO userDTO) {
        String userLogin = (String)SecurityUtils.getCurrentUserLogin().orElseThrow(() -> new AccountResourceException("Current user login not found"));
        Optional existingUser = this.userRepository.findOneByEmailIgnoreCase(userDTO.getEmail());
        if (existingUser.isPresent() && !((User)existingUser.get()).getLogin().equalsIgnoreCase(userLogin)) {
            throw new EmailAlreadyUsedException();
        }
        Optional user = this.userRepository.findOneByLogin(userLogin);
        if (!user.isPresent()) {
            throw new AccountResourceException("User could not be found");
        }
        this.userService.updateUser(userDTO.getFirstName(), userDTO.getLastName(), userDTO.getEmail(), userDTO.getLangKey(), userDTO.getImageUrl(), userDTO.getTenantId());
    }

    @PostMapping(path={"/account/change-password"})
    public void changePassword(@RequestBody PasswordChangeDTO passwordChangeDto) {
        this.checkPasswordLength(passwordChangeDto.getNewPassword());
        this.userService.changePassword(passwordChangeDto.getCurrentPassword(), passwordChangeDto.getNewPassword());
    }

    @PostMapping(path={"/account/reset-password/init"})
    public void requestPasswordReset(@RequestBody String mail) throws MessagingException {
        this.mailService.sendPasswordResetMail((User)this.userService.requestPasswordReset(mail).orElseThrow(EmailNotFoundException::new));
    }

    @PostMapping(path={"/account/reset-password/finish"})
    public void finishPasswordReset(@RequestBody KeyAndPasswordVM keyAndPassword) {
        this.checkPasswordLength(keyAndPassword.getNewPassword());
        Optional user = this.userService.completePasswordReset(keyAndPassword.getNewPassword(), keyAndPassword.getKey());
        if (!user.isPresent()) {
            throw new AccountResourceException("No user was found for this reset key");
        }
    }

    private void checkPasswordLength(String password) {
        try {
            this.userService.checkPassword(password);
        }
        catch (PasswordRestrictionMismatch passwordRestrictionMismatch) {
            throw new InvalidPasswordException();
        }
    }
}

