/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import com.opencsv.bean.ColumnPositionMappingStrategy;
import com.opencsv.bean.StatefulBeanToCsv;
import com.opencsv.bean.StatefulBeanToCsvBuilder;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import de.trustable.ca3s.core.repository.CertificateViewRepository;
import de.trustable.ca3s.core.service.dto.CertificateView;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.PaginationUtil;

@RestController
@RequestMapping(value={"/publicapi"})
public class CertificateListResource {
    public static final MediaType TEXT_CSV_TYPE = new MediaType("text", "csv");
    private final CertificateViewRepository certificateViewRepository;
    private final int maxCSVRows;
    private final Logger log = LoggerFactory.getLogger(CertificateListResource.class);

    public CertificateListResource(CertificateViewRepository certificateViewRepository, @Value(value="${ca3s.ui.download.rows.max:1000}") int maxCSVRows) {
        this.certificateViewRepository = certificateViewRepository;
        this.maxCSVRows = maxCSVRows;
    }

    @GetMapping(value={"/certificateList"})
    public ResponseEntity<List<CertificateView>> getAllCertificates(Pageable pageable, HttpServletRequest request) {
        this.log.debug("REST request to get a page of CertificateViews");
        Page page = this.certificateViewRepository.findSelection(request.getParameterMap());
        List cvList = this.getFullCertificateViews(page);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)cvList);
    }

    @GetMapping(value={"/certificateListCSV"})
    public ResponseEntity<String> getAllCertificatesAsCSV(Pageable pageable, HttpServletRequest request) {
        this.log.debug("REST request to get a page of CertificateViews");
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        for (String key : request.getParameterMap().keySet()) {
            if (Objects.equals(key, "offset") || Objects.equals(key, "limit")) continue;
            paramMap.put(key, (String[])request.getParameterMap().get(key));
        }
        paramMap.put("offset", new String[]{"0"});
        paramMap.put("limit", new String[]{"" + this.maxCSVRows});
        Page page = this.certificateViewRepository.findSelection(paramMap);
        List cvList = this.getFullCertificateViews(page);
        StringWriter writer = new StringWriter();
        ColumnPositionMappingStrategy mappingStrategy = new ColumnPositionMappingStrategy();
        mappingStrategy.setType(CertificateView.class);
        StatefulBeanToCsv beanToCsv = new StatefulBeanToCsvBuilder((Writer)writer).withSeparator(';').withQuotechar('\"').build();
        try {
            beanToCsv.write(cvList);
        }
        catch (CsvDataTypeMismatchException | CsvRequiredFieldEmptyException e) {
            this.log.warn("problem building csv response", e);
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.ok().contentType(TEXT_CSV_TYPE).body((Object)((Object)writer).toString());
    }

    public List<CertificateView> getFullCVList(Map<String, String[]> parameterMap) {
        Page page = this.certificateViewRepository.findSelection(parameterMap);
        return this.getFullCertificateViews(page);
    }

    @NotNull
    private List<CertificateView> getFullCertificateViews(Page<CertificateView> page) {
        ArrayList<CertificateView> cvList = new ArrayList<CertificateView>();
        for (CertificateView cv : page.getContent()) {
            Optional optionalCertificateView = this.certificateViewRepository.findbyCertificateId(cv.getId());
            if (!optionalCertificateView.isPresent()) continue;
            cvList.add((CertificateView)optionalCertificateView.get());
            this.log.debug("returning full certificate view  #{}", (Object)cv.getId());
        }
        return cvList;
    }
}

