/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.Tenant;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.repository.AuditTraceRepository;
import de.trustable.ca3s.core.repository.CertificateViewRepository;
import de.trustable.ca3s.core.service.CertificateService;
import de.trustable.ca3s.core.service.dto.CertificateView;
import de.trustable.ca3s.core.web.rest.util.UserUtil;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;

@RestController
@RequestMapping(value={"/api"})
public class CertificateViewResource {
    private final Logger LOG = LoggerFactory.getLogger(CertificateViewResource.class);
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final CertificateService certificateService;
    private final CertificateViewRepository certificateViewRepository;
    private final UserUtil userUtil;
    private final AuditTraceRepository auditTraceRepository;

    public CertificateViewResource(CertificateService certificateService, CertificateViewRepository certificateViewRepository, UserUtil userUtil, AuditTraceRepository auditTraceRepository) {
        this.certificateService = certificateService;
        this.certificateViewRepository = certificateViewRepository;
        this.userUtil = userUtil;
        this.auditTraceRepository = auditTraceRepository;
    }

    @GetMapping(value={"/certificateViews/{id}"})
    public ResponseEntity<CertificateView> getCertificate(@PathVariable Long id) {
        this.LOG.debug("REST request to get CertificateView : {}", (Object)id);
        Optional optCert = this.certificateViewRepository.findbyCertificateId(id);
        if (optCert.isPresent()) {
            CertificateView certView = (CertificateView)optCert.get();
            this.checkTenant(certView);
            this.userUtil.addUserDetails(certView);
            return new ResponseEntity((Object)certView, HttpStatus.OK);
        }
        return ResponseEntity.notFound().build();
    }

    private void checkTenant(CertificateView certView) {
        User currentUser;
        Tenant tenant;
        if (!this.userUtil.isAdministrativeUser() && (tenant = (currentUser = this.userUtil.getCurrentUser()).getTenant()) != null && tenant.getId() != certView.getTenant\u00ced() && certView.getEndEntity().booleanValue()) {
            this.LOG.info("user [{}] tried to download EE certificate [{}] of tenant [{}]", new Object[]{currentUser.getLogin(), certView.getId(), tenant.getLongname()});
            throw new HttpClientErrorException(HttpStatus.NOT_FOUND);
        }
    }
}

