/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.domain.AcmeAccount;
import de.trustable.ca3s.core.domain.AcmeContact;
import de.trustable.ca3s.core.domain.AcmeNonce;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.enumeration.AccountStatus;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.repository.AcmeAccountRepository;
import de.trustable.ca3s.core.repository.AcmeContactRepository;
import de.trustable.ca3s.core.repository.AcmeNonceRepository;
import de.trustable.ca3s.core.repository.PipelineRepository;
import de.trustable.ca3s.core.service.dto.acme.AccountRequest;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.AcmeUtil;
import de.trustable.ca3s.core.service.util.DateUtil;
import de.trustable.ca3s.core.service.util.JwtUtil;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import de.trustable.ca3s.core.web.rest.acme.AccountController;
import de.trustable.ca3s.core.web.rest.acme.AccountDoesNotExistException;
import de.trustable.ca3s.core.web.rest.acme.AcmeCertificateController;
import de.trustable.ca3s.core.web.rest.acme.AuthorizationController;
import de.trustable.ca3s.core.web.rest.acme.ChallengeController;
import de.trustable.ca3s.core.web.rest.acme.DirectoryController;
import de.trustable.ca3s.core.web.rest.acme.NewAccountController;
import de.trustable.ca3s.core.web.rest.acme.NewNonceController;
import de.trustable.ca3s.core.web.rest.acme.NewOrderController;
import de.trustable.ca3s.core.web.rest.acme.OrderController;
import de.trustable.util.CryptoUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.sql.Date;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import javax.transaction.Transactional;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@Transactional(dontRollbackOn={AcmeProblemException.class})
@RestController
public class AcmeController {
    private static final Logger LOG = LoggerFactory.getLogger(AcmeController.class);
    public static final URI NO_INSTANCE = null;
    public static final String NO_DETAIL = null;
    public static final String APPLICATION_JWS_VALUE = "application/jws";
    public static final String APPLICATION_JOSE_JSON_VALUE = "application/jose+json";
    public static final String APPLICATION_PKIX_CERT_VALUE = "application/pkix-cert";
    public static final String APPLICATION_PEM_CERT_CHAIN_VALUE = "application/pem-certificate-chain";
    public static final String APPLICATION_X_PEM_CERT_CHAIN_VALUE = "application/x-pem-certificate-chain";
    public static final String APPLICATION_PEM_CERT_VALUE = "application/pem-certificate";
    public static final String APPLICATION_PEM_FILE_VALUE = "application/x-pem-file";
    public static final String APPLICATION_PKCS12_VALUE = "application/x-pkcs12";
    public static final MediaType APPLICATION_PROBLEM_JSON = new MediaType("application", "problem+json");
    public static final MediaType APPLICATION_JOSE_JSON = MediaType.parseMediaType((String)"application/jose+json");
    public static final MediaType APPLICATION_JWS = MediaType.parseMediaType((String)"application/jws");
    public static final MediaType APPLICATION_PKIX_CERT = MediaType.parseMediaType((String)"application/pkix-cert");
    public static final MediaType APPLICATION_PEM_CERT_CHAIN = MediaType.parseMediaType((String)"application/pem-certificate-chain");
    public static final MediaType APPLICATION_X_PEM_CERT_CHAIN = MediaType.parseMediaType((String)"application/x-pem-certificate-chain");
    public static final MediaType APPLICATION_PEM_CERT = MediaType.parseMediaType((String)"application/pem-certificate");
    public static final MediaType APPLICATION_PEM_FILE = MediaType.parseMediaType((String)"application/x-pem-file");
    public static final MediaType APPLICATION_PKCS12 = MediaType.parseMediaType((String)"application/x-pkcs12");
    public static int DEFAULT_NONCE_VALID_DAYS = 1;
    public static final String REPLAY_NONCE_HEADER = "Replay-Nonce";
    public static final String HEADER_X_CA3S_FORWARDED_HOST = "X-CA3S-Forwarded-Host";
    public static final String HEADER_X_CA3S_PROXY_ID = "X-CA3S-PROXY-ID";
    public static final String HEADER_X_JWS_SIGNATURE = "X-JWS-Signature";
    static final String GENERAL_URL_PREFIX = "/acme/{realm}";
    String DIRECTORY_RESOURCE_MAPPING = AcmeController.afterPrefix((String)DirectoryController.class.getAnnotation(RequestMapping.class).value()[0]);
    String NEW_AUTHORIZATION_RESOURCE_MAPPING = AcmeController.afterPrefix((String)NewOrderController.class.getAnnotation(RequestMapping.class).value()[0]);
    String AUTHORIZATION_RESOURCE_MAPPING = AcmeController.afterPrefix((String)AuthorizationController.class.getAnnotation(RequestMapping.class).value()[0]);
    String ACCOUNT_RESOURCE_MAPPING = AcmeController.afterPrefix((String)AccountController.class.getAnnotation(RequestMapping.class).value()[0]);
    String NEW_NONCE_RESOURCE_MAPPING = AcmeController.afterPrefix((String)NewNonceController.class.getAnnotation(RequestMapping.class).value()[0]);
    String NEW_ACCOUNT_RESOURCE_MAPPING = AcmeController.afterPrefix((String)NewAccountController.class.getAnnotation(RequestMapping.class).value()[0]);
    String NEW_ORDER_RESOURCE_MAPPING = AcmeController.afterPrefix((String)NewOrderController.class.getAnnotation(RequestMapping.class).value()[0]);
    String ORDER_RESOURCE_MAPPING = AcmeController.afterPrefix((String)OrderController.class.getAnnotation(RequestMapping.class).value()[0]);
    String CHALLENGE_RESOURCE_MAPPING = AcmeController.afterPrefix((String)ChallengeController.class.getAnnotation(RequestMapping.class).value()[0]);
    String CERTIFICATE_RESOURCE_MAPPING = AcmeController.afterPrefix((String)AcmeCertificateController.class.getAnnotation(RequestMapping.class).value()[0]);
    SecureRandom secRandom = new SecureRandom();
    @Autowired
    JwtUtil jwtUtil;
    @Autowired
    CryptoUtil cryptoUtil;
    @Autowired
    AcmeNonceRepository nonceRepository;
    @Autowired
    AcmeAccountRepository acctRepository;
    @Autowired
    AcmeContactRepository contactRepo;
    @Autowired
    PipelineRepository pipeRepo;
    @Autowired
    PipelineUtil pipelineUtil;

    static String afterPrefix(String url) {
        if (url.startsWith(GENERAL_URL_PREFIX)) {
            return url.replace(GENERAL_URL_PREFIX, "");
        }
        return url;
    }

    UriComponentsBuilder getEffectiveUriComponentsBuilder(String realm, String forwardedHost) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentRequestUri();
        if (forwardedHost != null) {
            try {
                URI forwardUri = new URI(forwardedHost);
                builder.scheme(forwardUri.getScheme());
                builder.host(forwardUri.getHost());
                builder.port(forwardUri.getPort());
                LOG.debug("ACME URI updated from proxy to {}://{}:{}", new Object[]{forwardUri.getScheme(), forwardUri.getHost(), forwardUri.getPort()});
            }
            catch (URISyntaxException e) {
                LOG.warn("forwardedHost '" + forwardedHost + "' not valid URI", (Throwable)e);
            }
        }
        return builder;
    }

    public UriComponentsBuilder newAuthorizationResourceUriBuilderFrom(UriComponentsBuilder uriComponentsBuilder) {
        return this.buildUrlFrom(uriComponentsBuilder, this.NEW_AUTHORIZATION_RESOURCE_MAPPING);
    }

    public UriComponentsBuilder authorizationResourceUriBuilderFrom(UriComponentsBuilder uriComponentsBuilder) {
        return this.buildUrlFrom(uriComponentsBuilder, this.AUTHORIZATION_RESOURCE_MAPPING);
    }

    public UriComponentsBuilder certificateResourceUriBuilderFrom(UriComponentsBuilder uriComponentsBuilder) {
        return this.buildUrlFrom(uriComponentsBuilder, this.CERTIFICATE_RESOURCE_MAPPING);
    }

    public UriComponentsBuilder challengeResourceUriBuilderFrom(UriComponentsBuilder uriComponentsBuilder) {
        return this.buildUrlFrom(uriComponentsBuilder, this.CHALLENGE_RESOURCE_MAPPING);
    }

    public UriComponentsBuilder newNonceResourceUriBuilderFrom(UriComponentsBuilder uriComponentsBuilder) {
        return this.buildUrlFrom(uriComponentsBuilder, this.NEW_NONCE_RESOURCE_MAPPING);
    }

    public UriComponentsBuilder newAccountResourceUriBuilderFrom(UriComponentsBuilder uriComponentsBuilder) {
        return this.buildUrlFrom(uriComponentsBuilder, this.NEW_ACCOUNT_RESOURCE_MAPPING);
    }

    public UriComponentsBuilder newOrderResourceUriBuilderFrom(UriComponentsBuilder uriComponentsBuilder) {
        return this.buildUrlFrom(uriComponentsBuilder, this.NEW_ORDER_RESOURCE_MAPPING);
    }

    public UriComponentsBuilder orderResourceUriBuilderFrom(UriComponentsBuilder uriComponentsBuilder) {
        return this.buildUrlFrom(uriComponentsBuilder, this.ORDER_RESOURCE_MAPPING);
    }

    public UriComponentsBuilder accountResourceUriBuilderFrom(UriComponentsBuilder uriComponentsBuilder) {
        return this.buildUrlFrom(uriComponentsBuilder, this.ACCOUNT_RESOURCE_MAPPING);
    }

    public UriComponentsBuilder directoryResourceUriBuilderFrom(UriComponentsBuilder uriComponentsBuilder) {
        return this.buildUrlFrom(uriComponentsBuilder, this.DIRECTORY_RESOURCE_MAPPING);
    }

    public UriComponentsBuilder keyChangeResourceUriBuilderFrom(UriComponentsBuilder uriComponentsBuilder) {
        return this.buildUrlFrom(uriComponentsBuilder, this.ACCOUNT_RESOURCE_MAPPING + "/changeKey");
    }

    public UriComponentsBuilder revokeResourceUriBuilderFrom(UriComponentsBuilder uriComponentsBuilder) {
        return this.buildUrlFrom(uriComponentsBuilder, this.CERTIFICATE_RESOURCE_MAPPING + "/revoke");
    }

    public UriComponentsBuilder buildUrlFrom(UriComponentsBuilder uriComponentsBuilder, String path) {
        return uriComponentsBuilder.path("/..").path(path);
    }

    public URI locationUriOfOrder(long orderId, UriComponentsBuilder uriBuilder) {
        return this.orderResourceUriBuilderFrom(uriBuilder.path("..")).path("/").path(Long.toString(orderId)).build().normalize().toUri();
    }

    public URI locationUriOfOrderFinalize(long orderId, UriComponentsBuilder uriBuilder) {
        return this.orderResourceUriBuilderFrom(uriBuilder.path("..")).path("/finalize/").path(Long.toString(orderId)).build().normalize().toUri();
    }

    public URI locationUriOfCertificate(long certId, UriComponentsBuilder uriBuilder) {
        return this.certificateResourceUriBuilderFrom(uriBuilder).path("/").path(Long.toString(certId)).build().normalize().toUri();
    }

    public URI locationUriOfAuth(long authId, UriComponentsBuilder uriBuilder) {
        return this.authorizationResourceUriBuilderFrom(uriBuilder).path("/").path(Long.toString(authId)).build().normalize().toUri();
    }

    public Pipeline getPipelineForRealm(String realm) {
        List pipelineList = this.pipeRepo.findActiveByTypeUrl(PipelineType.ACME, realm);
        if (pipelineList.isEmpty()) {
            LOG.warn("realm {} is not known", (Object)realm);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.REALM_DOES_NOT_EXIST, "realm not found", HttpStatus.BAD_REQUEST, "", NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
        if (pipelineList.size() > 1) {
            LOG.warn("misconfiguration for realm '{}', multiple configurations handling this realm", (Object)realm);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.SERVER_INTERNAL, "Pipeline configuration broken", HttpStatus.BAD_REQUEST, "", NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
        return (Pipeline)pipelineList.get(0);
    }

    public void contactsFromRequest(AcmeAccount acctDao, AccountRequest updatedAcct) {
        HashSet<AcmeContact> contactSet = acctDao.getContacts();
        if (contactSet == null) {
            contactSet = new HashSet<AcmeContact>();
        }
        contactSet.clear();
        if (updatedAcct.getContacts().isEmpty()) {
            LOG.error("No contact info present");
        } else {
            for (String contactUrl : updatedAcct.getContacts()) {
                if (acctDao.getContacts().stream().anyMatch(c -> c.getContactUrl().trim().equals(contactUrl.trim()))) {
                    LOG.info("contact utl '{}' already known fo account {}", (Object)contactUrl, (Object)acctDao.getId());
                    continue;
                }
                AcmeContact contactDao = new AcmeContact();
                contactDao.setContactId(Long.valueOf(this.generateId()));
                contactDao.setAccount(acctDao);
                contactDao.setContactUrl(contactUrl);
                contactSet.add(contactDao);
                LOG.info("contact info {} stored for account {}", (Object)contactDao.getContactUrl(), (Object)contactDao.getAccount().getAccountId());
            }
            this.contactRepo.saveAll(contactSet);
        }
        acctDao.setContacts(contactSet);
        if (updatedAcct.getExternalAccountBinding() != null) {
            LOG.info("Unsupported ExternalAccountBinding info present");
        }
        if (AccountStatus.DEACTIVATED.equals((Object)updatedAcct.getStatus()) || AccountStatus.REVOKED.equals((Object)updatedAcct.getStatus())) {
            acctDao.setStatus(updatedAcct.getStatus());
        } else if (updatedAcct.getStatus() == null) {
            LOG.debug("No status transition of AccountStatus requested externally");
        } else {
            LOG.info("Unexpected transition of AccountStatus to '{}' requested", (Object)updatedAcct.getStatus());
        }
    }

    AcmeAccount checkJWTSignatureForAccount(JwtContext context, String realm) {
        return this.checkJWTSignatureForAccount(context, realm, null);
    }

    AcmeAccount checkJWTSignatureForAccount(JwtContext context, String realm, Long accountIdReq) {
        try {
            JsonWebStructure webStruct = this.jwtUtil.getJsonWebStructure(context);
            this.checkNonce(webStruct);
            String kid = this.jwtUtil.getKid(webStruct);
            if (kid == null) {
                LOG.error("requested account {} does not match account for kid {}", (Object)accountIdReq, (Object)kid);
                ProblemDetail problem = new ProblemDetail(AcmeUtil.ACCOUNT_DOES_NOT_EXIST, "No kid found in account jwt", HttpStatus.BAD_REQUEST, "", NO_INSTANCE);
                throw new AcmeProblemException(problem);
            }
            Long accountId = this.jwtUtil.getAccountIdForKid(kid);
            if (accountIdReq != null && !accountId.equals(accountIdReq)) {
                LOG.error("requested account {} does not match account for kid {}", (Object)accountIdReq, (Object)kid);
                throw new AccountDoesNotExistException(accountId.longValue());
            }
            List accListExisting = this.acctRepository.findByAccountId(accountId.longValue());
            if (accListExisting.isEmpty()) {
                LOG.error("Missing required key ID");
                throw new AccountDoesNotExistException(accountId.longValue());
            }
            AcmeAccount acctDao = (AcmeAccount)accListExisting.get(0);
            LOG.debug("request signature identifies account id {} ", (Object)acctDao.getAccountId());
            if (realm != null && !realm.equals(acctDao.getRealm())) {
                LOG.warn("Account {} of {} does not match realm {}", new Object[]{acctDao.getAccountId(), acctDao.getRealm(), realm});
                ProblemDetail problem = new ProblemDetail(AcmeUtil.ACCOUNT_DOES_NOT_EXIST, "Account not found", HttpStatus.BAD_REQUEST, "", NO_INSTANCE);
                throw new AcmeProblemException(problem);
            }
            if (!AccountStatus.VALID.equals((Object)acctDao.getStatus())) {
                String title = "Account not activate";
                if (AccountStatus.PENDING.equals((Object)acctDao.getStatus())) {
                    LOG.warn("Account {} activation still pending", (Object)acctDao.getAccountId());
                    title = "Account not activate, yet";
                } else {
                    LOG.warn("Account {} is NOT activate (status {})", (Object)acctDao.getAccountId(), (Object)acctDao.getStatus());
                }
                ProblemDetail problem = new ProblemDetail(AcmeUtil.ACCOUNT_DEACTIVATED, title, HttpStatus.BAD_REQUEST, "", NO_INSTANCE);
                throw new AcmeProblemException(problem);
            }
            Pipeline pipeline = this.getPipelineForRealm(realm);
            if (!pipeline.isActive().booleanValue()) {
                String msg = "Deactivated pipeline '" + pipeline.getName() + "' found for request realm '" + realm + "'";
                LOG.info(msg);
                ProblemDetail problemDetail = new ProblemDetail(AcmeUtil.MALFORMED, "Realm unknown", HttpStatus.BAD_REQUEST, msg, NO_INSTANCE);
                throw new AcmeProblemException(problemDetail);
            }
            this.jwtUtil.validateSignature(context, acctDao.getPublicKey(), acctDao.getAccountId().longValue());
            return acctDao;
        }
        catch (IOException | InvalidJwtException | JoseException e) {
            LOG.debug("Problem processing JWT payload for Account ", e);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "JWT validation problem", HttpStatus.BAD_REQUEST, e.getMessage(), NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
    }

    protected void checkNonce(JsonWebStructure webStruct) throws JoseException, AcmeProblemException {
        String reqNonce = this.jwtUtil.getNonce(webStruct);
        List nonceList = this.nonceRepository.findByNonceValue(reqNonce);
        if (nonceList.isEmpty()) {
            LOG.debug("Nonce {} not found in database", (Object)reqNonce);
            ProblemDetail problem = new ProblemDetail(AcmeUtil.BAD_NONCE, "Nonce not known.", HttpStatus.BAD_REQUEST, NO_DETAIL, NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
        this.nonceRepository.deleteAll((Iterable)nonceList);
        LOG.debug("Nonce found ... and deleted");
    }

    protected HttpHeaders buildNonceHeader() {
        HttpHeaders additionalHeaders = new HttpHeaders();
        AcmeNonce nonce = this.getNewNonce();
        additionalHeaders.set(REPLAY_NONCE_HEADER, nonce.getNonceValue());
        return additionalHeaders;
    }

    protected ResponseEntity<?> buildProblemResponseEntity(AcmeProblemException e) {
        LOG.debug("returning ACME problem ", (Throwable)e);
        HttpHeaders problemHeaders = new HttpHeaders();
        problemHeaders.setContentType(ProblemDetail.APPLICATION_PROBLEM_JSON);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)e.getProblem().getStatus()).headers(problemHeaders)).body((Object)e.getProblem());
    }

    protected AcmeNonce getNewNonce() {
        AcmeNonce nonce = new AcmeNonce();
        String nonceRaw = this.getBase64UrlEncodedRandom(16);
        nonce.setNonceValue(nonceRaw.split("=")[0]);
        Calendar cal = Calendar.getInstance();
        cal.add(5, DEFAULT_NONCE_VALID_DAYS);
        nonce.setExpiresAt(DateUtil.asInstant((java.util.Date)new Date(cal.getTimeInMillis())));
        this.nonceRepository.save((Object)nonce);
        LOG.debug("New Nonce {} created", (Object)nonce.getNonceValue());
        return nonce;
    }

    protected String getRandomChallenge() {
        String challengeToken = this.getBase64UrlEncodedRandom(16);
        return challengeToken.split("=")[0];
    }

    public String getBase64UrlEncodedRandom(int len) {
        byte[] randomBytes = new byte[len];
        this.secRandom.nextBytes(randomBytes);
        return Base64Utils.encodeToUrlSafeString((byte[])randomBytes);
    }

    public long generateId() {
        long val = this.secRandom.nextLong();
        if (val < 0L) {
            return val * -1L;
        }
        return val;
    }
}

