/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.domain.AcmeAccount;
import de.trustable.ca3s.core.domain.AcmeAuthorization;
import de.trustable.ca3s.core.domain.AcmeChallenge;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.enumeration.AcmeOrderStatus;
import de.trustable.ca3s.core.domain.enumeration.ChallengeStatus;
import de.trustable.ca3s.core.repository.AcmeAuthorizationRepository;
import de.trustable.ca3s.core.service.dto.acme.AuthorizationResponse;
import de.trustable.ca3s.core.service.dto.acme.ChallengeResponse;
import de.trustable.ca3s.core.service.dto.acme.IdentifierResponse;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.AcmeUtil;
import de.trustable.ca3s.core.service.util.DateUtil;
import de.trustable.ca3s.core.web.rest.acme.AcmeController;
import de.trustable.ca3s.core.web.rest.acme.ChallengeController;
import de.trustable.ca3s.core.web.rest.util.RateLimiter;
import java.net.URI;
import java.time.Instant;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import org.jose4j.jwt.consumer.JwtContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@Transactional(dontRollbackOn={AcmeProblemException.class})
@RestController
@RequestMapping(value={"/acme/{realm}/authorization"})
public class AuthorizationController
extends AcmeController {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationController.class);
    private final boolean rejectGet;
    private final boolean iterateChallengesOnGet;
    private final ChallengeController challengeController;
    private final AcmeAuthorizationRepository authorizationRepository;
    private final RateLimiter rateLimiter;
    private final HttpServletRequest request;

    public AuthorizationController(@Value(value="${ca3s.acme.reject.get:true}") boolean rejectGet, @Value(value="${ca3s.acme.iterate.challenges:true}") boolean iterateChallengesOnGet, ChallengeController challengeController, AcmeAuthorizationRepository authorizationRepository, HttpServletRequest request, @Value(value="${ca3s.acme.ratelimit.second:0}") int rateSec, @Value(value="${ca3s.acme.ratelimit.minute:20}") int rateMin, @Value(value="${ca3s.acme.ratelimit.hour:0}") int rateHour) {
        this.rejectGet = rejectGet;
        this.iterateChallengesOnGet = iterateChallengesOnGet;
        this.challengeController = challengeController;
        this.authorizationRepository = authorizationRepository;
        this.request = request;
        this.rateLimiter = new RateLimiter("Authorization", rateSec, rateMin, rateHour);
    }

    @RequestMapping(value={"/{authorizationId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<?> getAuthorization(@PathVariable long authorizationId, @PathVariable String realm, @RequestHeader(value="X-CA3S-Forwarded-Host", required=false) String forwardedHost) {
        LOG.info("Received Authorization request 'get' ");
        this.rateLimiter.checkRateLimit(authorizationId, realm);
        if (LOG.isDebugEnabled()) {
            Enumeration headerNames = this.request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String key = (String)headerNames.nextElement();
                String value = this.request.getHeader(key);
                LOG.debug("header {} : {} ", (Object)key, (Object)value);
            }
        }
        HttpHeaders additionalHeaders = this.buildNonceHeader();
        if (this.rejectGet) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).headers(additionalHeaders)).build();
        }
        List authList = this.authorizationRepository.findByAcmeAuthorizationId(authorizationId);
        if (authList.isEmpty()) {
            return ResponseEntity.notFound().headers(additionalHeaders).build();
        }
        AcmeAuthorization authDao = (AcmeAuthorization)authList.get(0);
        AuthorizationResponse authResp = this.buildAuthResponse(authDao, realm, forwardedHost);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)authResp);
    }

    @RequestMapping(value={"/{authorizationId}"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/jose+json"})
    public ResponseEntity<?> postAuthorization(@RequestBody String requestBody, @PathVariable long authorizationId, @PathVariable String realm, @RequestHeader(value="X-CA3S-Forwarded-Host", required=false) String forwardedHost) {
        LOG.debug("Received Authorization request ");
        this.rateLimiter.checkRateLimit(authorizationId, realm);
        try {
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            AcmeAccount acctDao = this.checkJWTSignatureForAccount(context, realm);
            HttpHeaders additionalHeaders = this.buildNonceHeader();
            LOG.debug("Looking for Authorization id '{}'", (Object)authorizationId);
            List authList = this.authorizationRepository.findByAcmeAuthorizationId(authorizationId);
            if (authList.isEmpty()) {
                LOG.debug("Authorization id '{}' unknown", (Object)authorizationId);
                return ResponseEntity.notFound().headers(additionalHeaders).build();
            }
            AcmeAuthorization authDao = (AcmeAuthorization)authList.get(0);
            LOG.debug("Authorization id '{}' found", (Object)authorizationId);
            if (!Objects.equals(authDao.getOrder().getAccount().getAccountId(), acctDao.getAccountId())) {
                LOG.warn("Account of signing key {} does not match account id {} associated to given auth{}", new Object[]{acctDao.getAccountId(), authDao.getOrder().getAccount().getAccountId(), authorizationId});
                ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "Account / Auth mismatch", HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
                throw new AcmeProblemException(problem);
            }
            AuthorizationResponse authResp = this.buildAuthResponse(authDao, realm, forwardedHost);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)authResp);
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
        catch (Exception e) {
            LOG.warn("unexpected problem", (Throwable)e);
            throw e;
        }
    }

    private AuthorizationResponse buildAuthResponse(AcmeAuthorization authDao, String realm, String forwardedHost) throws AcmeProblemException {
        AuthorizationResponse authResp = new AuthorizationResponse();
        AcmeOrder order = authDao.getOrder();
        authResp.setExpires(DateUtil.asDate((Instant)order.getExpires()));
        AcmeOrderStatus authStatus = AcmeOrderStatus.PENDING;
        for (Object challDao : authDao.getChallenges()) {
            if (this.iterateChallengesOnGet) {
                this.challengeController.isChallengeSolved((AcmeChallenge)challDao);
            }
            if (challDao.getStatus() != ChallengeStatus.VALID) continue;
            authStatus = AcmeOrderStatus.VALID;
        }
        authResp.setStatus(authStatus);
        HashSet<ChallengeResponse> challResp = new HashSet<ChallengeResponse>();
        for (AcmeChallenge challengeDao : authDao.getChallenges()) {
            ChallengeResponse challenge = new ChallengeResponse(challengeDao, this.locationUriOfChallenge(challengeDao.getId().longValue(), this.getEffectiveUriComponentsBuilder(realm, forwardedHost)).toString());
            challResp.add(challenge);
        }
        authResp.setChallenges(challResp);
        IdentifierResponse identResp = new IdentifierResponse();
        identResp.setType(authDao.getType());
        identResp.setValue(authDao.getValue());
        authResp.setIdentifier(identResp);
        return authResp;
    }

    private URI locationUriOfChallenge(long challengeId, UriComponentsBuilder uriBuilder) {
        return this.challengeResourceUriBuilderFrom(uriBuilder.path("../..")).path("/").path(Long.toString(challengeId)).build().normalize().toUri();
    }
}

