/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.CsrAttribute;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.exception.CAFailureException;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CsrAttributeRepository;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.NotificationService;
import de.trustable.ca3s.core.service.dto.NamedValue;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CertificateProcessingUtil;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import de.trustable.ca3s.core.web.rest.data.AdministrationType;
import de.trustable.ca3s.core.web.rest.data.CSRAdministrationData;
import de.trustable.ca3s.core.web.rest.data.CSRAdministrationResponse;
import de.trustable.ca3s.core.web.rest.util.UserUtil;
import java.time.Instant;
import java.util.HashSet;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class CSRAdministration {
    private final Logger LOG = LoggerFactory.getLogger(CSRAdministration.class);
    private final CSRRepository csrRepository;
    private final CsrAttributeRepository csrAttributeRepository;
    private final CSRUtil csrUtil;
    private final CertificateProcessingUtil cpUtil;
    private final PipelineUtil pipelineUtil;
    private final UserRepository userRepository;
    private final UserUtil userUtil;
    private final AuditService auditService;
    private final NotificationService notificationService;
    private final boolean selfIssuanceAllowed;

    public CSRAdministration(CSRRepository csrRepository, CsrAttributeRepository csrAttributeRepository, CSRUtil csrUtil, CertificateProcessingUtil cpUtil, PipelineUtil pipelineUtil, UserRepository userRepository, UserUtil userUtil, AuditService auditService, NotificationService notificationService, @Value(value="${ca3s.issuance.ra.self-issuance-allowed:false}") boolean selfIssuanceAllowed) {
        this.csrRepository = csrRepository;
        this.csrAttributeRepository = csrAttributeRepository;
        this.csrUtil = csrUtil;
        this.cpUtil = cpUtil;
        this.pipelineUtil = pipelineUtil;
        this.userRepository = userRepository;
        this.userUtil = userUtil;
        this.auditService = auditService;
        this.notificationService = notificationService;
        this.selfIssuanceAllowed = selfIssuanceAllowed;
    }

    @PostMapping(value={"/administerRequest"})
    @Transactional
    public ResponseEntity<CSRAdministrationResponse> administerRequest(@Valid @RequestBody CSRAdministrationData adminData) throws MessagingException {
        this.LOG.debug("REST request to reject / accept CSR : {}", (Object)adminData);
        User currentUser = this.userUtil.getCurrentUser();
        String userName = currentUser.getLogin();
        Optional optCSR = this.csrRepository.findById((Object)adminData.getCsrId());
        if (optCSR.isPresent()) {
            CSR csr = (CSR)optCSR.get();
            if (!this.pipelineUtil.isUserValidAsRA(csr.getPipeline(), currentUser)) {
                this.LOG.warn("REST request by user '{}' to accept CSR '{}' is not allowed by the pipeline!", (Object)userName, (Object)adminData.getCsrId());
                return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
            }
            if (userName.equals(csr.getRequestedBy()) && AdministrationType.ACCEPT.equals((Object)adminData.getAdministrationType())) {
                if (this.selfIssuanceAllowed) {
                    this.LOG.info("REST request by ra officer '{}' to accept CSR '{}' issued by himself accepted!", (Object)userName, (Object)adminData.getCsrId());
                } else {
                    this.LOG.warn("REST request by ra officer '{}' to accept CSR '{}' issued by himself rejected!", (Object)userName, (Object)adminData.getCsrId());
                    return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
                }
            }
            csr.setAdministeredBy(userName);
            this.updateComment(adminData, csr);
            if (AdministrationType.ACCEPT.equals((Object)adminData.getAdministrationType())) {
                Certificate cert;
                csr.setApprovedOn(Instant.now());
                csr.setAcceptedBy(userName);
                this.updateComment(adminData, csr);
                this.updateARAttributes(adminData, csr);
                this.csrUtil.setCSRComment(csr, adminData.getComment());
                this.csrRepository.save((Object)csr);
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceCsrAccepted(csr));
                try {
                    cert = this.cpUtil.processCertificateRequestImmediate(csr, userName, "RA_CERTIFICATE_CREATED");
                }
                catch (CAFailureException caFailureException) {
                    this.LOG.info("problem creating certificate", (Throwable)caFailureException);
                    CSRAdministrationResponse csrAdministrationResponse = new CSRAdministrationResponse();
                    csrAdministrationResponse.setAdministrationType(adminData.getAdministrationType());
                    csrAdministrationResponse.setCsrId(adminData.getCsrId());
                    csrAdministrationResponse.setProblemOccured(caFailureException.getMessage());
                    return new ResponseEntity((Object)csrAdministrationResponse, HttpStatus.ACCEPTED);
                }
                if (cert != null) {
                    Optional optUser;
                    HashSet<String> additionalEmailSet = new HashSet<String>();
                    if (cert.getCsr() != null && cert.getCsr().getPipeline() != null) {
                        String emails = this.pipelineUtil.getPipelineAttribute(cert.getCsr().getPipeline(), "ADDITIONAL_EMAIL_RECIPIENTS", "");
                        for (String email : emails.split(",;")) {
                            if (email.trim().isEmpty()) continue;
                            additionalEmailSet.add(email);
                            this.LOG.warn("added additional email address {} to notifier list", (Object)email);
                        }
                    }
                    if ((optUser = this.userRepository.findOneByLogin(csr.getRequestedBy())).isPresent()) {
                        User requestor = (User)optUser.get();
                        if (requestor.getEmail() == null) {
                            this.LOG.debug("Email doesn't exist for user '{}'", (Object)requestor.getLogin());
                        } else {
                            this.notificationService.notifyUserCerificateIssuedAsync(requestor, cert, additionalEmailSet);
                        }
                    } else {
                        this.LOG.warn("certificate requestor '{}' unknown!", (Object)csr.getRequestedBy());
                    }
                    CSRAdministrationResponse csrAdministrationResponse = new CSRAdministrationResponse();
                    csrAdministrationResponse.setAdministrationType(adminData.getAdministrationType());
                    csrAdministrationResponse.setCertId(cert.getId());
                    return new ResponseEntity((Object)csrAdministrationResponse, HttpStatus.CREATED);
                }
                this.LOG.warn("creation of certificate requested for CSR {} failed ", (Object)csr.getId());
                CSRAdministrationResponse csrAdministrationResponse = new CSRAdministrationResponse();
                csrAdministrationResponse.setAdministrationType(adminData.getAdministrationType());
                csrAdministrationResponse.setCsrId(adminData.getCsrId());
                return new ResponseEntity((Object)csrAdministrationResponse, HttpStatus.BAD_REQUEST);
            }
            if (AdministrationType.REJECT.equals((Object)adminData.getAdministrationType())) {
                this.csrUtil.setStatusAndRejectionReason(csr, CsrStatus.REJECTED, adminData.getRejectionReason());
                this.csrRepository.save((Object)csr);
                Optional optUser = this.userRepository.findOneByLogin(csr.getRequestedBy());
                if (optUser.isPresent()) {
                    User requestor = (User)optUser.get();
                    if (requestor.getEmail() == null) {
                        this.LOG.debug("Email doesn't exist for user '{}'", (Object)requestor.getLogin());
                    } else {
                        this.notificationService.notifyUserCerificateRejectedAsync(requestor, csr);
                    }
                } else {
                    this.LOG.warn("certificate requestor '{}' unknown!", (Object)csr.getRequestedBy());
                }
                this.updateComment(adminData, csr);
                this.updateARAttributes(adminData, csr);
                this.csrUtil.setCSRComment(csr, adminData.getComment());
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceCsrRejected(csr));
                CSRAdministrationResponse csrAdministrationResponse = new CSRAdministrationResponse();
                csrAdministrationResponse.setAdministrationType(adminData.getAdministrationType());
                csrAdministrationResponse.setCsrId(adminData.getCsrId());
                return new ResponseEntity((Object)csrAdministrationResponse, HttpStatus.OK);
            }
            if (AdministrationType.UPDATE.equals((Object)adminData.getAdministrationType())) {
                this.updateComment(adminData, csr);
                this.updateARAttributes(adminData, csr);
                this.csrUtil.setCSRComment(csr, adminData.getComment());
                CSRAdministrationResponse csrAdministrationResponse = new CSRAdministrationResponse();
                csrAdministrationResponse.setAdministrationType(adminData.getAdministrationType());
                csrAdministrationResponse.setCsrId(adminData.getCsrId());
                return new ResponseEntity((Object)csrAdministrationResponse, HttpStatus.OK);
            }
            this.LOG.info("administration type '{}' unexpected!", (Object)adminData.getAdministrationType());
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/withdrawOwnRequest"})
    @Transactional
    public ResponseEntity<Long> withdrawOwnRequest(@Valid @RequestBody CSRAdministrationData adminData) {
        this.LOG.debug("REST request to withdraw CSR : {}", (Object)adminData);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String userName = auth.getName();
        Optional optCSR = this.csrRepository.findById((Object)adminData.getCsrId());
        if (optCSR.isPresent()) {
            CSR csr = (CSR)optCSR.get();
            if (userName == null || !userName.equals(csr.getRequestedBy())) {
                this.LOG.debug("REST request by '{}' to withdraw CSR '{}' rejected ", (Object)userName, (Object)adminData.getCsrId());
                return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
            }
            csr.setAdministeredBy(userName);
            this.updateComment(adminData, csr);
            this.csrUtil.setStatusAndRejectionReason(csr, CsrStatus.REJECTED, adminData.getRejectionReason());
            this.csrRepository.save((Object)csr);
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCsrRejected(csr));
            return new ResponseEntity((Object)adminData.getCsrId(), HttpStatus.OK);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/selfAdministerRequest"})
    @Transactional
    public ResponseEntity<Long> selfAdministerRequest(@Valid @RequestBody CSRAdministrationData adminData) {
        this.LOG.debug("REST request to update CSR : {}", (Object)adminData);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String userName = auth.getName();
        Optional optCSR = this.csrRepository.findById((Object)adminData.getCsrId());
        if (optCSR.isPresent()) {
            CSR csr = (CSR)optCSR.get();
            if (userName == null || !userName.equals(csr.getRequestedBy())) {
                this.LOG.debug("REST request by '{}' to update CSR '{}' rejected ", (Object)userName, (Object)adminData.getCsrId());
                return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
            }
            csr.setAdministeredBy(userName);
            this.updateComment(adminData, csr);
            this.updateARAttributes(adminData, csr);
            this.csrRepository.save((Object)csr);
            return new ResponseEntity((Object)adminData.getCsrId(), HttpStatus.OK);
        }
        return ResponseEntity.notFound().build();
    }

    private void updateComment(CSRAdministrationData adminData, CSR csr) {
        this.csrUtil.setCSRComment(csr, adminData.getComment());
    }

    private void updateARAttributes(CSRAdministrationData adminData, CSR csr) {
        for (CsrAttribute csrAttr : csr.getCsrAttributes()) {
            for (NamedValue nv : adminData.getArAttributeArr()) {
                if (!csrAttr.getName().equals("_ARA_" + nv.getName()) || csrAttr.getValue().equals(nv.getValue())) continue;
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceCsrAttribute(csrAttr.getName(), csrAttr.getValue(), nv.getValue(), csr));
                csrAttr.setValue(nv.getValue());
                this.LOG.debug("CSR attribute {} updated to {}", (Object)csrAttr.getName(), (Object)csrAttr.getValue());
            }
        }
        this.csrAttributeRepository.saveAll((Iterable)csr.getCsrAttributes());
    }
}

