/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.PipelineRepository;
import de.trustable.ca3s.core.service.badkeys.BadKeysResult;
import de.trustable.ca3s.core.service.badkeys.BadKeysService;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import de.trustable.ca3s.core.web.rest.data.PKCSDataType;
import de.trustable.ca3s.core.web.rest.data.Pkcs10RequestHolderShallow;
import de.trustable.ca3s.core.web.rest.data.PkcsXXData;
import de.trustable.ca3s.core.web.rest.data.UploadPrecheckData;
import de.trustable.ca3s.core.web.rest.data.X509CertificateHolderShallow;
import de.trustable.util.CryptoUtil;
import de.trustable.util.Pkcs10RequestHolder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.DecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/publicapi"})
public class CSRContentProcessor {
    private final Logger LOG = LoggerFactory.getLogger(CSRContentProcessor.class);
    private final CryptoUtil cryptoUtil;
    private final CSRRepository csrRepository;
    private final CertificateRepository certificateRepository;
    private final CertificateUtil certUtil;
    private final PipelineRepository pipelineRepository;
    private final PipelineUtil pvUtil;
    private final BadKeysService badKeysService;
    private final boolean findReplacementCandidates;

    public CSRContentProcessor(CryptoUtil cryptoUtil, CSRRepository csrRepository, CertificateRepository certificateRepository, CertificateUtil certUtil, PipelineRepository pipelineRepository, PipelineUtil pvUtil, BadKeysService badKeysService, @Value(value="${ca3s.issuance.findReplacements:false}") boolean findReplacementCandidates) {
        this.cryptoUtil = cryptoUtil;
        this.csrRepository = csrRepository;
        this.certificateRepository = certificateRepository;
        this.certUtil = certUtil;
        this.pipelineRepository = pipelineRepository;
        this.pvUtil = pvUtil;
        this.badKeysService = badKeysService;
        this.findReplacementCandidates = findReplacementCandidates;
    }

    @Transactional
    @PostMapping(value={"/describeContent"})
    public ResponseEntity<PkcsXXData> describeContent(@Valid @RequestBody UploadPrecheckData uploaded) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        PkcsXXData p10ReqData = new PkcsXXData();
        String content = uploaded.getContent();
        this.LOG.debug("REST request to describe an object : {}", (Object)content);
        if (content == null || content.trim().isEmpty()) {
            return new ResponseEntity((Object)p10ReqData, HttpStatus.OK);
        }
        try {
            List certList;
            try {
                BufferedReader reader = new BufferedReader(new StringReader(content));
                Object rawBase64 = "";
                String line = reader.readLine();
                while (line != null) {
                    if (line.toUpperCase().contains("-BEGIN CERTIFICATE-")) {
                        this.LOG.debug("PEM certificate start found");
                    } else if (line.toUpperCase().contains("-END CERTIFICATE-")) {
                        this.LOG.debug("PEM certificate end found");
                    } else {
                        rawBase64 = (String)rawBase64 + line.replace("\n", "").replace("\r", "");
                    }
                    line = reader.readLine();
                }
                this.LOG.debug("stripped PEM: {}", rawBase64);
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(Base64.decode((String)rawBase64)));
                content = this.cryptoUtil.x509CertToPem(cert);
                this.LOG.debug("certificate parsed from base64 (non-pem) content");
            }
            catch (IOException | GeneralSecurityException | DecoderException gse) {
                this.LOG.debug("certificate parsing from base64 (non-pem) content failed: {}", (Object)gse.getMessage());
            }
            X509CertificateHolder certHolder = this.cryptoUtil.convertPemToCertificateHolder(content);
            p10ReqData = auth.isAuthenticated() ? new PkcsXXData(certHolder, content, !(certList = this.certificateRepository.findByIssuerSerial(certHolder.getIssuer().toString(), certHolder.getSerialNumber().toString())).isEmpty()) : new PkcsXXData(certHolder, content, false);
            if (this.badKeysService.isInstalled()) {
                ArrayList<CallSite> messageList = new ArrayList<CallSite>();
                BadKeysResult badKeysResult = this.badKeysService.checkContent(content);
                p10ReqData.setBadKeysResult(badKeysResult);
                if (badKeysResult.isValid()) {
                    this.LOG.debug("BadKeys is installed and returns OK");
                } else if (badKeysResult.getResponse() != null && badKeysResult.getResponse().getResults() != null && badKeysResult.getResponse().getResults().getResultType() != null) {
                    messageList.add((CallSite)((Object)("ca3SApp.messages.badkeys." + badKeysResult.getResponse().getResults().getResultType())));
                }
                p10ReqData.setWarnings(messageList.toArray(new String[0]));
            } else {
                this.LOG.debug("BadKeys not installed");
            }
            this.LOG.debug("certificate parsed from uploaded PEM content : " + certHolder.getSubject());
        }
        catch (DecoderException de) {
            p10ReqData.setDataType(PKCSDataType.UNKNOWN);
            this.LOG.debug("certificate parsing problem of uploaded content: " + de.getMessage());
        }
        catch (GeneralSecurityException e) {
            this.LOG.debug("not a certificate, trying to parse it as CSR ");
            try {
                PKCS10CertificationRequest pkcs10CertificationRequest;
                try {
                    pkcs10CertificationRequest = new PKCS10CertificationRequest(Base64.decode((String)content));
                    this.LOG.debug("reading binary CSR succeeded");
                }
                catch (IOException | DecoderException e2) {
                    pkcs10CertificationRequest = this.cryptoUtil.convertPemToPKCS10CertificationRequest(content);
                }
                Pkcs10RequestHolder p10ReqHolder = this.cryptoUtil.parseCertificateRequest(pkcs10CertificationRequest);
                Pkcs10RequestHolderShallow p10ReqHolderShallow = new Pkcs10RequestHolderShallow(p10ReqHolder);
                p10ReqData = new PkcsXXData(p10ReqHolderShallow);
                if (auth.isAuthenticated()) {
                    List csrList = this.csrRepository.findByPublicKeyHash(p10ReqHolder.getPublicKeyHash());
                    this.LOG.debug("public key with hash '{}' used in #{} csrs, yet", (Object)p10ReqHolder.getPublicKeyHash(), (Object)csrList.size());
                    p10ReqData.setCsrPublicKeyPresentInDB(!csrList.isEmpty());
                    ArrayList messageList = new ArrayList();
                    this.handleBadKeys(p10ReqData, pkcs10CertificationRequest, messageList);
                    if (uploaded.getPipelineId() != null) {
                        Optional optPipeline = this.pipelineRepository.findById((Object)uploaded.getPipelineId());
                        if (optPipeline.isPresent()) {
                            if (this.pvUtil.isPipelineRestrictionsResolved((Pipeline)optPipeline.get(), p10ReqHolder, uploaded.getArAttributes(), messageList)) {
                                this.LOG.debug("pipeline restrictions for pipeline '{}' solved", (Object)((Pipeline)optPipeline.get()).getName());
                            } else {
                                p10ReqData.setWarnings(messageList.toArray(new String[0]));
                            }
                        } else {
                            this.LOG.info("pipeline id '{}' not found", (Object)uploaded.getPipelineId());
                        }
                    }
                    if (this.findReplacementCandidates) {
                        List candidates = this.certUtil.findReplaceCandidates(p10ReqData.getP10Holder().getSans());
                        p10ReqData.setReplacementCandidatesFromList(candidates);
                        this.LOG.debug("#{} replacement candidates found", (Object)candidates);
                    } else {
                        this.LOG.debug("retrieval of replacement candidates disabled");
                    }
                }
            }
            catch (IOException | GeneralSecurityException e2) {
                this.LOG.debug("describeCSR : " + e2.getMessage());
                this.LOG.debug("not a certificate, not a CSR, trying to parse it as a P12 container");
                try {
                    KeyStore pkcs12Store = KeyStore.getInstance("PKCS12", "BC");
                    ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode((String)content));
                    char[] passphrase = new char[]{};
                    if (uploaded.getPassphrase() != null && uploaded.getPassphrase().trim().length() > 0) {
                        passphrase = uploaded.getPassphrase().toCharArray();
                    }
                    pkcs12Store.load(bais, passphrase);
                    this.LOG.debug("keystore loaded successfully!");
                    ArrayList<X509CertificateHolderShallow> certList = new ArrayList<X509CertificateHolderShallow>();
                    PKCSDataType dataType = PKCSDataType.CONTAINER;
                    Enumeration<String> en = pkcs12Store.aliases();
                    while (en.hasMoreElements()) {
                        String alias = en.nextElement();
                        this.LOG.debug("iterating keystore, found alias {}, isCertificateEntry {}, isKeyEntry {}", new Object[]{alias, pkcs12Store.isCertificateEntry(alias), pkcs12Store.isKeyEntry(alias)});
                        if (!pkcs12Store.isCertificateEntry(alias) && !pkcs12Store.isKeyEntry(alias)) continue;
                        X509Certificate x509cert = (X509Certificate)pkcs12Store.getCertificate(alias);
                        if (x509cert == null) {
                            this.LOG.debug("alias {} does NOT refer to a certificate entry", (Object)alias);
                            continue;
                        }
                        this.LOG.debug("certificate {} found in PKCS12 for alias {}", (Object)x509cert.getSubjectX500Principal().toString(), (Object)alias);
                        String b64Content = this.cryptoUtil.x509CertToPem(x509cert);
                        X509CertificateHolder certHolder = this.cryptoUtil.convertPemToCertificateHolder(b64Content);
                        X509CertificateHolderShallow x509Holder = new X509CertificateHolderShallow(certHolder);
                        x509Holder.setPemCertificate(b64Content);
                        if (pkcs12Store.isKeyEntry(alias)) {
                            Key key = pkcs12Store.getKey(alias, passphrase);
                            x509Holder.setKeyPresent(true);
                            this.LOG.debug("key {} found alongside certificate in PKCS12 for alias {}", (Object)key, (Object)alias);
                            dataType = PKCSDataType.CONTAINER_WITH_KEY;
                        }
                        certList.add(x509Holder);
                    }
                    p10ReqData = new PkcsXXData();
                    X509CertificateHolderShallow[] chsArr = new X509CertificateHolderShallow[certList.size()];
                    certList.toArray(chsArr);
                    p10ReqData.setCertsHolder(chsArr);
                    p10ReqData.setDataType(dataType);
                }
                catch (IOException ioe) {
                    p10ReqData.setPassphraseRequired(true);
                    p10ReqData.setDataType(PKCSDataType.CONTAINER_REQUIRING_PASSPHRASE);
                    this.LOG.debug("p12 missing a passphrase:", (Throwable)ioe);
                }
                catch (DecoderException de) {
                    p10ReqData.setDataType(PKCSDataType.UNKNOWN);
                    this.LOG.debug("p12 parsing problem of uploaded content: " + de.getMessage());
                }
                catch (GeneralSecurityException e3) {
                    this.LOG.debug("general problem with uploaded content: " + e3.getMessage());
                    return new ResponseEntity(HttpStatus.BAD_REQUEST);
                }
            }
        }
        return new ResponseEntity((Object)p10ReqData, HttpStatus.OK);
    }

    private void handleBadKeys(PkcsXXData p10ReqData, PKCS10CertificationRequest pkcs10CertificationRequest, List<String> messageList) throws IOException {
        if (this.badKeysService.isInstalled()) {
            BadKeysResult badKeysResult = this.badKeysService.checkContent(CryptoUtil.pkcs10RequestToPem((PKCS10CertificationRequest)pkcs10CertificationRequest));
            p10ReqData.setBadKeysResult(badKeysResult);
            if (badKeysResult.isValid()) {
                this.LOG.debug("BadKeys is installed and returns OK");
            } else if (badKeysResult.getResponse() != null && badKeysResult.getResponse().getResults() != null && badKeysResult.getResponse().getResults().getResultType() != null) {
                messageList.add("ca3SApp.messages.badkeys." + badKeysResult.getResponse().getResults().getResultType());
            }
        } else {
            this.LOG.debug("BadKeys not installed");
        }
    }
}

