/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.trustable.ca3s.core.config.CryptoConfiguration;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.Tenant;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.domain.UserPreference;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.domain.enumeration.RDNCardinalityRestriction;
import de.trustable.ca3s.core.repository.CAConnectorConfigRepository;
import de.trustable.ca3s.core.repository.PipelineRepository;
import de.trustable.ca3s.core.repository.UserPreferenceRepository;
import de.trustable.ca3s.core.security.SecurityUtils;
import de.trustable.ca3s.core.service.UserService;
import de.trustable.ca3s.core.service.dto.CAStatus;
import de.trustable.ca3s.core.service.dto.CryptoConfigView;
import de.trustable.ca3s.core.service.dto.PipelineView;
import de.trustable.ca3s.core.service.dto.RDNRestriction;
import de.trustable.ca3s.core.service.dto.UIConfigView;
import de.trustable.ca3s.core.service.util.CaConnectorAdapter;
import de.trustable.ca3s.core.service.util.CertificateSelectionUtil;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import de.trustable.ca3s.core.web.rest.data.CertificateFilterList;
import de.trustable.ca3s.core.web.rest.util.UserUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class UIDatasetSupport {
    private final Logger LOG = LoggerFactory.getLogger(UIDatasetSupport.class);
    private final CAConnectorConfigRepository caConnConfRepo;
    private final CaConnectorAdapter caConnectorAdapter;
    private final PipelineRepository pipelineRepo;
    private final PipelineUtil pipelineUtil;
    private final ProtectedContentUtil protUtil;
    private final UserPreferenceRepository userPreferenceRepository;
    private final UserService userService;
    private final CertificateSelectionUtil certificateSelectionAttributeList;
    private final CryptoConfiguration cryptoConfiguration;
    private final UserUtil userUtil;
    private final boolean autoSSOLogin;
    private final String certificateStoreIsolation;
    private final String[] ssoProvider;

    public UIDatasetSupport(CAConnectorConfigRepository caConnConfRepo, CaConnectorAdapter caConnectorAdapter, PipelineRepository pipelineRepo, PipelineUtil pipelineUtil, ProtectedContentUtil protUtil, UserPreferenceRepository userPreferenceRepository, UserService userService, CertificateSelectionUtil certificateSelectionAttributeList, CryptoConfiguration cryptoConfiguration, UserUtil userUtil, @Value(value="${ca3s.ui.sso.autologin:false}") boolean autoSSOLogin, @Value(value="${ca3s.ui.certificate-store.isolation:none}") String certificateStoreIsolation, @Value(value="${ca3s.ui.sso.provider:}") String[] ssoProvider) {
        this.caConnConfRepo = caConnConfRepo;
        this.caConnectorAdapter = caConnectorAdapter;
        this.pipelineRepo = pipelineRepo;
        this.pipelineUtil = pipelineUtil;
        this.protUtil = protUtil;
        this.userPreferenceRepository = userPreferenceRepository;
        this.userService = userService;
        this.certificateSelectionAttributeList = certificateSelectionAttributeList;
        this.cryptoConfiguration = cryptoConfiguration;
        this.userUtil = userUtil;
        this.autoSSOLogin = autoSSOLogin;
        this.certificateStoreIsolation = certificateStoreIsolation;
        this.ssoProvider = ssoProvider;
    }

    @GetMapping(value={"/ui/config"})
    @Transactional
    public UIConfigView getUIConfig() {
        CryptoConfigView cryptoConfigView = this.cryptoConfiguration.getCryptoConfigView();
        UIConfigView uiConfigView = new UIConfigView(cryptoConfigView, this.autoSSOLogin, this.ssoProvider);
        this.LOG.debug("returning uiConfigView: {}", (Object)uiConfigView);
        return uiConfigView;
    }

    @GetMapping(value={"/pipeline/getWebPipelines"})
    @Transactional
    public List<PipelineView> getWebPipelines() {
        ArrayList<PipelineView> pvList = new ArrayList<PipelineView>();
        if (SecurityUtils.isAuthenticated()) {
            List pipelineList = this.pipelineRepo.findByType(PipelineType.WEB);
            pvList = this.pipelinesToPipelineViews(pipelineList);
        } else {
            this.LOG.debug("returning dummy pipeline view");
            pvList.add(this.getDummyPipelineView());
        }
        return pvList;
    }

    @GetMapping(value={"/pipeline/activeWeb"})
    @Transactional
    public List<PipelineView> activeWeb() {
        User currentUser = this.userUtil.getCurrentUser();
        List<Object> pvList = new ArrayList<PipelineView>();
        if (SecurityUtils.isAuthenticated()) {
            List pipelineList = this.pipelineRepo.findActiveByType(PipelineType.WEB);
            if (UserUtil.isAdministrativeUser((User)currentUser) || "none".equalsIgnoreCase(this.certificateStoreIsolation)) {
                this.LOG.debug("returning all web pipelines");
                pvList = this.pipelinesToPipelineViews(pipelineList);
            } else {
                this.LOG.debug("returning tenant pipelines");
                pvList = this.tenantPipelinesToPipelineViews(currentUser.getTenant(), pipelineList);
            }
            Collections.sort(pvList, new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.LOG.debug("returning dummy pipeline view");
            pvList.add(this.getDummyPipelineView());
        }
        return pvList;
    }

    List<PipelineView> pipelinesToPipelineViews(List<Pipeline> pipelineList) {
        ArrayList<PipelineView> pvList = new ArrayList<PipelineView>();
        pipelineList.forEach(new /* Unavailable Anonymous Inner Class!! */);
        return pvList;
    }

    List<PipelineView> tenantPipelinesToPipelineViews(Tenant tenant, List<Pipeline> pipelineList) {
        ArrayList<PipelineView> pvList = new ArrayList<PipelineView>();
        pipelineList.forEach(new /* Unavailable Anonymous Inner Class!! */);
        return pvList;
    }

    private PipelineView getDummyPipelineView() {
        PipelineView pv_LaxRestrictions = new PipelineView();
        pv_LaxRestrictions.setRestriction_C(new RDNRestriction());
        pv_LaxRestrictions.getRestriction_C().setCardinalityRestriction(RDNCardinalityRestriction.ZERO_OR_ONE);
        pv_LaxRestrictions.getRestriction_C().setRdnName("C");
        pv_LaxRestrictions.setRestriction_CN(new RDNRestriction());
        pv_LaxRestrictions.getRestriction_CN().setCardinalityRestriction(RDNCardinalityRestriction.ZERO_OR_MANY);
        pv_LaxRestrictions.getRestriction_CN().setRdnName("CN");
        pv_LaxRestrictions.setRestriction_L(new RDNRestriction());
        pv_LaxRestrictions.getRestriction_L().setCardinalityRestriction(RDNCardinalityRestriction.ZERO_OR_ONE);
        pv_LaxRestrictions.getRestriction_L().setRdnName("L");
        pv_LaxRestrictions.setRestriction_O(new RDNRestriction());
        pv_LaxRestrictions.getRestriction_O().setCardinalityRestriction(RDNCardinalityRestriction.ZERO_OR_ONE);
        pv_LaxRestrictions.getRestriction_O().setRdnName("O");
        pv_LaxRestrictions.setRestriction_OU(new RDNRestriction());
        pv_LaxRestrictions.getRestriction_OU().setCardinalityRestriction(RDNCardinalityRestriction.ZERO_OR_MANY);
        pv_LaxRestrictions.getRestriction_OU().setRdnName("OU");
        pv_LaxRestrictions.setRestriction_S(new RDNRestriction());
        pv_LaxRestrictions.getRestriction_S().setCardinalityRestriction(RDNCardinalityRestriction.ZERO_OR_ONE);
        pv_LaxRestrictions.getRestriction_S().setRdnName("ST");
        pv_LaxRestrictions.setRestriction_SAN(new RDNRestriction());
        pv_LaxRestrictions.getRestriction_SAN().setCardinalityRestriction(RDNCardinalityRestriction.ZERO_OR_MANY);
        pv_LaxRestrictions.getRestriction_SAN().setRdnName("SAN");
        RDNRestriction[] rdnRestrictArr = new RDNRestriction[]{pv_LaxRestrictions.getRestriction_C(), pv_LaxRestrictions.getRestriction_CN(), pv_LaxRestrictions.getRestriction_L(), pv_LaxRestrictions.getRestriction_O(), pv_LaxRestrictions.getRestriction_OU(), pv_LaxRestrictions.getRestriction_S(), pv_LaxRestrictions.getRestriction_SAN()};
        pv_LaxRestrictions.setRdnRestrictions(rdnRestrictArr);
        pv_LaxRestrictions.setApprovalRequired(Boolean.valueOf(false));
        pv_LaxRestrictions.setCaConnectorName("noConnector");
        pv_LaxRestrictions.setName("noName");
        pv_LaxRestrictions.setType(PipelineType.WEB);
        pv_LaxRestrictions.setUrlPart("noUrl");
        pv_LaxRestrictions.setId(Long.valueOf(Integer.MAX_VALUE));
        return pv_LaxRestrictions;
    }

    @GetMapping(value={"/ca-connector-configs/cert-generators"})
    @PreAuthorize(value="isAuthenticated()")
    public List<CAConnectorConfig> getAllCAConnectorConfigs() {
        return this.caConnConfRepo.findAllCertGenerators();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"/ca-connector-configs/getStatus"})
    @PreAuthorize(value="isAuthenticated()")
    public CAStatus getCAConnectorStatus(@Valid @RequestBody CAConnectorConfig cAConnectorConfig) {
        this.LOG.debug("checking status for {}", (Object)cAConnectorConfig);
        if (cAConnectorConfig.getPlainSecret() == null || cAConnectorConfig.getPlainSecret().trim().length() == 0) {
            cAConnectorConfig.setSecret(null);
        } else if ("******".equals(cAConnectorConfig.getPlainSecret().trim())) {
            Optional optCcc = this.caConnConfRepo.findById((Object)cAConnectorConfig.getId());
            if (!optCcc.isPresent()) return CAStatus.Unknown;
            cAConnectorConfig.setSecret(((CAConnectorConfig)optCcc.get()).getSecret());
        } else {
            ProtectedContent protSecret = this.protUtil.createProtectedContent(cAConnectorConfig.getPlainSecret(), ProtectedContentType.PASSWORD, ContentRelationType.CONNECTION, -1L);
            cAConnectorConfig.setSecret(protSecret);
        }
        CAStatus status = this.caConnectorAdapter.getStatus(cAConnectorConfig);
        this.LOG.debug("CA status for {} is {}", (Object)cAConnectorConfig.getName(), (Object)status);
        return status;
    }

    @GetMapping(value={"/userProperties/{name}"})
    public ResponseEntity<UserPreference> getUserProperties(@PathVariable String name) {
        Optional optUP;
        Optional optUser = this.userService.getUserWithAuthorities();
        if (optUser.isPresent() && (optUP = this.userPreferenceRepository.findByNameforUser(name, ((User)optUser.get()).getId())).isPresent()) {
            return ResponseEntity.ok((Object)((UserPreference)optUP.get()));
        }
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/certificateSelectionAttributes"})
    public ResponseEntity<List<String>> getCertificateSelectionAttributes() {
        return ResponseEntity.ok((Object)this.certificateSelectionAttributeList.getCertificateSelectionAttributes());
    }

    @GetMapping(value={"/userProperties/filterList/{name}"})
    public ResponseEntity<CertificateFilterList> getFilterList(@PathVariable String name) {
        Optional optUser = this.userService.getUserWithAuthorities();
        if (optUser.isPresent()) {
            Optional optUP = this.userPreferenceRepository.findByNameforUser(name, ((User)optUser.get()).getId());
            if (optUP.isPresent()) {
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    CertificateFilterList filterList = (CertificateFilterList)objectMapper.readValue(((UserPreference)optUP.get()).getContent(), CertificateFilterList.class);
                    return ResponseEntity.ok((Object)filterList);
                }
                catch (IOException e) {
                    this.LOG.debug("unmarshalling filterList", (Throwable)e);
                    return ResponseEntity.badRequest().build();
                }
            }
        } else {
            this.LOG.info("reading user properties for unknown user");
        }
        return ResponseEntity.notFound().build();
    }

    @PutMapping(value={"/userProperties/filterList/{name}"})
    public ResponseEntity<UserPreference> putUserProperties(@PathVariable String name, @RequestBody CertificateFilterList filterList) {
        Optional optUser = this.userService.getUserWithAuthorities();
        if (optUser.isPresent()) {
            UserPreference up = new UserPreference();
            up.setName(name);
            Optional optUP = this.userPreferenceRepository.findByNameforUser(name, ((User)optUser.get()).getId());
            if (optUP.isPresent()) {
                up = (UserPreference)optUP.get();
                this.LOG.debug("using existing user properties");
            }
            up.setUserId(((User)optUser.get()).getId());
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                up.setContent(objectMapper.writeValueAsString((Object)filterList));
            }
            catch (JsonProcessingException e) {
                this.LOG.debug("marshalling filterList", (Throwable)e);
                return ResponseEntity.badRequest().build();
            }
            this.userPreferenceRepository.save((Object)up);
        } else {
            this.LOG.info("reading user properties for unknown user");
        }
        return ResponseEntity.noContent().build();
    }
}

