/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.scepservlet;

import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import de.trustable.ca3s.core.web.scepservlet.ScepServletImpl;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Transactional
@RestController
public class Ca3sSCEPServiceResource {
    private final ScepServletImpl scepServlet;
    private final PipelineUtil pipeUtil;
    private static final Logger LOGGER = LoggerFactory.getLogger(Ca3sSCEPServiceResource.class);

    @Autowired
    public Ca3sSCEPServiceResource(ScepServletImpl scepServlet, PipelineUtil pipeUtil) {
        this.scepServlet = scepServlet;
        this.pipeUtil = pipeUtil;
        LOGGER.info("in Ca3sSCEPServiceResource()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/scep/{realm}"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public void handleSCEPRequest(@PathVariable(value="realm") String realm, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        Pipeline pipeline = this.pipeUtil.getPipelineByRealm(PipelineType.SCEP, realm);
        if (pipeline == null) {
            LOGGER.info("no matching pipeline for scep request realm {}", (Object)realm);
        } else if (!pipeline.isActive().booleanValue()) {
            LOGGER.info("Deactivated pipeline '{}' found for scep request realm '{}'", (Object)pipeline.getName(), (Object)realm);
            pipeline = null;
        }
        this.scepServlet.threadLocalPipeline.set(pipeline);
        try {
            this.scepServlet.service(request, response);
        }
        finally {
            this.scepServlet.threadLocalPipeline.remove();
        }
        LOGGER.info("duration of scep processing " + (System.currentTimeMillis() - startTime));
    }
}

