/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.repository;

import de.trustable.ca3s.core.config.audit.AuditEventConverter;
import de.trustable.ca3s.core.domain.PersistentAuditEvent;
import de.trustable.ca3s.core.repository.PersistenceAuditEventRepository;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CustomAuditEventRepository
implements AuditEventRepository {
    private static final String AUTHORIZATION_FAILURE = "AUTHORIZATION_FAILURE";
    protected static final int EVENT_DATA_COLUMN_MAX_LENGTH = 255;
    private final PersistenceAuditEventRepository persistenceAuditEventRepository;
    private final AuditEventConverter auditEventConverter;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public CustomAuditEventRepository(PersistenceAuditEventRepository persistenceAuditEventRepository, AuditEventConverter auditEventConverter) {
        this.persistenceAuditEventRepository = persistenceAuditEventRepository;
        this.auditEventConverter = auditEventConverter;
    }

    public List<AuditEvent> find(String principal, Instant after, String type) {
        List persistentAuditEvents = this.persistenceAuditEventRepository.findByPrincipalAndAuditEventDateAfterAndAuditEventType(principal, after, type);
        return this.auditEventConverter.convertToAuditEvent((Iterable)persistentAuditEvents);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void add(AuditEvent event) {
        if (!AUTHORIZATION_FAILURE.equals(event.getType()) && !"anonymoususer".equals(event.getPrincipal())) {
            PersistentAuditEvent persistentAuditEvent = new PersistentAuditEvent();
            persistentAuditEvent.setPrincipal(event.getPrincipal());
            persistentAuditEvent.setAuditEventType(event.getType());
            persistentAuditEvent.setAuditEventDate(event.getTimestamp());
            Map eventData = this.auditEventConverter.convertDataToStrings(event.getData());
            persistentAuditEvent.setData(this.truncate(eventData));
            this.persistenceAuditEventRepository.save((Object)persistentAuditEvent);
        }
    }

    private Map<String, String> truncate(Map<String, String> data) {
        HashMap<String, String> results = new HashMap<String, String>();
        if (data != null) {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                int length;
                String value = entry.getValue();
                if (value != null && (length = value.length()) > 255) {
                    value = value.substring(0, 255);
                    this.log.warn("Event data for {} too long ({}) has been truncated to {}. Consider increasing column width.", new Object[]{entry.getKey(), length, 255});
                }
                results.put(entry.getKey(), value);
            }
        }
        return results;
    }
}

