/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto.ejbca;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CertificateRestResponse {
    @SerializedName(value="certificate")
    private List<byte[]> certificate = null;
    @SerializedName(value="serial_number")
    private String serialNumber = null;
    @SerializedName(value="response_format")
    private String responseFormat = null;
    @SerializedName(value="certificate_chain")
    private List<List<byte[]>> certificateChain = null;
    @SerializedName(value="certificate_profile")
    private String certificateProfile = null;
    @SerializedName(value="end_entity_profile")
    private String endEntityProfile = null;

    public CertificateRestResponse certificate(List<byte[]> certificate) {
        this.certificate = certificate;
        return this;
    }

    public CertificateRestResponse addCertificateItem(byte[] certificateItem) {
        if (this.certificate == null) {
            this.certificate = new ArrayList();
        }
        this.certificate.add(certificateItem);
        return this;
    }

    @Schema(example="MIIDXzCCA...eW1Zro0=", description="Certificate")
    public List<byte[]> getCertificate() {
        return this.certificate;
    }

    public void setCertificate(List<byte[]> certificate) {
        this.certificate = certificate;
    }

    public CertificateRestResponse serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    @Schema(example="1234567890ABCDEF", description="Hex Serial Number")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public CertificateRestResponse responseFormat(String responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    @Schema(example="DER", description="Response format")
    public String getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(String responseFormat) {
        this.responseFormat = responseFormat;
    }

    public CertificateRestResponse certificateChain(List<List<byte[]>> certificateChain) {
        this.certificateChain = certificateChain;
        return this;
    }

    public CertificateRestResponse addCertificateChainItem(List<byte[]> certificateChainItem) {
        if (this.certificateChain == null) {
            this.certificateChain = new ArrayList();
        }
        this.certificateChain.add(certificateChainItem);
        return this;
    }

    @Schema(example="[\"ABC123efg...345xyz0=\"]", description="Certificate chain")
    public List<List<byte[]>> getCertificateChain() {
        return this.certificateChain;
    }

    public void setCertificateChain(List<List<byte[]>> certificateChain) {
        this.certificateChain = certificateChain;
    }

    public CertificateRestResponse certificateProfile(String certificateProfile) {
        this.certificateProfile = certificateProfile;
        return this;
    }

    @Schema(example="ENDUSER", description="Certificate profile name")
    public String getCertificateProfile() {
        return this.certificateProfile;
    }

    public void setCertificateProfile(String certificateProfile) {
        this.certificateProfile = certificateProfile;
    }

    public CertificateRestResponse endEntityProfile(String endEntityProfile) {
        this.endEntityProfile = endEntityProfile;
        return this;
    }

    @Schema(example="ExampleEEP", description="End Entity profile name")
    public String getEndEntityProfile() {
        return this.endEntityProfile;
    }

    public void setEndEntityProfile(String endEntityProfile) {
        this.endEntityProfile = endEntityProfile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateRestResponse certificateRestResponse = (CertificateRestResponse)o;
        return Objects.equals(this.certificate, certificateRestResponse.certificate) && Objects.equals(this.serialNumber, certificateRestResponse.serialNumber) && Objects.equals(this.responseFormat, certificateRestResponse.responseFormat) && Objects.equals(this.certificateChain, certificateRestResponse.certificateChain) && Objects.equals(this.certificateProfile, certificateRestResponse.certificateProfile) && Objects.equals(this.endEntityProfile, certificateRestResponse.endEntityProfile);
    }

    public int hashCode() {
        return Objects.hash(this.certificate, this.serialNumber, this.responseFormat, this.certificateChain, this.certificateProfile, this.endEntityProfile);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CertificateRestResponse {\n");
        sb.append("    certificate: ").append(this.toIndentedString((Object)this.certificate)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString((Object)this.serialNumber)).append("\n");
        sb.append("    responseFormat: ").append(this.toIndentedString((Object)this.responseFormat)).append("\n");
        sb.append("    certificateChain: ").append(this.toIndentedString((Object)this.certificateChain)).append("\n");
        sb.append("    certificateProfile: ").append(this.toIndentedString((Object)this.certificateProfile)).append("\n");
        sb.append("    endEntityProfile: ").append(this.toIndentedString((Object)this.endEntityProfile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

