/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto.ejbca;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class KeyStoreRestRequest {
    @SerializedName(value="username")
    private String username = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="key_alg")
    private String keyAlg = null;
    @SerializedName(value="key_spec")
    private String keySpec = null;

    public KeyStoreRestRequest username(String username) {
        this.username = username;
        return this;
    }

    @Schema(example="JohnDoe", description="Username")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public KeyStoreRestRequest password(String password) {
        this.password = password;
        return this;
    }

    @Schema(example="foo123", description="Password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public KeyStoreRestRequest keyAlg(String keyAlg) {
        this.keyAlg = keyAlg;
        return this;
    }

    @Schema(example="RSA", description="Key algorithm used for enrollment")
    public String getKeyAlg() {
        return this.keyAlg;
    }

    public void setKeyAlg(String keyAlg) {
        this.keyAlg = keyAlg;
    }

    public KeyStoreRestRequest keySpec(String keySpec) {
        this.keySpec = keySpec;
        return this;
    }

    @Schema(example="4096", description="Key specification to use")
    public String getKeySpec() {
        return this.keySpec;
    }

    public void setKeySpec(String keySpec) {
        this.keySpec = keySpec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyStoreRestRequest keyStoreRestRequest = (KeyStoreRestRequest)o;
        return Objects.equals(this.username, keyStoreRestRequest.username) && Objects.equals(this.password, keyStoreRestRequest.password) && Objects.equals(this.keyAlg, keyStoreRestRequest.keyAlg) && Objects.equals(this.keySpec, keyStoreRestRequest.keySpec);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password, this.keyAlg, this.keySpec);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KeyStoreRestRequest {\n");
        sb.append("    username: ").append(this.toIndentedString((Object)this.username)).append("\n");
        sb.append("    password: ").append(this.toIndentedString((Object)this.password)).append("\n");
        sb.append("    keyAlg: ").append(this.toIndentedString((Object)this.keyAlg)).append("\n");
        sb.append("    keySpec: ").append(this.toIndentedString((Object)this.keySpec)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

