/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.html;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/error"})
public class ErrorController {
    static final String prefixHTML = "<html>\n<head>\n<meta charset=\"UTF-8\">\n<title>ca3s Error</title>\n<link rel=\"stylesheet\" href=\"../../css/modest.css\">\n</head>\n<body>\n";
    static final String postfixHTML = "\n</body>\n</html>";
    @Value(value="${ca3s.error.en:classpath:error/error_en.md}")
    private Resource helpResourceEn;
    @Value(value="${ca3s.error.de:classpath:error/error_de.md}")
    private Resource helpResourceDe;

    @RequestMapping(value={"/error-{lang}.html"}, produces={"text/html"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public String helpAsHTML(@PathVariable String lang) throws IOException {
        Resource helpResource = this.helpResourceEn;
        if ("de".equalsIgnoreCase(lang)) {
            helpResource = this.helpResourceDe;
        }
        MutableDataSet options = new MutableDataSet();
        Parser parser = Parser.builder((DataHolder)options).build();
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).build();
        Document document = parser.parseReader((Reader)new InputStreamReader(helpResource.getInputStream(), "UTF-8"));
        return prefixHTML + renderer.render((Node)document) + postfixHTML;
    }

    @GetMapping(value={"/error-{lang}.md"}, produces={"text/markdown; charset=UTF-8"})
    @ResponseBody
    public String helpAsMD(@PathVariable String lang) throws IOException {
        Resource helpResource = this.helpResourceEn;
        if ("de".equalsIgnoreCase(lang)) {
            helpResource = this.helpResourceDe;
        }
        return IOUtils.toString((Reader)new InputStreamReader(helpResource.getInputStream(), "UTF-8"));
    }
}

